/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild;

import io.mvnpm.esbuild.BuildEventListener;
import io.mvnpm.esbuild.BundleException;
import io.mvnpm.esbuild.model.EsBuildConfig;
import io.mvnpm.esbuild.model.ExecuteResult;
import io.mvnpm.esbuild.model.WatchBuildResult;
import io.mvnpm.esbuild.model.WatchStartResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Execute {
    private static final ExecutorService EXECUTOR_STREAMER = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "Process stdout streamer");
        t.setDaemon(true);
        return t;
    });
    private static final ExecutorService EXECUTOR_BUILD_LISTENERS = Executors.newSingleThreadExecutor(r -> new Thread(r, "Build Listeners"));
    private static final Logger logger = Logger.getLogger(Execute.class.getName());
    private final Path workDir;
    private final File esBuildExec;
    private EsBuildConfig esBuildConfig;
    private String[] args;

    public Execute(Path workDir, File esBuildExec, EsBuildConfig esBuildConfig) {
        this.workDir = workDir;
        this.esBuildExec = esBuildExec;
        this.esBuildConfig = esBuildConfig;
    }

    public Execute(Path workDir, File esBuildExec, String[] args) {
        this.workDir = workDir;
        this.esBuildExec = esBuildExec;
        this.args = args;
    }

    public ExecuteResult executeAndWait() throws IOException {
        Process process = this.createProcess(this.getCommand(), Optional.empty());
        try {
            int exitCode = process.waitFor();
            String content = Execute.readStream(process.getInputStream());
            String errors = Execute.readStream(process.getErrorStream());
            if (exitCode != 0) {
                throw new BundleException(errors.isEmpty() ? "Unexpected Error during bundling" : errors, content);
            }
            return new ExecuteResult(content);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public WatchStartResult watch(BuildEventListener listener) throws IOException {
        Process process = this.createProcess(this.getCommand(), Optional.of(listener));
        try {
            InputStream processStream = process.getInputStream();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference result = new AtomicReference();
            EXECUTOR_STREAMER.execute(new Streamer(process::isAlive, processStream, r -> {
                if (latch.getCount() == 1L) {
                    result.set(r);
                    latch.countDown();
                } else {
                    listener.onBuild(r);
                }
            }, r -> {
                if (latch.getCount() == 1L) {
                    result.set(r);
                    latch.countDown();
                } else if (!r.isSuccess()) {
                    listener.onBuild((WatchBuildResult)r);
                }
            }));
            latch.await();
            if (!process.isAlive() && !((WatchBuildResult)result.get()).isSuccess()) {
                throw ((WatchBuildResult)result.get()).bundleException();
            }
            return new WatchStartResult((WatchBuildResult)result.get(), process);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private String[] getCommand() {
        CharSequence[] command;
        CharSequence[] charSequenceArray = command = this.args != null ? this.getCommand(this.args) : this.getCommand(this.esBuildConfig);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "running esbuild with flags: \n > `{0}`", String.join((CharSequence)" ", command));
        }
        return command;
    }

    private String[] getCommand(EsBuildConfig esBuildConfig) {
        String[] params = esBuildConfig.toParams();
        return this.getCommand(params);
    }

    private String[] getCommand(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(args.length + 1);
        argList.add(this.esBuildExec.toString());
        argList.addAll(Arrays.asList(args));
        return (String[])argList.toArray(String[]::new);
    }

    public Process createProcess(String[] command, Optional<BuildEventListener> listener) throws IOException {
        return new ProcessBuilder(new String[0]).redirectErrorStream(listener.isPresent()).directory(this.workDir.toFile()).command(command).start();
    }

    private static String readStream(InputStream stream) {
        StringBuilder s = new StringBuilder();
        Execute.consumeStream(() -> true, stream, l -> s.append((String)l).append("\n"));
        return s.toString();
    }

    private static void consumeStream(BooleanSupplier stayAlive, InputStream stream, Consumer<String> newLineConsumer) {
        try (InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(in);){
            String line;
            while ((line = reader.readLine()) != null) {
                newLineConsumer.accept(line);
                if (stayAlive.getAsBoolean()) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private record Streamer(BooleanSupplier isAlive, InputStream processStream, BuildEventListener listener, Consumer<WatchBuildResult> onExit) implements Runnable
    {
        @Override
        public void run() {
            AtomicBoolean hasError = new AtomicBoolean();
            StringBuilder outputBuilder = new StringBuilder();
            Execute.consumeStream(this.isAlive, this.processStream, l -> {
                logger.fine((String)l);
                outputBuilder.append("\n").append((String)l);
                if (l.contains("build finished")) {
                    logger.fine("Build finished!");
                    String output = outputBuilder.toString();
                    boolean error = hasError.getAndSet(false);
                    outputBuilder.setLength(0);
                    EXECUTOR_BUILD_LISTENERS.execute(() -> {
                        if (!error) {
                            this.listener.onBuild(new WatchBuildResult(output));
                        } else {
                            this.listener.onBuild(new WatchBuildResult(output, new BundleException("Error during bundling", output)));
                        }
                    });
                } else if (l.contains("[ERROR]")) {
                    hasError.set(true);
                }
            });
            if (!hasError.get()) {
                this.onExit.accept(new WatchBuildResult(outputBuilder.toString()));
            } else {
                this.onExit.accept(new WatchBuildResult(outputBuilder.toString(), new BundleException("Process exited with error", outputBuilder.toString())));
            }
        }
    }
}

