/*
 * Decompiled with CFR 0.152.
 */
package io.mvnpm.esbuild.resolve;

import io.mvnpm.esbuild.Bundler;
import io.mvnpm.esbuild.resolve.Resolver;
import io.mvnpm.esbuild.resolve.Resolvers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;

public class BundledResolver
implements Resolver {
    private final Resolver fallbackResolver;

    public BundledResolver(Resolver fallbackResolver) {
        this.fallbackResolver = fallbackResolver;
    }

    @Override
    public Path resolve(String version) throws IOException {
        String bundledExecutableRelativePath;
        Path path = Resolvers.getLocation(Bundler.ESBUILD_EMBEDDED_VERSION);
        Path executablePath = path.resolve(bundledExecutableRelativePath = Resolvers.resolveBundledExecutablePath());
        if (Files.isExecutable(executablePath)) {
            return executablePath;
        }
        InputStream resource = this.getClass().getResourceAsStream("/esbuild-%s-%s.tgz".formatted(Resolvers.CLASSIFIER, version));
        if (resource != null) {
            return Resolvers.extract(resource, Bundler.ESBUILD_EMBEDDED_VERSION).resolve(bundledExecutableRelativePath);
        }
        return this.fallbackResolver.resolve(version);
    }
}

