/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.websub.api.verifier;

import io.mosip.kernel.websub.api.constants.WebSubClientErrorCode;
import io.mosip.kernel.websub.api.exception.WebSubClientException;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class AuthenticatedContentVerifier {
    private static final String METHOD_SIGNATURE_SPLITTER = "=";

    public boolean verifyAuthorizedContentVerified(HttpServletRequest httpServletRequest, String secret) {
        String body = null;
        try {
            body = httpServletRequest.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException exception) {
            throw new WebSubClientException(WebSubClientErrorCode.IO_ERROR.getErrorCode(), WebSubClientErrorCode.IO_ERROR.getErrorMessage().concat(exception.getMessage()));
        }
        String hubSignature = httpServletRequest.getHeader("x-hub-signature");
        return this.isContentVerified(secret, body, hubSignature);
    }

    public boolean isContentVerified(String secret, String body, String hubSignature) {
        if (hubSignature != null && !hubSignature.isEmpty()) {
            String[] signatureSplit = hubSignature.split(METHOD_SIGNATURE_SPLITTER);
            String method = signatureSplit[0];
            String signature = signatureSplit[1];
            HMac hMac = null;
            switch (method) {
                case "SHA1": {
                    hMac = new HMac((Digest)new SHA1Digest());
                    break;
                }
                case "SHA256": {
                    hMac = new HMac((Digest)new SHA256Digest());
                    break;
                }
                case "SHA384": {
                    hMac = new HMac((Digest)new SHA384Digest());
                    break;
                }
                case "SHA512": {
                    hMac = new HMac((Digest)new SHA512Digest());
                    break;
                }
                default: {
                    hMac = new HMac((Digest)new SHA256Digest());
                }
            }
            KeyParameter params = new KeyParameter(secret.getBytes());
            hMac.init((CipherParameters)params);
            hMac.update(body.getBytes(), 0, body.getBytes().length);
            byte[] result = new byte[hMac.getMacSize()];
            hMac.doFinal(result, 0);
            String expectedHash = DatatypeConverter.printHexBinary((byte[])result).toLowerCase();
            return expectedHash.equals(signature);
        }
        throw new WebSubClientException(WebSubClientErrorCode.AUTHENTTICATED_CONTENT_VERIFICATION_HEADER_ERROR.getErrorCode(), WebSubClientErrorCode.AUTHENTTICATED_CONTENT_VERIFICATION_HEADER_ERROR.getErrorMessage());
    }
}

