/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.websub.api.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.core.websub.spi.SubscriptionClient;
import io.mosip.kernel.core.websub.spi.SubscriptionExtendedClient;
import io.mosip.kernel.websub.api.annotation.Generated;
import io.mosip.kernel.websub.api.config.publisher.RestTemplateHelper;
import io.mosip.kernel.websub.api.constants.HubMode;
import io.mosip.kernel.websub.api.constants.WebSubClientErrorCode;
import io.mosip.kernel.websub.api.exception.WebSubClientException;
import io.mosip.kernel.websub.api.model.FailedContentRequest;
import io.mosip.kernel.websub.api.model.FailedContentResponse;
import io.mosip.kernel.websub.api.model.HubResponse;
import io.mosip.kernel.websub.api.model.SubscriptionChangeRequest;
import io.mosip.kernel.websub.api.model.SubscriptionChangeResponse;
import io.mosip.kernel.websub.api.model.UnsubscriptionRequest;
import io.mosip.kernel.websub.api.util.ParseUtil;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.util.UriComponentsBuilder;

public class SubscriberClientImpl
implements SubscriptionClient<SubscriptionChangeRequest, UnsubscriptionRequest, SubscriptionChangeResponse>,
SubscriptionExtendedClient<FailedContentResponse, FailedContentRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriberClientImpl.class);
    @Autowired
    private RestTemplateHelper restTemplateHelper;
    @Autowired
    private ObjectMapper objectMapper;

    public SubscriptionChangeResponse subscribe(SubscriptionChangeRequest subscriptionRequest) {
        this.verifySubscribeModel(subscriptionRequest);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"hub.mode", (Object)HubMode.SUBSCRIBE.gethubModeValue());
        map.add((Object)"hub.topic", (Object)subscriptionRequest.getTopic());
        map.add((Object)"hub.callback", (Object)subscriptionRequest.getCallbackURL().concat("?intentMode=").concat(HubMode.SUBSCRIBE.gethubModeValue()));
        map.add((Object)"hub.secret", (Object)subscriptionRequest.getSecret());
        if (subscriptionRequest.getLeaseSeconds() > 0) {
            map.add((Object)"hub.lease_seconds", (Object)Integer.toString(subscriptionRequest.getLeaseSeconds()));
        }
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.restTemplateHelper.getRestTemplate().exchange(subscriptionRequest.getHubURL(), HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException exception) {
            throw new WebSubClientException(WebSubClientErrorCode.SUBSCRIBE_ERROR.getErrorCode(), WebSubClientErrorCode.SUBSCRIBE_ERROR.getErrorMessage() + exception.getResponseBodyAsString());
        }
        if (response != null && response.getStatusCode() == HttpStatus.ACCEPTED) {
            LOGGER.info("subscribing for topic {} at hub", (Object)subscriptionRequest.getTopic());
            SubscriptionChangeResponse subscriptionChangeResponse = new SubscriptionChangeResponse();
            subscriptionChangeResponse.setHubURL(subscriptionRequest.getHubURL());
            subscriptionChangeResponse.setTopic(subscriptionRequest.getTopic());
            return subscriptionChangeResponse;
        }
        if (response != null && response.getStatusCode() == HttpStatus.OK) {
            HubResponse hubResponse = ParseUtil.parseHubResponse((String)response.getBody());
            if (hubResponse.getHubResult().equals("accepted")) {
                LOGGER.info("subscribing for topic {} at hub", (Object)subscriptionRequest.getTopic());
                SubscriptionChangeResponse subscriptionChangeResponse = new SubscriptionChangeResponse();
                subscriptionChangeResponse.setHubURL(subscriptionRequest.getHubURL());
                subscriptionChangeResponse.setTopic(subscriptionRequest.getTopic());
                return subscriptionChangeResponse;
            }
            LOGGER.error(WebSubClientErrorCode.SUBSCRIBE_ERROR.getErrorMessage() + (String)response.getBody());
            throw new WebSubClientException(WebSubClientErrorCode.SUBSCRIBE_ERROR.getErrorCode(), WebSubClientErrorCode.SUBSCRIBE_ERROR.getErrorMessage() + hubResponse.getErrorReason());
        }
        throw new WebSubClientException(WebSubClientErrorCode.SUBSCRIBE_ERROR.getErrorCode(), WebSubClientErrorCode.SUBSCRIBE_ERROR.getErrorMessage() + (String)response.getBody());
    }

    private void verifySubscribeModel(SubscriptionChangeRequest subscriptionRequest) {
        if (EmptyCheckUtils.isNullEmpty((String)subscriptionRequest.getCallbackURL())) {
            throw new WebSubClientException(WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorCode(), WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorMessage().concat("callback url is null or empty"));
        }
        if (EmptyCheckUtils.isNullEmpty((String)subscriptionRequest.getHubURL())) {
            throw new WebSubClientException(WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorCode(), WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorMessage().concat("HUB url is null or empty"));
        }
        if (EmptyCheckUtils.isNullEmpty((String)subscriptionRequest.getSecret())) {
            throw new WebSubClientException(WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorCode(), WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorMessage().concat("secret is null or empty"));
        }
        if (EmptyCheckUtils.isNullEmpty((String)subscriptionRequest.getTopic())) {
            throw new WebSubClientException(WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorCode(), WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorMessage().concat("topic is null or empty"));
        }
    }

    private void verifyUnsubscribeModel(UnsubscriptionRequest unsubscriptionRequest) {
        if (EmptyCheckUtils.isNullEmpty((String)unsubscriptionRequest.getCallbackURL())) {
            throw new WebSubClientException(WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorCode(), WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorMessage().concat("callback url is null or empty"));
        }
        if (EmptyCheckUtils.isNullEmpty((String)unsubscriptionRequest.getHubURL())) {
            throw new WebSubClientException(WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorCode(), WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorMessage().concat("HUB url is null or empty"));
        }
        if (EmptyCheckUtils.isNullEmpty((String)unsubscriptionRequest.getTopic())) {
            throw new WebSubClientException(WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorCode(), WebSubClientErrorCode.INPUT_VERIFICATION_ERROR.getErrorMessage().concat("topic is null or empty"));
        }
    }

    public SubscriptionChangeResponse unSubscribe(UnsubscriptionRequest unsubscriptionRequest) {
        this.verifyUnsubscribeModel(unsubscriptionRequest);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"hub.mode", (Object)HubMode.UNSUBSCRIBE.gethubModeValue());
        map.add((Object)"hub.topic", (Object)unsubscriptionRequest.getTopic());
        map.add((Object)"hub.callback", (Object)unsubscriptionRequest.getCallbackURL().concat("?intentMode=").concat(HubMode.UNSUBSCRIBE.gethubModeValue()));
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.restTemplateHelper.getRestTemplate().exchange(unsubscriptionRequest.getHubURL(), HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException exception) {
            throw new WebSubClientException(WebSubClientErrorCode.UNSUBSCRIBE_ERROR.getErrorCode(), WebSubClientErrorCode.UNSUBSCRIBE_ERROR.getErrorMessage() + exception.getResponseBodyAsString());
        }
        if (response != null && response.getStatusCode() == HttpStatus.ACCEPTED) {
            LOGGER.info("unsubscribed for topic {} at hub", (Object)unsubscriptionRequest.getTopic());
            SubscriptionChangeResponse subscriptionChangeResponse = new SubscriptionChangeResponse();
            subscriptionChangeResponse.setHubURL(unsubscriptionRequest.getHubURL());
            subscriptionChangeResponse.setTopic(unsubscriptionRequest.getTopic());
            return subscriptionChangeResponse;
        }
        if (response != null && response.getStatusCode() == HttpStatus.OK) {
            HubResponse hubResponse = ParseUtil.parseHubResponse((String)response.getBody());
            if (hubResponse.getHubResult().equals("accepted")) {
                LOGGER.info("unsubscribed for topic {} at hub", (Object)unsubscriptionRequest.getTopic());
                SubscriptionChangeResponse subscriptionChangeResponse = new SubscriptionChangeResponse();
                subscriptionChangeResponse.setHubURL(unsubscriptionRequest.getHubURL());
                subscriptionChangeResponse.setTopic(unsubscriptionRequest.getTopic());
                return subscriptionChangeResponse;
            }
            LOGGER.error(WebSubClientErrorCode.UNSUBSCRIBE_ERROR.getErrorMessage() + (String)response.getBody());
            throw new WebSubClientException(WebSubClientErrorCode.UNSUBSCRIBE_ERROR.getErrorCode(), WebSubClientErrorCode.UNSUBSCRIBE_ERROR.getErrorMessage() + hubResponse.getErrorReason());
        }
        throw new WebSubClientException(WebSubClientErrorCode.UNSUBSCRIBE_ERROR.getErrorCode(), WebSubClientErrorCode.UNSUBSCRIBE_ERROR.getErrorMessage() + (String)response.getBody());
    }

    @Generated
    @Deprecated
    public FailedContentResponse getFailedContent(FailedContentRequest failedContentRequest) {
        int pageIndex = failedContentRequest.getPaginationIndex() < 0 ? 0 : failedContentRequest.getPaginationIndex();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        if (failedContentRequest.getMessageCount() > 0) {
            headers.set("X-Subscriber-Signature", this.getHmac256(failedContentRequest.getTopic() + failedContentRequest.getCallbackURL() + failedContentRequest.getTimestamp() + String.valueOf(pageIndex) + String.valueOf(failedContentRequest.getMessageCount()), failedContentRequest.getSecret()));
        } else {
            headers.set("X-Subscriber-Signature", this.getHmac256(failedContentRequest.getTopic() + failedContentRequest.getCallbackURL() + failedContentRequest.getTimestamp() + String.valueOf(pageIndex), failedContentRequest.getSecret()));
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)failedContentRequest.getHubURL()).queryParam("topic", new Object[]{failedContentRequest.getTopic()}).queryParam("callback", new Object[]{Base64.encodeBase64URLSafeString((byte[])failedContentRequest.getCallbackURL().getBytes())}).queryParam("timestamp", new Object[]{failedContentRequest.getTimestamp()}).queryParam("pageindex", new Object[]{pageIndex}).queryParam("messageCount", new Object[]{failedContentRequest.getMessageCount() <= 0 ? null : Integer.valueOf(failedContentRequest.getMessageCount())});
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplateHelper.getRestTemplate().exchange(builder.toUriString(), HttpMethod.GET, entity, String.class, new Object[0]);
        FailedContentResponse failedContentResponse = null;
        try {
            failedContentResponse = (FailedContentResponse)this.objectMapper.readValue((String)response.getBody(), FailedContentResponse.class);
        }
        catch (IOException e) {
            LOGGER.error(WebSubClientErrorCode.IO_ERROR.getErrorMessage() + e.getMessage());
        }
        return failedContentResponse;
    }

    @Generated
    private String getHmac256(String value, String secret) {
        HmacUtils hmacUtils = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, secret);
        return Base64.encodeBase64String((byte[])hmacUtils.hmac(value));
    }
}

