/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.websub.api.client;

import io.mosip.kernel.core.websub.spi.PublisherClient;
import io.mosip.kernel.websub.api.config.publisher.RestTemplateHelper;
import io.mosip.kernel.websub.api.constants.HubMode;
import io.mosip.kernel.websub.api.constants.WebSubClientErrorCode;
import io.mosip.kernel.websub.api.exception.WebSubClientException;
import io.mosip.kernel.websub.api.model.HubResponse;
import io.mosip.kernel.websub.api.util.ParseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.util.UriComponentsBuilder;

public class PublisherClientImpl<P>
implements PublisherClient<String, P, HttpHeaders> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublisherClientImpl.class);
    @Autowired
    private RestTemplateHelper restTemplateHelper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerTopic(String topic, String hubURL) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"hub.mode", (Object)HubMode.REGISTER.gethubModeValue());
        map.add((Object)"hub.topic", (Object)topic);
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.restTemplateHelper.getRestTemplate().exchange(hubURL, HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException exception) {
            throw new WebSubClientException(WebSubClientErrorCode.REGISTER_ERROR.getErrorCode(), WebSubClientErrorCode.REGISTER_ERROR.getErrorMessage() + exception.getResponseBodyAsString());
        }
        if (response != null && response.getStatusCode() == HttpStatus.ACCEPTED) {
            LOGGER.info("topic {} registered at hub", (Object)topic);
            return;
        } else {
            if (response == null || response.getStatusCode() != HttpStatus.OK) throw new WebSubClientException(WebSubClientErrorCode.REGISTER_ERROR.getErrorCode(), WebSubClientErrorCode.REGISTER_ERROR.getErrorMessage() + (String)response.getBody());
            HubResponse hubResponse = ParseUtil.parseHubResponse((String)response.getBody());
            if (hubResponse.getHubResult().equals("accepted")) {
                LOGGER.info("topic {} registered at hub", (Object)topic);
                return;
            } else {
                LOGGER.error(WebSubClientErrorCode.REGISTER_ERROR.getErrorMessage() + (String)response.getBody());
                throw new WebSubClientException(WebSubClientErrorCode.REGISTER_ERROR.getErrorCode(), WebSubClientErrorCode.REGISTER_ERROR.getErrorMessage() + hubResponse.getErrorReason());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterTopic(String topic, String hubURL) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"hub.mode", (Object)HubMode.UNREGISTER.gethubModeValue());
        map.add((Object)"hub.topic", (Object)topic);
        HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.restTemplateHelper.getRestTemplate().exchange(hubURL, HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException exception) {
            throw new WebSubClientException(WebSubClientErrorCode.UNREGISTER_ERROR.getErrorCode(), WebSubClientErrorCode.UNREGISTER_ERROR.getErrorMessage() + exception.getResponseBodyAsString());
        }
        if (response != null && response.getStatusCode() == HttpStatus.ACCEPTED) {
            LOGGER.info("topic {} unregistered at hub", (Object)topic);
            return;
        } else {
            if (response == null || response.getStatusCode() != HttpStatus.OK) throw new WebSubClientException(WebSubClientErrorCode.UNREGISTER_ERROR.getErrorCode(), WebSubClientErrorCode.UNREGISTER_ERROR.getErrorMessage() + (String)response.getBody());
            HubResponse hubResponse = ParseUtil.parseHubResponse((String)response.getBody());
            if (hubResponse.getHubResult().equals("accepted")) {
                LOGGER.info("topic {} unregistered at hub", (Object)topic);
                return;
            } else {
                LOGGER.error(WebSubClientErrorCode.UNREGISTER_ERROR.getErrorMessage() + (String)response.getBody());
                throw new WebSubClientException(WebSubClientErrorCode.UNREGISTER_ERROR.getErrorCode(), WebSubClientErrorCode.UNREGISTER_ERROR.getErrorMessage() + hubResponse.getErrorReason());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void publishUpdate(String topic, P payload, String contentType, HttpHeaders headers, String hubURL) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.parseMediaType((String)contentType));
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)hubURL).queryParam("hub.mode", new Object[]{HubMode.PUBLISH.gethubModeValue()}).queryParam("hub.topic", new Object[]{topic});
        HttpEntity entity = new HttpEntity(payload, (MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.restTemplateHelper.getRestTemplate().exchange(builder.toUriString(), HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException exception) {
            throw new WebSubClientException(WebSubClientErrorCode.PUBLISH_ERROR.getErrorCode(), WebSubClientErrorCode.PUBLISH_ERROR.getErrorMessage() + exception.getResponseBodyAsString());
        }
        if (response != null && response.getStatusCode() == HttpStatus.ACCEPTED) {
            LOGGER.info("published topic {} update at hub", (Object)topic);
            return;
        } else {
            if (response == null || response.getStatusCode() != HttpStatus.OK) throw new WebSubClientException(WebSubClientErrorCode.PUBLISH_ERROR.getErrorCode(), WebSubClientErrorCode.PUBLISH_ERROR.getErrorMessage() + (String)response.getBody());
            HubResponse hubResponse = ParseUtil.parseHubResponse((String)response.getBody());
            if (hubResponse.getHubResult().equals("accepted")) {
                LOGGER.info("published topic {} update at hub", (Object)topic);
                return;
            } else {
                LOGGER.error(WebSubClientErrorCode.PUBLISH_ERROR.getErrorMessage() + (String)response.getBody());
                throw new WebSubClientException(WebSubClientErrorCode.PUBLISH_ERROR.getErrorCode(), WebSubClientErrorCode.PUBLISH_ERROR.getErrorMessage() + hubResponse.getErrorReason());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyUpdate(String topic, HttpHeaders headers, String hubURL) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)hubURL).queryParam("hub.mode", new Object[]{HubMode.PUBLISH.gethubModeValue()}).queryParam("hub.topic", new Object[]{topic});
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.restTemplateHelper.getRestTemplate().exchange(builder.toUriString(), HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException | HttpServerErrorException exception) {
            throw new WebSubClientException(WebSubClientErrorCode.NOTIFY_UPDATE_ERROR.getErrorCode(), WebSubClientErrorCode.NOTIFY_UPDATE_ERROR.getErrorMessage() + exception.getResponseBodyAsString());
        }
        if (response != null && response.getStatusCode() == HttpStatus.ACCEPTED) {
            LOGGER.info("notify topic {} update at hub", (Object)topic);
            return;
        } else {
            if (response == null || response.getStatusCode() != HttpStatus.OK) throw new WebSubClientException(WebSubClientErrorCode.NOTIFY_UPDATE_ERROR.getErrorCode(), WebSubClientErrorCode.NOTIFY_UPDATE_ERROR.getErrorMessage() + (String)response.getBody());
            HubResponse hubResponse = ParseUtil.parseHubResponse((String)response.getBody());
            if (hubResponse.getHubResult().equals("accepted")) {
                LOGGER.info("notify topic {} update at hub", (Object)topic);
                return;
            } else {
                LOGGER.error(WebSubClientErrorCode.NOTIFY_UPDATE_ERROR.getErrorMessage() + (String)response.getBody());
                throw new WebSubClientException(WebSubClientErrorCode.NOTIFY_UPDATE_ERROR.getErrorCode(), WebSubClientErrorCode.NOTIFY_UPDATE_ERROR.getErrorMessage() + hubResponse.getErrorReason());
            }
        }
    }
}

