/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.springdata.v4;

import io.mongock.driver.mongodb.springdata.v4.SpringDataMongoV4DriverBase;
import io.mongock.utils.Constants;
import io.mongock.utils.TimeService;
import io.mongock.utils.annotation.NotThreadSafe;
import org.springframework.data.mongodb.core.MongoTemplate;

@NotThreadSafe
public class SpringDataMongoV4Driver
extends SpringDataMongoV4DriverBase<SpringDataMongoV4Driver> {
    protected SpringDataMongoV4Driver(MongoTemplate mongoTemplate, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(mongoTemplate, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    public static SpringDataMongoV4Driver withDefaultLock(MongoTemplate mongoTemplate) {
        return SpringDataMongoV4Driver.withLockStrategy(mongoTemplate, Constants.DEFAULT_LOCK_ACQUIRED_FOR_MILLIS, Constants.DEFAULT_QUIT_TRYING_AFTER_MILLIS, Constants.DEFAULT_TRY_FREQUENCY_MILLIS);
    }

    public static SpringDataMongoV4Driver withLockStrategy(MongoTemplate mongoTemplate, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        return new SpringDataMongoV4Driver(mongoTemplate, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    @Deprecated
    public static SpringDataMongoV4Driver withLockSetting(MongoTemplate mongoTemplate, long lockAcquiredForMinutes, long maxWaitingForLockMinutes, int maxTries) {
        TimeService timeService = new TimeService();
        return SpringDataMongoV4Driver.withLockStrategy(mongoTemplate, timeService.minutesToMillis(lockAcquiredForMinutes), timeService.minutesToMillis(maxWaitingForLockMinutes * (long)maxTries), 1000L);
    }

    public SpringDataMongoV4Driver copy() {
        SpringDataMongoV4Driver driver = new SpringDataMongoV4Driver(this.mongoTemplate, this.lockAcquiredForMillis, this.lockQuitTryingAfterMillis, this.lockTryFrequencyMillis);
        driver.setIndexCreation(this.indexCreation);
        if (this.isTransactionable()) {
            driver.enableTransaction();
        } else {
            driver.disableTransaction();
        }
        return driver;
    }
}

