/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.jsonrpc.formatter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.moderne.jsonrpc.JsonRpcError;
import io.moderne.jsonrpc.JsonRpcMessage;
import io.moderne.jsonrpc.JsonRpcRequest;
import io.moderne.jsonrpc.JsonRpcSuccess;
import io.moderne.jsonrpc.formatter.MessageFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class JsonMessageFormatter
implements MessageFormatter {
    private final ObjectMapper mapper;

    public JsonMessageFormatter() {
        this(new ObjectMapper().registerModules(new Module[]{new ParameterNamesModule(), new JavaTimeModule()}).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL));
        this.mapper.setVisibility(this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public JsonMessageFormatter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public JsonRpcMessage deserialize(InputStream in) throws IOException {
        Map payload = (Map)this.mapper.readValue(in, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (payload.containsKey("method")) {
            return (JsonRpcMessage)this.mapper.convertValue((Object)payload, JsonRpcRequest.class);
        }
        if (payload.containsKey("error")) {
            return (JsonRpcMessage)this.mapper.convertValue((Object)payload, JsonRpcError.class);
        }
        return (JsonRpcMessage)this.mapper.convertValue((Object)payload, JsonRpcSuccess.class);
    }

    @Override
    public void serialize(JsonRpcMessage message, OutputStream out) throws IOException {
        this.mapper.writeValue(out, (Object)message);
    }
}

