/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.jsonrpc;

import io.moderne.jsonrpc.JsonRpcError;
import io.moderne.jsonrpc.JsonRpcException;
import io.moderne.jsonrpc.JsonRpcMessage;
import io.moderne.jsonrpc.JsonRpcMethod;
import io.moderne.jsonrpc.JsonRpcRequest;
import io.moderne.jsonrpc.JsonRpcResponse;
import io.moderne.jsonrpc.JsonRpcSuccess;
import io.moderne.jsonrpc.handler.MessageHandler;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import lombok.Generated;

public class JsonRpc {
    private final ForkJoinPool forkJoin = new ForkJoinPool(4, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    private final Map<String, JsonRpcMethod<?>> methods = new ConcurrentHashMap();
    private volatile boolean shutdown = false;
    private final MessageHandler messageHandler;
    private final Map<String, CompletableFuture<JsonRpcSuccess>> openRequests = new ConcurrentHashMap<String, CompletableFuture<JsonRpcSuccess>>();

    public <P> JsonRpc rpc(String name, JsonRpcMethod<P> method) {
        this.methods.put(name, method);
        return this;
    }

    public CompletableFuture<JsonRpcSuccess> send(JsonRpcRequest request) {
        CompletableFuture<JsonRpcSuccess> response = new CompletableFuture<JsonRpcSuccess>();
        this.openRequests.put(request.getId(), response);
        this.messageHandler.send(request);
        return response;
    }

    public void notify(JsonRpcRequest request) {
        this.messageHandler.send(request);
    }

    public JsonRpc bind() {
        this.shutdown = false;
        this.forkJoin.submit(new RecursiveAction(){

            @Override
            protected void compute() {
                while (!JsonRpc.this.shutdown) {
                    String requestId = null;
                    try {
                        JsonRpcMessage msg = JsonRpc.this.messageHandler.receive();
                        if (msg instanceof JsonRpcResponse) {
                            JsonRpcResponse response = (JsonRpcResponse)msg;
                            String id = response.getId();
                            if (id == null) continue;
                            CompletableFuture responseFuture = (CompletableFuture)JsonRpc.this.openRequests.remove(id);
                            if (response instanceof JsonRpcError) {
                                responseFuture.completeExceptionally(new JsonRpcException((JsonRpcError)response));
                                continue;
                            }
                            if (!(response instanceof JsonRpcSuccess)) continue;
                            responseFuture.complete((JsonRpcSuccess)response);
                            continue;
                        }
                        if (!(msg instanceof JsonRpcRequest)) continue;
                        JsonRpcRequest request = (JsonRpcRequest)msg;
                        requestId = request.getId();
                        JsonRpcMethod method = (JsonRpcMethod)JsonRpc.this.methods.get(request.getMethod());
                        if (method == null) {
                            JsonRpc.this.messageHandler.send(JsonRpcError.methodNotFound(request.getId(), request.getMethod()));
                            continue;
                        }
                        ForkJoinTask.adapt(() -> {
                            try {
                                Object response = method.convertAndHandle(request.getParams());
                                if (response != null) {
                                    JsonRpc.this.messageHandler.send(new JsonRpcSuccess(request.getId(), response));
                                } else {
                                    JsonRpc.this.messageHandler.send(JsonRpcError.internalError(request.getId(), "Method returned null"));
                                }
                            }
                            catch (Exception e) {
                                JsonRpc.this.messageHandler.send(JsonRpcError.internalError(request.getId(), e));
                            }
                        }).fork();
                    }
                    catch (Throwable t) {
                        JsonRpc.this.messageHandler.send(JsonRpcError.internalError(requestId, t));
                    }
                }
            }
        });
        return this;
    }

    public void shutdown() {
        this.shutdown = true;
        this.forkJoin.shutdown();
    }

    @Generated
    public JsonRpc(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }
}

