/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.conformance.server;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.transport.DefaultServerTransportSecurityValidator;
import io.modelcontextprotocol.server.transport.HttpServletStreamableServerTransportProvider;
import io.modelcontextprotocol.server.transport.ServerTransportSecurityValidator;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import jakarta.servlet.Servlet;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConformanceServlet {
    private static final Logger logger = LoggerFactory.getLogger(ConformanceServlet.class);
    private static final int PORT = 8080;
    private static final String MCP_ENDPOINT = "/mcp";
    private static final McpSchema.JsonSchema EMPTY_JSON_SCHEMA = new McpSchema.JsonSchema("object", Collections.emptyMap(), null, null, null, null);
    private static final String RED_PIXEL_PNG = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mP8z8DwHwAFBQIAX8jx0gAAAABJRU5ErkJggg==";
    private static final String MINIMAL_WAV = "UklGRiQAAABXQVZFZm10IBAAAAABAAEAQB8AAAB9AAACABAAZGF0YQAAAAA=";

    public static void main(String[] args) throws Exception {
        logger.info("Starting MCP Conformance Tests - Servlet Server");
        HttpServletStreamableServerTransportProvider transportProvider = HttpServletStreamableServerTransportProvider.builder().mcpEndpoint(MCP_ENDPOINT).keepAliveInterval(Duration.ofSeconds(30L)).securityValidator((ServerTransportSecurityValidator)DefaultServerTransportSecurityValidator.builder().allowedOrigin("http://localhost:*").allowedHost("localhost:*").build()).build();
        McpSyncServer mcpServer = McpServer.sync((McpStreamableServerTransportProvider)transportProvider).serverInfo("mcp-conformance-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().completions().resources(Boolean.valueOf(true), Boolean.valueOf(false)).tools(Boolean.valueOf(false)).prompts(Boolean.valueOf(false)).build()).tools(ConformanceServlet.createToolSpecs()).prompts(ConformanceServlet.createPromptSpecs()).resources(ConformanceServlet.createResourceSpecs()).resourceTemplates(ConformanceServlet.createResourceTemplateSpecs()).completions(ConformanceServlet.createCompletionSpecs()).requestTimeout(Duration.ofSeconds(30L)).build();
        Tomcat tomcat = ConformanceServlet.createEmbeddedTomcat(transportProvider);
        try {
            tomcat.start();
            logger.info("Conformance MCP Servlet Server started on port {} with endpoint {}", (Object)8080, (Object)MCP_ENDPOINT);
            logger.info("Server URL: http://localhost:{}{}", (Object)8080, (Object)MCP_ENDPOINT);
            tomcat.getServer().await();
        }
        catch (LifecycleException e) {
            logger.error("Failed to start Tomcat server", (Throwable)e);
            throw e;
        }
        finally {
            logger.info("Shutting down MCP server...");
            mcpServer.closeGracefully();
            try {
                tomcat.stop();
                tomcat.destroy();
            }
            catch (LifecycleException e) {
                logger.error("Error during Tomcat shutdown", (Throwable)e);
            }
        }
    }

    private static Tomcat createEmbeddedTomcat(HttpServletStreamableServerTransportProvider transportProvider) {
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(8080);
        String baseDir = System.getProperty("java.io.tmpdir");
        tomcat.setBaseDir(baseDir);
        Context context = tomcat.addContext("", baseDir);
        Wrapper wrapper = context.createWrapper();
        wrapper.setName("mcpServlet");
        wrapper.setServlet((Servlet)transportProvider);
        wrapper.setLoadOnStartup(1);
        wrapper.setAsyncSupported(true);
        context.addChild((Container)wrapper);
        context.addServletMappingDecoded("/*", "mcpServlet");
        Connector connector = tomcat.getConnector();
        connector.setAsyncTimeout(30000L);
        return tomcat;
    }

    private static List<McpServerFeatures.SyncToolSpecification> createToolSpecs() {
        return List.of(McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_simple_text").description("Returns simple text content for testing").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_simple_text' called");
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent("This is a simple text response for testing."))).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_image_content").description("Returns image content for testing").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_image_content' called");
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.ImageContent(null, RED_PIXEL_PNG, "image/png"))).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_audio_content").description("Returns audio content for testing").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_audio_content' called");
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.AudioContent(null, MINIMAL_WAV, "audio/wav"))).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_embedded_resource").description("Returns embedded resource content for testing").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_embedded_resource' called");
            McpSchema.TextResourceContents resourceContents = new McpSchema.TextResourceContents("test://embedded-resource", "text/plain", "This is an embedded resource content.");
            McpSchema.EmbeddedResource embeddedResource = new McpSchema.EmbeddedResource(null, (McpSchema.ResourceContents)resourceContents);
            return McpSchema.CallToolResult.builder().content(List.of(embeddedResource)).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_multiple_content_types").description("Returns multiple content types for testing").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_multiple_content_types' called");
            McpSchema.TextResourceContents resourceContents = new McpSchema.TextResourceContents("test://mixed-content-resource", "application/json", "{\"test\":\"data\",\"value\":123}");
            McpSchema.EmbeddedResource embeddedResource = new McpSchema.EmbeddedResource(null, (McpSchema.ResourceContents)resourceContents);
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent("Multiple content types test:"), new McpSchema.ImageContent(null, RED_PIXEL_PNG, "image/png"), embeddedResource)).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_tool_with_logging").description("Tool that sends log messages during execution").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_tool_with_logging' called");
            exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.INFO).data("Tool execution started").build());
            exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.INFO).data("Tool processing data").build());
            exchange.loggingNotification(McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.INFO).data("Tool execution completed").build());
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent("Tool execution completed with logging"))).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_error_handling").description("Tool that returns an error for testing error handling").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_error_handling' called");
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent("This tool intentionally returns an error for testing"))).isError(Boolean.valueOf(true)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_tool_with_progress").description("Tool that reports progress notifications").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_tool_with_progress' called");
            Object progressToken = request.meta().get("progressToken");
            if (progressToken != null) {
                exchange.progressNotification(new McpSchema.ProgressNotification(progressToken, 0.0, Double.valueOf(100.0), null));
                exchange.progressNotification(new McpSchema.ProgressNotification(progressToken, 50.0, Double.valueOf(100.0), null));
                exchange.progressNotification(new McpSchema.ProgressNotification(progressToken, 100.0, Double.valueOf(100.0), null));
                return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent("Tool execution completed with progress"))).isError(Boolean.valueOf(false)).build();
            }
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent("Tool execution completed without progress"))).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_sampling").description("Tool that requests LLM sampling from client").inputSchema(new McpSchema.JsonSchema("object", Map.of("prompt", Map.of("type", "string", "description", "The prompt to send to the LLM")), List.of("prompt"), null, null, null)).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_sampling' called");
            String prompt = (String)request.arguments().get("prompt");
            McpSchema.CreateMessageRequest samplingRequest = McpSchema.CreateMessageRequest.builder().messages(List.of(new McpSchema.SamplingMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent(prompt)))).maxTokens(100).build();
            McpSchema.CreateMessageResult response = exchange.createMessage(samplingRequest);
            String responseText = "LLM response: " + ((McpSchema.TextContent)response.content()).text();
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent(responseText))).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_elicitation").description("Tool that requests user input from client").inputSchema(new McpSchema.JsonSchema("object", Map.of("message", Map.of("type", "string", "description", "The message to show the user")), List.of("message"), null, null, null)).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_elicitation' called");
            String message = (String)request.arguments().get("message");
            Map<String, List<String>> requestedSchema = Map.of("type", "object", "properties", Map.of("username", Map.of("type", "string", "description", "User's response"), "email", Map.of("type", "string", "description", "User's email address")), "required", List.of("username", "email"));
            McpSchema.ElicitRequest elicitRequest = new McpSchema.ElicitRequest(message, requestedSchema);
            McpSchema.ElicitResult response = exchange.createElicitation(elicitRequest);
            String responseText = "User response: action=" + String.valueOf(response.action()) + ", content=" + String.valueOf(response.content());
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent(responseText))).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_elicitation_sep1034_defaults").description("Tool that requests elicitation with default values for all primitive types").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_elicitation_sep1034_defaults' called");
            Map<String, List<String>> requestedSchema = Map.of("type", "object", "properties", Map.of("name", Map.of("type", "string", "default", "John Doe"), "age", Map.of("type", "integer", "default", 30), "score", Map.of("type", "number", "default", 95.5), "status", Map.of("type", "string", "enum", List.of("active", "inactive", "pending"), "default", "active"), "verified", Map.of("type", "boolean", "default", true)), "required", List.of("name", "age", "score", "status", "verified"));
            McpSchema.ElicitRequest elicitRequest = new McpSchema.ElicitRequest("Please provide your information with defaults", requestedSchema);
            McpSchema.ElicitResult response = exchange.createElicitation(elicitRequest);
            String responseText = "Elicitation completed: action=" + String.valueOf(response.action()) + ", content=" + String.valueOf(response.content());
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent(responseText))).isError(Boolean.valueOf(false)).build();
        }).build(), McpServerFeatures.SyncToolSpecification.builder().tool(McpSchema.Tool.builder().name("test_elicitation_sep1330_enums").description("Tool that requests elicitation with enum schema improvements").inputSchema(EMPTY_JSON_SCHEMA).build()).callHandler((exchange, request) -> {
            logger.info("Tool 'test_elicitation_sep1330_enums' called");
            Map<String, List<String>> requestedSchema = Map.of("type", "object", "properties", Map.of("untitledSingle", Map.of("type", "string", "enum", List.of("option1", "option2", "option3")), "titledSingle", Map.of("type", "string", "oneOf", List.of(Map.of("const", "value1", "title", "First Option"), Map.of("const", "value2", "title", "Second Option"), Map.of("const", "value3", "title", "Third Option"))), "legacyEnum", Map.of("type", "string", "enum", List.of("opt1", "opt2", "opt3"), "enumNames", List.of("Option One", "Option Two", "Option Three")), "untitledMulti", Map.of("type", "array", "items", Map.of("type", "string", "enum", List.of("option1", "option2", "option3"))), "titledMulti", Map.of("type", "array", "items", Map.of("anyOf", List.of(Map.of("const", "value1", "title", "First Choice"), Map.of("const", "value2", "title", "Second Choice"), Map.of("const", "value3", "title", "Third Choice"))))), "required", List.of("untitledSingle", "titledSingle", "legacyEnum", "untitledMulti", "titledMulti"));
            McpSchema.ElicitRequest elicitRequest = new McpSchema.ElicitRequest("Select your preferences", requestedSchema);
            McpSchema.ElicitResult response = exchange.createElicitation(elicitRequest);
            String responseText = "Elicitation completed: action=" + String.valueOf(response.action()) + ", content=" + String.valueOf(response.content());
            return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent(responseText))).isError(Boolean.valueOf(false)).build();
        }).build());
    }

    private static List<McpServerFeatures.SyncPromptSpecification> createPromptSpecs() {
        return List.of(new McpServerFeatures.SyncPromptSpecification(new McpSchema.Prompt("test_simple_prompt", null, "A simple prompt for testing", List.of()), (exchange, request) -> {
            logger.info("Prompt 'test_simple_prompt' requested");
            return new McpSchema.GetPromptResult(null, List.of(new McpSchema.PromptMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("This is a simple prompt for testing."))));
        }), new McpServerFeatures.SyncPromptSpecification(new McpSchema.Prompt("test_prompt_with_arguments", null, "A prompt with arguments for testing", List.of(new McpSchema.PromptArgument("arg1", "First test argument", Boolean.valueOf(true)), new McpSchema.PromptArgument("arg2", "Second test argument", Boolean.valueOf(true)))), (exchange, request) -> {
            logger.info("Prompt 'test_prompt_with_arguments' requested");
            String arg1 = (String)request.arguments().get("arg1");
            String arg2 = (String)request.arguments().get("arg2");
            String text = String.format("Prompt with arguments: arg1='%s', arg2='%s'", arg1, arg2);
            return new McpSchema.GetPromptResult(null, List.of(new McpSchema.PromptMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent(text))));
        }), new McpServerFeatures.SyncPromptSpecification(new McpSchema.Prompt("test_prompt_with_embedded_resource", null, "A prompt with embedded resource for testing", List.of(new McpSchema.PromptArgument("resourceUri", "URI of the resource to embed", Boolean.valueOf(true)))), (exchange, request) -> {
            logger.info("Prompt 'test_prompt_with_embedded_resource' requested");
            String resourceUri = (String)request.arguments().get("resourceUri");
            McpSchema.TextResourceContents resourceContents = new McpSchema.TextResourceContents(resourceUri, "text/plain", "Embedded resource content for testing.");
            McpSchema.EmbeddedResource embeddedResource = new McpSchema.EmbeddedResource(null, (McpSchema.ResourceContents)resourceContents);
            return new McpSchema.GetPromptResult(null, List.of(new McpSchema.PromptMessage(McpSchema.Role.USER, (McpSchema.Content)embeddedResource), new McpSchema.PromptMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Please process the embedded resource above."))));
        }), new McpServerFeatures.SyncPromptSpecification(new McpSchema.Prompt("test_prompt_with_image", null, "A prompt with image content for testing", List.of()), (exchange, request) -> {
            logger.info("Prompt 'test_prompt_with_image' requested");
            return new McpSchema.GetPromptResult(null, List.of(new McpSchema.PromptMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.ImageContent(null, RED_PIXEL_PNG, "image/png")), new McpSchema.PromptMessage(McpSchema.Role.USER, (McpSchema.Content)new McpSchema.TextContent("Please analyze the image above."))));
        }));
    }

    private static List<McpServerFeatures.SyncResourceSpecification> createResourceSpecs() {
        return List.of(new McpServerFeatures.SyncResourceSpecification(McpSchema.Resource.builder().uri("test://static-text").name("Static Text Resource").description("A static text resource for testing").mimeType("text/plain").build(), (exchange, request) -> {
            logger.info("Resource 'test://static-text' requested");
            return new McpSchema.ReadResourceResult(List.of(new McpSchema.TextResourceContents("test://static-text", "text/plain", "This is the content of the static text resource.")));
        }), new McpServerFeatures.SyncResourceSpecification(McpSchema.Resource.builder().uri("test://static-binary").name("Static Binary Resource").description("A static binary resource for testing").mimeType("image/png").build(), (exchange, request) -> {
            logger.info("Resource 'test://static-binary' requested");
            return new McpSchema.ReadResourceResult(List.of(new McpSchema.BlobResourceContents("test://static-binary", "image/png", RED_PIXEL_PNG)));
        }), new McpServerFeatures.SyncResourceSpecification(McpSchema.Resource.builder().uri("test://watched-resource").name("Watched Resource").description("A resource that can be subscribed to for updates").mimeType("text/plain").build(), (exchange, request) -> {
            logger.info("Resource 'test://watched-resource' requested");
            return new McpSchema.ReadResourceResult(List.of(new McpSchema.TextResourceContents("test://watched-resource", "text/plain", "This is a watched resource content.")));
        }));
    }

    private static List<McpServerFeatures.SyncResourceTemplateSpecification> createResourceTemplateSpecs() {
        return List.of(new McpServerFeatures.SyncResourceTemplateSpecification(McpSchema.ResourceTemplate.builder().uriTemplate("test://template/{id}/data").name("Template Resource").description("A resource template for testing parameter substitution").mimeType("application/json").build(), (exchange, request) -> {
            logger.info("Resource template 'test://template/{{id}}/data' requested for URI: {}", (Object)request.uri());
            String uri = request.uri();
            String id = uri.replaceAll("test://template/(.+)/data", "$1");
            String jsonContent = String.format("{\"id\":\"%s\",\"templateTest\":true,\"data\":\"Data for ID: %s\"}", id, id);
            return new McpSchema.ReadResourceResult(List.of(new McpSchema.TextResourceContents(uri, "application/json", jsonContent)));
        }));
    }

    private static List<McpServerFeatures.SyncCompletionSpecification> createCompletionSpecs() {
        return List.of(new McpServerFeatures.SyncCompletionSpecification((McpSchema.CompleteReference)new McpSchema.PromptReference("test_prompt_with_arguments"), (exchange, request) -> {
            logger.info("Completion requested for prompt 'test_prompt_with_arguments', argument: {}", (Object)request.argument().name());
            return new McpSchema.CompleteResult(new McpSchema.CompleteResult.CompleteCompletion(List.of(), Integer.valueOf(0), Boolean.valueOf(false)));
        }));
    }
}

