/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.util.ToolsUtils;
import java.time.Duration;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class AbstractMcpAsyncServerTests {
    private static final String TEST_TOOL_NAME = "test-tool";
    private static final String TEST_RESOURCE_URI = "test://resource";
    private static final String TEST_PROMPT_NAME = "test-prompt";

    protected abstract McpServer.AsyncSpecification<?> prepareAsyncServerBuilder();

    protected void onStart() {
    }

    protected void onClose() {
    }

    @BeforeEach
    void setUp() {
    }

    @AfterEach
    void tearDown() {
        this.onClose();
    }

    @ParameterizedTest(name="{0} : {displayName} ")
    @ValueSource(strings={"sse", "streamable"})
    void testConstructorWithInvalidArguments(String serverType) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpServer.async((McpServerTransportProvider)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport provider must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.prepareAsyncServerBuilder().serverInfo((McpSchema.Implementation)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Server info must not be null");
    }

    @Test
    void testGracefulShutdown() {
        McpServer.AsyncSpecification<?> builder = this.prepareAsyncServerBuilder();
        McpAsyncServer mcpAsyncServer = builder.serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)mcpAsyncServer.closeGracefully()).verifyComplete();
    }

    @Test
    void testImmediateClose() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> ((McpAsyncServer)mcpAsyncServer).close()).doesNotThrowAnyException();
    }

    @Test
    void testAddToolCall() {
        McpSchema.Tool newTool = McpSchema.Tool.builder().name("new-tool").title("New test tool").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.addTool(McpServerFeatures.AsyncToolSpecification.builder().tool(newTool).callHandler((exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build())).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddDuplicateToolCall() {
        McpSchema.Tool duplicateTool = McpSchema.Tool.builder().name(TEST_TOOL_NAME).title("Duplicate tool").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).toolCall(duplicateTool, (exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build();
        StepVerifier.create((Publisher)mcpAsyncServer.addTool(McpServerFeatures.AsyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build())).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testDuplicateToolCallDuringBuilding() {
        McpSchema.Tool duplicateTool = McpSchema.Tool.builder().name("duplicate-build-toolcall").title("Duplicate toolcall during building").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).toolCall(duplicateTool, (exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).toolCall(duplicateTool, (exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Tool with name 'duplicate-build-toolcall' is already registered.");
    }

    @Test
    void testDuplicateToolsInBatchListRegistration() {
        McpSchema.Tool duplicateTool = McpSchema.Tool.builder().name("batch-list-tool").title("Duplicate tool in batch list").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        List<McpServerFeatures.AsyncToolSpecification> specs = List.of(McpServerFeatures.AsyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build(), McpServerFeatures.AsyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(specs).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Tool with name 'batch-list-tool' is already registered.");
    }

    @Test
    void testDuplicateToolsInBatchVarargsRegistration() {
        McpSchema.Tool duplicateTool = McpSchema.Tool.builder().name("batch-varargs-tool").title("Duplicate tool in batch varargs").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tools(new McpServerFeatures.AsyncToolSpecification[]{McpServerFeatures.AsyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build(), McpServerFeatures.AsyncToolSpecification.builder().tool(duplicateTool).callHandler((exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build()}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Tool with name 'batch-varargs-tool' is already registered.");
    }

    @Test
    void testRemoveTool() {
        McpSchema.Tool too = McpSchema.Tool.builder().name(TEST_TOOL_NAME).title("Duplicate tool").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).toolCall(too, (exchange, request) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build();
        StepVerifier.create((Publisher)mcpAsyncServer.removeTool(TEST_TOOL_NAME)).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentTool() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.removeTool("nonexistent-tool")).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testNotifyToolsListChanged() {
        McpSchema.Tool too = McpSchema.Tool.builder().name(TEST_TOOL_NAME).title("Duplicate tool").inputSchema(ToolsUtils.EMPTY_JSON_SCHEMA).build();
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).toolCall(too, (exchange, args) -> Mono.just((Object)McpSchema.CallToolResult.builder().content(List.of()).isError(Boolean.valueOf(false)).build())).build();
        StepVerifier.create((Publisher)mcpAsyncServer.notifyToolsListChanged()).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testNotifyResourcesListChanged() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)mcpAsyncServer.notifyResourcesListChanged()).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testNotifyResourcesUpdated() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)mcpAsyncServer.notifyResourcesUpdated(new McpSchema.ResourcesUpdatedNotification(TEST_RESOURCE_URI))).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddResource() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.Resource resource = McpSchema.Resource.builder().uri(TEST_RESOURCE_URI).name("Test Resource").title("Test Resource").mimeType("text/plain").description("Test resource description").build();
        McpServerFeatures.AsyncResourceSpecification specification = new McpServerFeatures.AsyncResourceSpecification(resource, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        StepVerifier.create((Publisher)mcpAsyncServer.addResource(specification)).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceWithNullSpecification() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.addResource((McpServerFeatures.AsyncResourceSpecification)null)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalArgumentException.class)).hasMessage("Resource must not be null"));
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceWithoutCapability() {
        McpAsyncServer serverWithoutResources = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        McpSchema.Resource resource = McpSchema.Resource.builder().uri(TEST_RESOURCE_URI).name("Test Resource").title("Test Resource").mimeType("text/plain").description("Test resource description").build();
        McpServerFeatures.AsyncResourceSpecification specification = new McpServerFeatures.AsyncResourceSpecification(resource, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        StepVerifier.create((Publisher)serverWithoutResources.addResource(specification)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Server must be configured with resource capabilities"));
    }

    @Test
    void testRemoveResourceWithoutCapability() {
        McpAsyncServer serverWithoutResources = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)serverWithoutResources.removeResource(TEST_RESOURCE_URI)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Server must be configured with resource capabilities"));
    }

    @Test
    void testListResources() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.Resource resource = McpSchema.Resource.builder().uri(TEST_RESOURCE_URI).name("Test Resource").title("Test Resource").mimeType("text/plain").description("Test resource description").build();
        McpServerFeatures.AsyncResourceSpecification specification = new McpServerFeatures.AsyncResourceSpecification(resource, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        StepVerifier.create((Publisher)mcpAsyncServer.addResource(specification).then(mcpAsyncServer.listResources().collectList())).expectNextMatches(resources -> resources.size() == 1 && ((McpSchema.Resource)resources.get(0)).uri().equals(TEST_RESOURCE_URI)).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRemoveResource() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.Resource resource = McpSchema.Resource.builder().uri(TEST_RESOURCE_URI).name("Test Resource").title("Test Resource").mimeType("text/plain").description("Test resource description").build();
        McpServerFeatures.AsyncResourceSpecification specification = new McpServerFeatures.AsyncResourceSpecification(resource, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        StepVerifier.create((Publisher)mcpAsyncServer.addResource(specification).then(mcpAsyncServer.removeResource(TEST_RESOURCE_URI))).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentResource() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.removeResource("nonexistent://resource")).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceTemplate() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.ResourceTemplate template = McpSchema.ResourceTemplate.builder().uriTemplate("test://template/{id}").name("test-template").description("Test resource template").mimeType("text/plain").build();
        McpServerFeatures.AsyncResourceTemplateSpecification specification = new McpServerFeatures.AsyncResourceTemplateSpecification(template, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        StepVerifier.create((Publisher)mcpAsyncServer.addResourceTemplate(specification)).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceTemplateWithoutCapability() {
        McpAsyncServer serverWithoutResources = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        McpSchema.ResourceTemplate template = McpSchema.ResourceTemplate.builder().uriTemplate("test://template/{id}").name("test-template").description("Test resource template").mimeType("text/plain").build();
        McpServerFeatures.AsyncResourceTemplateSpecification specification = new McpServerFeatures.AsyncResourceTemplateSpecification(template, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        StepVerifier.create((Publisher)serverWithoutResources.addResourceTemplate(specification)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Server must be configured with resource capabilities"));
    }

    @Test
    void testRemoveResourceTemplate() {
        McpSchema.ResourceTemplate template = McpSchema.ResourceTemplate.builder().uriTemplate("test://template/{id}").name("test-template").description("Test resource template").mimeType("text/plain").build();
        McpServerFeatures.AsyncResourceTemplateSpecification specification = new McpServerFeatures.AsyncResourceTemplateSpecification(template, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).resourceTemplates(new McpServerFeatures.AsyncResourceTemplateSpecification[]{specification}).build();
        StepVerifier.create((Publisher)mcpAsyncServer.removeResourceTemplate("test://template/{id}")).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRemoveResourceTemplateWithoutCapability() {
        McpAsyncServer serverWithoutResources = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)serverWithoutResources.removeResourceTemplate("test://template/{id}")).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Server must be configured with resource capabilities"));
    }

    @Test
    void testRemoveNonexistentResourceTemplate() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.removeResourceTemplate("nonexistent://template/{id}")).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testListResourceTemplates() {
        McpSchema.ResourceTemplate template = McpSchema.ResourceTemplate.builder().uriTemplate("test://template/{id}").name("test-template").description("Test resource template").mimeType("text/plain").build();
        McpServerFeatures.AsyncResourceTemplateSpecification specification = new McpServerFeatures.AsyncResourceTemplateSpecification(template, (exchange, req) -> Mono.just((Object)new McpSchema.ReadResourceResult(List.of())));
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).resourceTemplates(new McpServerFeatures.AsyncResourceTemplateSpecification[]{specification}).build();
        StepVerifier.create((Publisher)mcpAsyncServer.listResourceTemplates().collectList()).expectNextMatches(resources -> resources.size() >= 0).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testNotifyPromptsListChanged() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)mcpAsyncServer.notifyPromptsListChanged()).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testAddPromptWithNullSpecification() {
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(false)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer.addPrompt((McpServerFeatures.AsyncPromptSpecification)null)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalArgumentException.class)).hasMessage("Prompt specification must not be null"));
    }

    @Test
    void testAddPromptWithoutCapability() {
        McpAsyncServer serverWithoutPrompts = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        McpSchema.Prompt prompt = new McpSchema.Prompt(TEST_PROMPT_NAME, "Test Prompt", "Test Prompt", List.of());
        McpServerFeatures.AsyncPromptSpecification specification = new McpServerFeatures.AsyncPromptSpecification(prompt, (exchange, req) -> Mono.just((Object)new McpSchema.GetPromptResult("Test prompt description", List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent("Test content"))))));
        StepVerifier.create((Publisher)serverWithoutPrompts.addPrompt(specification)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalStateException.class)).hasMessage("Server must be configured with prompt capabilities"));
    }

    @Test
    void testRemovePromptWithoutCapability() {
        McpAsyncServer serverWithoutPrompts = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        StepVerifier.create((Publisher)serverWithoutPrompts.removePrompt(TEST_PROMPT_NAME)).verifyErrorSatisfies(error -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalStateException.class)).hasMessage("Server must be configured with prompt capabilities"));
    }

    @Test
    void testRemovePrompt() {
        String TEST_PROMPT_NAME_TO_REMOVE = "TEST_PROMPT_NAME678";
        McpSchema.Prompt prompt = new McpSchema.Prompt(TEST_PROMPT_NAME_TO_REMOVE, "Test Prompt", "Test Prompt", List.of());
        McpServerFeatures.AsyncPromptSpecification specification = new McpServerFeatures.AsyncPromptSpecification(prompt, (exchange, req) -> Mono.just((Object)new McpSchema.GetPromptResult("Test prompt description", List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent("Test content"))))));
        McpAsyncServer mcpAsyncServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(true)).build()).prompts(new McpServerFeatures.AsyncPromptSpecification[]{specification}).build();
        StepVerifier.create((Publisher)mcpAsyncServer.removePrompt(TEST_PROMPT_NAME_TO_REMOVE)).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentPrompt() {
        McpAsyncServer mcpAsyncServer2 = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(true)).build()).build();
        StepVerifier.create((Publisher)mcpAsyncServer2.removePrompt("nonexistent-prompt")).verifyComplete();
        Assertions.assertThatCode(() -> mcpAsyncServer2.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }

    @Test
    void testRootsChangeHandlers() {
        McpSchema.Root[] rootsReceived = new McpSchema.Root[1];
        boolean[] consumerCalled = new boolean[1];
        McpAsyncServer singleConsumerServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> Mono.fromRunnable(() -> {
            consumerCalled[0] = true;
            if (!roots.isEmpty()) {
                rootsReceived[0] = (McpSchema.Root)roots.get(0);
            }
        }))).build();
        Assertions.assertThat((Object)singleConsumerServer).isNotNull();
        Assertions.assertThatCode(() -> singleConsumerServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
        this.onClose();
        boolean[] consumer1Called = new boolean[1];
        boolean[] consumer2Called = new boolean[1];
        List[] rootsContent = new List[1];
        McpAsyncServer multipleConsumersServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> Mono.fromRunnable(() -> {
            consumer1Called[0] = true;
            rootsContent[0] = roots;
        }), (exchange, roots) -> Mono.fromRunnable(() -> {
            consumer2Called[0] = true;
        }))).build();
        Assertions.assertThat((Object)multipleConsumersServer).isNotNull();
        Assertions.assertThatCode(() -> multipleConsumersServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
        this.onClose();
        McpAsyncServer errorHandlingServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> {
            throw new RuntimeException("Test error");
        })).build();
        Assertions.assertThat((Object)errorHandlingServer).isNotNull();
        Assertions.assertThatCode(() -> errorHandlingServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
        this.onClose();
        McpAsyncServer noConsumersServer = this.prepareAsyncServerBuilder().serverInfo("test-server", "1.0.0").build();
        Assertions.assertThat((Object)noConsumersServer).isNotNull();
        Assertions.assertThatCode(() -> noConsumersServer.closeGracefully().block(Duration.ofSeconds(10L))).doesNotThrowAnyException();
    }
}

