/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractMcpSyncServerTests {
    private static final String TEST_TOOL_NAME = "test-tool";
    private static final String TEST_RESOURCE_URI = "test://resource";
    private static final String TEST_PROMPT_NAME = "test-prompt";
    String emptyJsonSchema = "{\n\t\"$schema\": \"http://json-schema.org/draft-07/schema#\",\n\t\"type\": \"object\",\n\t\"properties\": {}\n}\n";

    protected abstract McpServerTransportProvider createMcpTransportProvider();

    protected void onStart() {
    }

    protected void onClose() {
    }

    @BeforeEach
    void setUp() {
    }

    @AfterEach
    void tearDown() {
        this.onClose();
    }

    @Test
    void testConstructorWithInvalidArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpServer.sync((McpServerTransportProvider)null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Transport provider must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Server info must not be null");
    }

    @Test
    void testGracefulShutdown() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testImmediateClose() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.close()).doesNotThrowAnyException();
    }

    @Test
    void testGetAsyncServer() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        Assertions.assertThat((Object)mcpSyncServer.getAsyncServer()).isNotNull();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddTool() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        McpSchema.Tool newTool = new McpSchema.Tool("new-tool", "New test tool", this.emptyJsonSchema);
        Assertions.assertThatCode(() -> mcpSyncServer.addTool(new McpServerFeatures.SyncToolSpecification(newTool, (exchange, args) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddDuplicateTool() {
        McpSchema.Tool duplicateTool = new McpSchema.Tool(TEST_TOOL_NAME, "Duplicate tool", this.emptyJsonSchema);
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tool(duplicateTool, (exchange, args) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mcpSyncServer.addTool(new McpServerFeatures.SyncToolSpecification(duplicateTool, (exchange, args) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))))).isInstanceOf(McpError.class)).hasMessage("Tool with name 'test-tool' already exists");
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRemoveTool() {
        McpSchema.Tool tool = new McpSchema.Tool(TEST_TOOL_NAME, "Test tool", this.emptyJsonSchema);
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).tool(tool, (exchange, args) -> new McpSchema.CallToolResult(List.of(), Boolean.valueOf(false))).build();
        Assertions.assertThatCode(() -> mcpSyncServer.removeTool(TEST_TOOL_NAME)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentTool() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().tools(Boolean.valueOf(true)).build()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mcpSyncServer.removeTool("nonexistent-tool")).isInstanceOf(McpError.class)).hasMessage("Tool with name 'nonexistent-tool' not found");
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testNotifyToolsListChanged() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.notifyToolsListChanged()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testNotifyResourcesListChanged() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.notifyResourcesListChanged()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddResource() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        McpSchema.Resource resource = new McpSchema.Resource(TEST_RESOURCE_URI, "Test Resource", "text/plain", "Test resource description", null);
        McpServerFeatures.SyncResourceSpecification specificaiton = new McpServerFeatures.SyncResourceSpecification(resource, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        Assertions.assertThatCode(() -> mcpSyncServer.addResource(specificaiton)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceWithNullSpecifiation() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(false)).build()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mcpSyncServer.addResource((McpServerFeatures.SyncResourceSpecification)null)).isInstanceOf(McpError.class)).hasMessage("Resource must not be null");
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddResourceWithoutCapability() {
        McpSyncServer serverWithoutResources = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        McpSchema.Resource resource = new McpSchema.Resource(TEST_RESOURCE_URI, "Test Resource", "text/plain", "Test resource description", null);
        McpServerFeatures.SyncResourceSpecification specification = new McpServerFeatures.SyncResourceSpecification(resource, (exchange, req) -> new McpSchema.ReadResourceResult(List.of()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutResources.addResource(specification)).isInstanceOf(McpError.class)).hasMessage("Server must be configured with resource capabilities");
    }

    @Test
    void testRemoveResourceWithoutCapability() {
        McpSyncServer serverWithoutResources = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutResources.removeResource(TEST_RESOURCE_URI)).isInstanceOf(McpError.class)).hasMessage("Server must be configured with resource capabilities");
    }

    @Test
    void testNotifyPromptsListChanged() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        Assertions.assertThatCode(() -> mcpSyncServer.notifyPromptsListChanged()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testAddPromptWithNullSpecification() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(false)).build()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mcpSyncServer.addPrompt((McpServerFeatures.SyncPromptSpecification)null)).isInstanceOf(McpError.class)).hasMessage("Prompt specification must not be null");
    }

    @Test
    void testAddPromptWithoutCapability() {
        McpSyncServer serverWithoutPrompts = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        McpSchema.Prompt prompt = new McpSchema.Prompt(TEST_PROMPT_NAME, "Test Prompt", List.of());
        McpServerFeatures.SyncPromptSpecification specificaiton = new McpServerFeatures.SyncPromptSpecification(prompt, (exchange, req) -> new McpSchema.GetPromptResult("Test prompt description", List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent("Test content")))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutPrompts.addPrompt(specificaiton)).isInstanceOf(McpError.class)).hasMessage("Server must be configured with prompt capabilities");
    }

    @Test
    void testRemovePromptWithoutCapability() {
        McpSyncServer serverWithoutPrompts = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serverWithoutPrompts.removePrompt(TEST_PROMPT_NAME)).isInstanceOf(McpError.class)).hasMessage("Server must be configured with prompt capabilities");
    }

    @Test
    void testRemovePrompt() {
        McpSchema.Prompt prompt = new McpSchema.Prompt(TEST_PROMPT_NAME, "Test Prompt", List.of());
        McpServerFeatures.SyncPromptSpecification specificaiton = new McpServerFeatures.SyncPromptSpecification(prompt, (exchange, req) -> new McpSchema.GetPromptResult("Test prompt description", List.of(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, (McpSchema.Content)new McpSchema.TextContent("Test content")))));
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(true)).build()).prompts(new McpServerFeatures.SyncPromptSpecification[]{specificaiton}).build();
        Assertions.assertThatCode(() -> mcpSyncServer.removePrompt(TEST_PROMPT_NAME)).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRemoveNonexistentPrompt() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().prompts(Boolean.valueOf(true)).build()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mcpSyncServer.removePrompt("nonexistent-prompt")).isInstanceOf(McpError.class)).hasMessage("Prompt with name 'nonexistent-prompt' not found");
        Assertions.assertThatCode(() -> mcpSyncServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testRootsChangeHandlers() {
        McpSchema.Root[] rootsReceived = new McpSchema.Root[1];
        boolean[] consumerCalled = new boolean[1];
        McpSyncServer singleConsumerServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchage, roots) -> {
            consumerCalled[0] = true;
            if (!roots.isEmpty()) {
                rootsReceived[0] = (McpSchema.Root)roots.get(0);
            }
        })).build();
        Assertions.assertThat((Object)singleConsumerServer).isNotNull();
        Assertions.assertThatCode(() -> singleConsumerServer.closeGracefully()).doesNotThrowAnyException();
        this.onClose();
        boolean[] consumer1Called = new boolean[1];
        boolean[] consumer2Called = new boolean[1];
        List[] rootsContent = new List[1];
        McpSyncServer multipleConsumersServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> {
            consumer1Called[0] = true;
            rootsContent[0] = roots;
        }, (exchange, roots) -> {
            consumer2Called[0] = true;
        })).build();
        Assertions.assertThat((Object)multipleConsumersServer).isNotNull();
        Assertions.assertThatCode(() -> multipleConsumersServer.closeGracefully()).doesNotThrowAnyException();
        this.onClose();
        McpSyncServer errorHandlingServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").rootsChangeHandlers(List.of((exchange, roots) -> {
            throw new RuntimeException("Test error");
        })).build();
        Assertions.assertThat((Object)errorHandlingServer).isNotNull();
        Assertions.assertThatCode(() -> errorHandlingServer.closeGracefully()).doesNotThrowAnyException();
        this.onClose();
        McpSyncServer noConsumersServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").build();
        Assertions.assertThat((Object)noConsumersServer).isNotNull();
        Assertions.assertThatCode(() -> noConsumersServer.closeGracefully()).doesNotThrowAnyException();
    }

    @Test
    void testLoggingLevels() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().logging().build()).build();
        for (McpSchema.LoggingLevel level : McpSchema.LoggingLevel.values()) {
            McpSchema.LoggingMessageNotification notification = McpSchema.LoggingMessageNotification.builder().level(level).logger("test-logger").data("Test message with level " + String.valueOf(level)).build();
            Assertions.assertThatCode(() -> mcpSyncServer.loggingNotification(notification)).doesNotThrowAnyException();
        }
    }

    @Test
    void testLoggingWithoutCapability() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().build()).build();
        McpSchema.LoggingMessageNotification notification = McpSchema.LoggingMessageNotification.builder().level(McpSchema.LoggingLevel.INFO).logger("test-logger").data("Test log message").build();
        Assertions.assertThatCode(() -> mcpSyncServer.loggingNotification(notification)).doesNotThrowAnyException();
    }

    @Test
    void testLoggingWithNullNotification() {
        McpSyncServer mcpSyncServer = McpServer.sync((McpServerTransportProvider)this.createMcpTransportProvider()).serverInfo("test-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().logging().build()).build();
        Assertions.assertThatThrownBy(() -> mcpSyncServer.loggingNotification(null)).isInstanceOf(McpError.class);
    }
}

