/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.client.LifecycleInitializer;
import io.modelcontextprotocol.client.McpClientFeatures;
import io.modelcontextprotocol.json.TypeRef;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import io.modelcontextprotocol.spec.McpClientSession;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.ToolNameValidator;
import io.modelcontextprotocol.util.Utils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class McpAsyncClient {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncClient.class);
    private static final TypeRef<Void> VOID_TYPE_REFERENCE = new TypeRef<Void>(){};
    public static final TypeRef<Object> OBJECT_TYPE_REF = new TypeRef<Object>(){};
    public static final TypeRef<McpSchema.PaginatedRequest> PAGINATED_REQUEST_TYPE_REF = new TypeRef<McpSchema.PaginatedRequest>(){};
    public static final TypeRef<McpSchema.InitializeResult> INITIALIZE_RESULT_TYPE_REF = new TypeRef<McpSchema.InitializeResult>(){};
    public static final TypeRef<McpSchema.CreateMessageRequest> CREATE_MESSAGE_REQUEST_TYPE_REF = new TypeRef<McpSchema.CreateMessageRequest>(){};
    public static final TypeRef<McpSchema.LoggingMessageNotification> LOGGING_MESSAGE_NOTIFICATION_TYPE_REF = new TypeRef<McpSchema.LoggingMessageNotification>(){};
    public static final TypeRef<McpSchema.ProgressNotification> PROGRESS_NOTIFICATION_TYPE_REF = new TypeRef<McpSchema.ProgressNotification>(){};
    public static final String NEGOTIATED_PROTOCOL_VERSION = "io.modelcontextprotocol.client.negotiated-protocol-version";
    private final McpSchema.ClientCapabilities clientCapabilities;
    private final McpSchema.Implementation clientInfo;
    private final ConcurrentHashMap<String, McpSchema.Root> roots;
    private Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler;
    private Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler;
    private final McpClientTransport transport;
    private final LifecycleInitializer initializer;
    private final JsonSchemaValidator jsonSchemaValidator;
    private final ConcurrentHashMap<String, Map<String, Object>> toolsOutputSchemaCache;
    private final boolean enableCallToolSchemaCaching;
    private static final TypeRef<McpSchema.CallToolResult> CALL_TOOL_RESULT_TYPE_REF = new TypeRef<McpSchema.CallToolResult>(){};
    private static final TypeRef<McpSchema.ListToolsResult> LIST_TOOLS_RESULT_TYPE_REF = new TypeRef<McpSchema.ListToolsResult>(){};
    private static final TypeRef<McpSchema.ListResourcesResult> LIST_RESOURCES_RESULT_TYPE_REF = new TypeRef<McpSchema.ListResourcesResult>(){};
    private static final TypeRef<McpSchema.ReadResourceResult> READ_RESOURCE_RESULT_TYPE_REF = new TypeRef<McpSchema.ReadResourceResult>(){};
    private static final TypeRef<McpSchema.ListResourceTemplatesResult> LIST_RESOURCE_TEMPLATES_RESULT_TYPE_REF = new TypeRef<McpSchema.ListResourceTemplatesResult>(){};
    private static final TypeRef<McpSchema.ListPromptsResult> LIST_PROMPTS_RESULT_TYPE_REF = new TypeRef<McpSchema.ListPromptsResult>(){};
    private static final TypeRef<McpSchema.GetPromptResult> GET_PROMPT_RESULT_TYPE_REF = new TypeRef<McpSchema.GetPromptResult>(){};
    private static final TypeRef<McpSchema.CompleteResult> COMPLETION_COMPLETE_RESULT_TYPE_REF = new TypeRef<McpSchema.CompleteResult>(){};

    McpAsyncClient(McpClientTransport transport, Duration requestTimeout, Duration initializationTimeout, JsonSchemaValidator jsonSchemaValidator, McpClientFeatures.Async features) {
        Assert.notNull(transport, "Transport must not be null");
        Assert.notNull(requestTimeout, "Request timeout must not be null");
        Assert.notNull(initializationTimeout, "Initialization timeout must not be null");
        this.clientInfo = features.clientInfo();
        this.clientCapabilities = features.clientCapabilities();
        this.transport = transport;
        this.roots = new ConcurrentHashMap<String, McpSchema.Root>(features.roots());
        this.jsonSchemaValidator = jsonSchemaValidator;
        this.toolsOutputSchemaCache = new ConcurrentHashMap();
        this.enableCallToolSchemaCaching = features.enableCallToolSchemaCaching();
        HashMap requestHandlers = new HashMap();
        requestHandlers.put("ping", params -> {
            logger.debug("Received ping: {}", (Object)LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            return Mono.just(Map.of());
        });
        if (this.clientCapabilities.roots() != null) {
            requestHandlers.put("roots/list", this.rootsListRequestHandler());
        }
        if (this.clientCapabilities.sampling() != null) {
            if (features.samplingHandler() == null) {
                throw new IllegalArgumentException("Sampling handler must not be null when client capabilities include sampling");
            }
            this.samplingHandler = features.samplingHandler();
            requestHandlers.put("sampling/createMessage", this.samplingCreateMessageHandler());
        }
        if (this.clientCapabilities.elicitation() != null) {
            if (features.elicitationHandler() == null) {
                throw new IllegalArgumentException("Elicitation handler must not be null when client capabilities include elicitation");
            }
            this.elicitationHandler = features.elicitationHandler();
            requestHandlers.put("elicitation/create", this.elicitationCreateHandler());
        }
        HashMap<String, McpClientSession.NotificationHandler> notificationHandlers = new HashMap<String, McpClientSession.NotificationHandler>();
        ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumersFinal = new ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>>();
        toolsChangeConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Tools changed: {}", notification)));
        if (!Utils.isEmpty(features.toolsChangeConsumers())) {
            toolsChangeConsumersFinal.addAll(features.toolsChangeConsumers());
        }
        notificationHandlers.put("notifications/tools/list_changed", this.asyncToolsChangeNotificationHandler(toolsChangeConsumersFinal));
        ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumersFinal = new ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>>();
        resourcesChangeConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Resources changed: {}", notification)));
        if (!Utils.isEmpty(features.resourcesChangeConsumers())) {
            resourcesChangeConsumersFinal.addAll(features.resourcesChangeConsumers());
        }
        notificationHandlers.put("notifications/resources/list_changed", this.asyncResourcesChangeNotificationHandler(resourcesChangeConsumersFinal));
        ArrayList<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumersFinal = new ArrayList<Function<List<McpSchema.ResourceContents>, Mono<Void>>>();
        resourcesUpdateConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Resources updated: {}", notification)));
        if (!Utils.isEmpty(features.resourcesUpdateConsumers())) {
            resourcesUpdateConsumersFinal.addAll(features.resourcesUpdateConsumers());
        }
        notificationHandlers.put("notifications/resources/updated", this.asyncResourcesUpdatedNotificationHandler(resourcesUpdateConsumersFinal));
        ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumersFinal = new ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>>();
        promptsChangeConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Prompts changed: {}", notification)));
        if (!Utils.isEmpty(features.promptsChangeConsumers())) {
            promptsChangeConsumersFinal.addAll(features.promptsChangeConsumers());
        }
        notificationHandlers.put("notifications/prompts/list_changed", this.asyncPromptsChangeNotificationHandler(promptsChangeConsumersFinal));
        ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumersFinal = new ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>();
        loggingConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Logging: {}", notification)));
        if (!Utils.isEmpty(features.loggingConsumers())) {
            loggingConsumersFinal.addAll(features.loggingConsumers());
        }
        notificationHandlers.put("notifications/message", this.asyncLoggingNotificationHandler(loggingConsumersFinal));
        ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumersFinal = new ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>>();
        progressConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Progress: {}", notification)));
        if (!Utils.isEmpty(features.progressConsumers())) {
            progressConsumersFinal.addAll(features.progressConsumers());
        }
        notificationHandlers.put("notifications/progress", this.asyncProgressNotificationHandler(progressConsumersFinal));
        Function<LifecycleInitializer.Initialization, Mono<Void>> postInitializationHook = init -> {
            if (init.initializeResult().capabilities().tools() == null || !this.enableCallToolSchemaCaching) {
                return Mono.empty();
            }
            return this.listToolsInternal((LifecycleInitializer.Initialization)init, McpSchema.FIRST_PAGE).doOnNext(listToolsResult -> {
                listToolsResult.tools().forEach(tool -> logger.debug("Tool {} schema: {}", (Object)tool.name(), (Object)tool.outputSchema()));
                if (this.enableCallToolSchemaCaching && listToolsResult.tools() != null) {
                    listToolsResult.tools().stream().filter(tool -> tool.outputSchema() != null).forEach(tool -> this.toolsOutputSchemaCache.put(tool.name(), tool.outputSchema()));
                }
            }).then();
        };
        this.initializer = new LifecycleInitializer(this.clientCapabilities, this.clientInfo, transport.protocolVersions(), initializationTimeout, ctx -> new McpClientSession(requestTimeout, transport, requestHandlers, notificationHandlers, con -> con.contextWrite((ContextView)ctx)), postInitializationHook);
        this.transport.setExceptionHandler(this.initializer::handleException);
    }

    public McpSchema.InitializeResult getCurrentInitializationResult() {
        return this.initializer.currentInitializationResult();
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        McpSchema.InitializeResult initializeResult = this.initializer.currentInitializationResult();
        return initializeResult != null ? initializeResult.capabilities() : null;
    }

    public String getServerInstructions() {
        McpSchema.InitializeResult initializeResult = this.initializer.currentInitializationResult();
        return initializeResult != null ? initializeResult.instructions() : null;
    }

    public McpSchema.Implementation getServerInfo() {
        McpSchema.InitializeResult initializeResult = this.initializer.currentInitializationResult();
        return initializeResult != null ? initializeResult.serverInfo() : null;
    }

    public boolean isInitialized() {
        return this.initializer.isInitialized();
    }

    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.clientCapabilities;
    }

    public McpSchema.Implementation getClientInfo() {
        return this.clientInfo;
    }

    public void close() {
        this.initializer.close();
        this.transport.close();
    }

    public Mono<Void> closeGracefully() {
        return Mono.defer(() -> this.initializer.closeGracefully().then(this.transport.closeGracefully()));
    }

    public Mono<McpSchema.InitializeResult> initialize() {
        return this.initializer.withInitialization("by explicit API call", init -> Mono.just(init.initializeResult()));
    }

    public Mono<Object> ping() {
        return this.initializer.withInitialization("pinging the server", init -> init.mcpSession().sendRequest("ping", null, OBJECT_TYPE_REF));
    }

    public Mono<Void> addRoot(McpSchema.Root root) {
        if (root == null) {
            return Mono.error(new IllegalArgumentException("Root must not be null"));
        }
        if (this.clientCapabilities.roots() == null) {
            return Mono.error(new IllegalStateException("Client must be configured with roots capabilities"));
        }
        if (this.roots.containsKey(root.uri())) {
            return Mono.error(new IllegalStateException("Root with uri '" + root.uri() + "' already exists"));
        }
        this.roots.put(root.uri(), root);
        logger.debug("Added root: {}", (Object)root);
        if (this.clientCapabilities.roots().listChanged().booleanValue()) {
            if (this.isInitialized()) {
                return this.rootsListChangedNotification();
            }
            logger.warn("Client is not initialized, ignore sending a roots list changed notification");
        }
        return Mono.empty();
    }

    public Mono<Void> removeRoot(String rootUri) {
        if (rootUri == null) {
            return Mono.error(new IllegalArgumentException("Root uri must not be null"));
        }
        if (this.clientCapabilities.roots() == null) {
            return Mono.error(new IllegalStateException("Client must be configured with roots capabilities"));
        }
        McpSchema.Root removed = this.roots.remove(rootUri);
        if (removed != null) {
            logger.debug("Removed Root: {}", (Object)rootUri);
            if (this.clientCapabilities.roots().listChanged().booleanValue()) {
                if (this.isInitialized()) {
                    return this.rootsListChangedNotification();
                }
                logger.warn("Client is not initialized, ignore sending a roots list changed notification");
            }
            return Mono.empty();
        }
        return Mono.error(new IllegalStateException("Root with uri '" + rootUri + "' not found"));
    }

    public Mono<Void> rootsListChangedNotification() {
        return this.initializer.withInitialization("sending roots list changed notification", init -> init.mcpSession().sendNotification("notifications/roots/list_changed"));
    }

    private McpClientSession.RequestHandler<McpSchema.ListRootsResult> rootsListRequestHandler() {
        return params -> {
            McpSchema.PaginatedRequest request = this.transport.unmarshalFrom(params, PAGINATED_REQUEST_TYPE_REF);
            List<McpSchema.Root> roots = this.roots.values().stream().toList();
            return Mono.just(new McpSchema.ListRootsResult(roots));
        };
    }

    private McpClientSession.RequestHandler<McpSchema.CreateMessageResult> samplingCreateMessageHandler() {
        return params -> {
            McpSchema.CreateMessageRequest request = this.transport.unmarshalFrom(params, CREATE_MESSAGE_REQUEST_TYPE_REF);
            return this.samplingHandler.apply(request);
        };
    }

    private McpClientSession.RequestHandler<McpSchema.ElicitResult> elicitationCreateHandler() {
        return params -> {
            McpSchema.ElicitRequest request = this.transport.unmarshalFrom(params, new TypeRef<McpSchema.ElicitRequest>(){});
            return this.elicitationHandler.apply(request);
        };
    }

    public Mono<McpSchema.CallToolResult> callTool(McpSchema.CallToolRequest callToolRequest) {
        return this.initializer.withInitialization("calling tool", init -> {
            if (init.initializeResult().capabilities().tools() == null) {
                return Mono.error(new IllegalStateException("Server does not provide tools capability"));
            }
            return init.mcpSession().sendRequest("tools/call", callToolRequest, CALL_TOOL_RESULT_TYPE_REF).flatMap(result -> Mono.just(this.validateToolResult(callToolRequest.name(), (McpSchema.CallToolResult)result)));
        });
    }

    private McpSchema.CallToolResult validateToolResult(String toolName, McpSchema.CallToolResult result) {
        if (!this.enableCallToolSchemaCaching || result == null || result.isError() == Boolean.TRUE) {
            return result;
        }
        Map<String, Object> optOutputSchema = this.toolsOutputSchemaCache.get(toolName);
        if (optOutputSchema == null) {
            logger.warn("Calling a tool with no outputSchema is not expected to return result with structured content, but got: {}", result.structuredContent());
            return result;
        }
        JsonSchemaValidator.ValidationResponse validation = this.jsonSchemaValidator.validate(optOutputSchema, result.structuredContent());
        if (!validation.valid()) {
            logger.warn("Tool call result validation failed: {}", (Object)validation.errorMessage());
            throw new IllegalArgumentException("Tool call result validation failed: " + validation.errorMessage());
        }
        return result;
    }

    public Mono<McpSchema.ListToolsResult> listTools() {
        return this.listTools(McpSchema.FIRST_PAGE).expand(result -> {
            String next = result.nextCursor();
            return next != null && !next.isEmpty() ? this.listTools(next) : Mono.empty();
        }).reduce(new McpSchema.ListToolsResult(new ArrayList<McpSchema.Tool>(), null), (allToolsResult, result) -> {
            allToolsResult.tools().addAll(result.tools());
            return allToolsResult;
        }).map(result -> new McpSchema.ListToolsResult(Collections.unmodifiableList(result.tools()), null));
    }

    public Mono<McpSchema.ListToolsResult> listTools(String cursor) {
        return this.initializer.withInitialization("listing tools", init -> this.listToolsInternal((LifecycleInitializer.Initialization)init, cursor));
    }

    private Mono<McpSchema.ListToolsResult> listToolsInternal(LifecycleInitializer.Initialization init, String cursor) {
        if (init.initializeResult().capabilities().tools() == null) {
            return Mono.error(new IllegalStateException("Server does not provide tools capability"));
        }
        return init.mcpSession().sendRequest("tools/list", new McpSchema.PaginatedRequest(cursor), LIST_TOOLS_RESULT_TYPE_REF).doOnNext(result -> {
            if (result.tools() != null) {
                result.tools().forEach(tool -> ToolNameValidator.validate(tool.name(), false));
            }
            if (this.enableCallToolSchemaCaching && result.tools() != null) {
                result.tools().stream().filter(tool -> tool.outputSchema() != null).forEach(tool -> this.toolsOutputSchemaCache.put(tool.name(), tool.outputSchema()));
            }
        });
    }

    private McpClientSession.NotificationHandler asyncToolsChangeNotificationHandler(List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers) {
        return params -> this.listTools().flatMap(listToolsResult -> Flux.fromIterable(toolsChangeConsumers).flatMap(consumer -> (Publisher)consumer.apply(listToolsResult.tools())).onErrorResume(error -> {
            logger.error("Error handling tools list change notification", (Throwable)error);
            return Mono.empty();
        }).then());
    }

    public Mono<McpSchema.ListResourcesResult> listResources() {
        return this.listResources(McpSchema.FIRST_PAGE).expand(result -> result.nextCursor() != null ? this.listResources(result.nextCursor()) : Mono.empty()).reduce(new McpSchema.ListResourcesResult(new ArrayList<McpSchema.Resource>(), null), (allResourcesResult, result) -> {
            allResourcesResult.resources().addAll(result.resources());
            return allResourcesResult;
        }).map(result -> new McpSchema.ListResourcesResult(Collections.unmodifiableList(result.resources()), null));
    }

    public Mono<McpSchema.ListResourcesResult> listResources(String cursor) {
        return this.initializer.withInitialization("listing resources", init -> {
            if (init.initializeResult().capabilities().resources() == null) {
                return Mono.error(new IllegalStateException("Server does not provide the resources capability"));
            }
            return init.mcpSession().sendRequest("resources/list", new McpSchema.PaginatedRequest(cursor), LIST_RESOURCES_RESULT_TYPE_REF);
        });
    }

    public Mono<McpSchema.ReadResourceResult> readResource(McpSchema.Resource resource) {
        return this.readResource(new McpSchema.ReadResourceRequest(resource.uri()));
    }

    public Mono<McpSchema.ReadResourceResult> readResource(McpSchema.ReadResourceRequest readResourceRequest) {
        return this.initializer.withInitialization("reading resources", init -> {
            if (init.initializeResult().capabilities().resources() == null) {
                return Mono.error(new IllegalStateException("Server does not provide the resources capability"));
            }
            return init.mcpSession().sendRequest("resources/read", readResourceRequest, READ_RESOURCE_RESULT_TYPE_REF);
        });
    }

    public Mono<McpSchema.ListResourceTemplatesResult> listResourceTemplates() {
        return this.listResourceTemplates(McpSchema.FIRST_PAGE).expand(result -> result.nextCursor() != null ? this.listResourceTemplates(result.nextCursor()) : Mono.empty()).reduce(new McpSchema.ListResourceTemplatesResult(new ArrayList<McpSchema.ResourceTemplate>(), null), (allResourceTemplatesResult, result) -> {
            allResourceTemplatesResult.resourceTemplates().addAll(result.resourceTemplates());
            return allResourceTemplatesResult;
        }).map(result -> new McpSchema.ListResourceTemplatesResult(Collections.unmodifiableList(result.resourceTemplates()), null));
    }

    public Mono<McpSchema.ListResourceTemplatesResult> listResourceTemplates(String cursor) {
        return this.initializer.withInitialization("listing resource templates", init -> {
            if (init.initializeResult().capabilities().resources() == null) {
                return Mono.error(new IllegalStateException("Server does not provide the resources capability"));
            }
            return init.mcpSession().sendRequest("resources/templates/list", new McpSchema.PaginatedRequest(cursor), LIST_RESOURCE_TEMPLATES_RESULT_TYPE_REF);
        });
    }

    public Mono<Void> subscribeResource(McpSchema.SubscribeRequest subscribeRequest) {
        return this.initializer.withInitialization("subscribing to resources", init -> init.mcpSession().sendRequest("resources/subscribe", subscribeRequest, VOID_TYPE_REFERENCE));
    }

    public Mono<Void> unsubscribeResource(McpSchema.UnsubscribeRequest unsubscribeRequest) {
        return this.initializer.withInitialization("unsubscribing from resources", init -> init.mcpSession().sendRequest("resources/unsubscribe", unsubscribeRequest, VOID_TYPE_REFERENCE));
    }

    private McpClientSession.NotificationHandler asyncResourcesChangeNotificationHandler(List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers) {
        return params -> this.listResources().flatMap(listResourcesResult -> Flux.fromIterable(resourcesChangeConsumers).flatMap(consumer -> (Publisher)consumer.apply(listResourcesResult.resources())).onErrorResume(error -> {
            logger.error("Error handling resources list change notification", (Throwable)error);
            return Mono.empty();
        }).then());
    }

    private McpClientSession.NotificationHandler asyncResourcesUpdatedNotificationHandler(List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers) {
        return params -> {
            McpSchema.ResourcesUpdatedNotification resourcesUpdatedNotification = this.transport.unmarshalFrom(params, new TypeRef<McpSchema.ResourcesUpdatedNotification>(){});
            return this.readResource(new McpSchema.ReadResourceRequest(resourcesUpdatedNotification.uri())).flatMap(readResourceResult -> Flux.fromIterable(resourcesUpdateConsumers).flatMap(consumer -> (Publisher)consumer.apply(readResourceResult.contents())).onErrorResume(error -> {
                logger.error("Error handling resource update notification", (Throwable)error);
                return Mono.empty();
            }).then());
        };
    }

    public Mono<McpSchema.ListPromptsResult> listPrompts() {
        return this.listPrompts(McpSchema.FIRST_PAGE).expand(result -> result.nextCursor() != null ? this.listPrompts(result.nextCursor()) : Mono.empty()).reduce(new McpSchema.ListPromptsResult(new ArrayList<McpSchema.Prompt>(), null), (allPromptsResult, result) -> {
            allPromptsResult.prompts().addAll(result.prompts());
            return allPromptsResult;
        }).map(result -> new McpSchema.ListPromptsResult(Collections.unmodifiableList(result.prompts()), null));
    }

    public Mono<McpSchema.ListPromptsResult> listPrompts(String cursor) {
        return this.initializer.withInitialization("listing prompts", init -> init.mcpSession().sendRequest("prompts/list", new McpSchema.PaginatedRequest(cursor), LIST_PROMPTS_RESULT_TYPE_REF));
    }

    public Mono<McpSchema.GetPromptResult> getPrompt(McpSchema.GetPromptRequest getPromptRequest) {
        return this.initializer.withInitialization("getting prompts", init -> init.mcpSession().sendRequest("prompts/get", getPromptRequest, GET_PROMPT_RESULT_TYPE_REF));
    }

    private McpClientSession.NotificationHandler asyncPromptsChangeNotificationHandler(List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers) {
        return params -> this.listPrompts().flatMap(listPromptsResult -> Flux.fromIterable(promptsChangeConsumers).flatMap(consumer -> (Publisher)consumer.apply(listPromptsResult.prompts())).onErrorResume(error -> {
            logger.error("Error handling prompts list change notification", (Throwable)error);
            return Mono.empty();
        }).then());
    }

    private McpClientSession.NotificationHandler asyncLoggingNotificationHandler(List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers) {
        return params -> {
            McpSchema.LoggingMessageNotification loggingMessageNotification = this.transport.unmarshalFrom(params, LOGGING_MESSAGE_NOTIFICATION_TYPE_REF);
            return Flux.fromIterable(loggingConsumers).flatMap(consumer -> (Publisher)consumer.apply(loggingMessageNotification)).then();
        };
    }

    public Mono<Void> setLoggingLevel(McpSchema.LoggingLevel loggingLevel) {
        if (loggingLevel == null) {
            return Mono.error(new IllegalArgumentException("Logging level must not be null"));
        }
        return this.initializer.withInitialization("setting logging level", init -> {
            if (init.initializeResult().capabilities().logging() == null) {
                return Mono.error(new IllegalStateException("Server's Logging capabilities are not enabled!"));
            }
            McpSchema.SetLevelRequest params = new McpSchema.SetLevelRequest(loggingLevel);
            return init.mcpSession().sendRequest("logging/setLevel", params, OBJECT_TYPE_REF).then();
        });
    }

    private McpClientSession.NotificationHandler asyncProgressNotificationHandler(List<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumers) {
        return params -> {
            McpSchema.ProgressNotification progressNotification = this.transport.unmarshalFrom(params, PROGRESS_NOTIFICATION_TYPE_REF);
            return Flux.fromIterable(progressConsumers).flatMap(consumer -> (Publisher)consumer.apply(progressNotification)).then();
        };
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.initializer.setProtocolVersions(protocolVersions);
    }

    public Mono<McpSchema.CompleteResult> completeCompletion(McpSchema.CompleteRequest completeRequest) {
        return this.initializer.withInitialization("complete completions", init -> init.mcpSession().sendRequest("completion/complete", completeRequest, COMPLETION_COMPLETE_RESULT_TYPE_REF));
    }
}

