/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.format.Format;
import com.networknt.schema.keyword.FormatValidator;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class FormatKeyword
implements Keyword {
    private final String value;
    private final Map<String, Format> formats;

    public FormatKeyword(Map<String, Format> formats) {
        this(KeywordType.FORMAT, formats);
    }

    public FormatKeyword(Keyword type, Map<String, Format> formats) {
        this(type.getValue(), formats);
    }

    public FormatKeyword(String value, Map<String, Format> formats) {
        this.value = value;
        this.formats = formats;
    }

    Collection<Format> getFormats() {
        return Collections.unmodifiableCollection(this.formats.values());
    }

    @Override
    public KeywordValidator newValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        Format format = null;
        if (schemaNode != null && schemaNode.isTextual()) {
            String formatName = schemaNode.textValue();
            format = this.formats.get(formatName);
        }
        return new FormatValidator(schemaLocation, schemaNode, parentSchema, schemaContext, format, this);
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

