/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.json.schema.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.Error;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.dialect.Dialects;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true, since="18.0.0")
public class DefaultJsonSchemaValidator
implements JsonSchemaValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJsonSchemaValidator.class);
    private final ObjectMapper objectMapper;
    private final SchemaRegistry schemaFactory;
    private final ConcurrentHashMap<String, Schema> schemaCache;

    public DefaultJsonSchemaValidator() {
        this(new ObjectMapper());
    }

    public DefaultJsonSchemaValidator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.schemaFactory = SchemaRegistry.withDialect(Dialects.getDraft202012());
        this.schemaCache = new ConcurrentHashMap();
    }

    @Override
    public JsonSchemaValidator.ValidationResponse validate(Map<String, Object> schema, Object structuredContent) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema must not be null");
        }
        if (structuredContent == null) {
            throw new IllegalArgumentException("Structured content must not be null");
        }
        try {
            JsonNode jsonStructuredOutput = structuredContent instanceof String ? this.objectMapper.readTree((String)structuredContent) : this.objectMapper.valueToTree(structuredContent);
            List<Error> validationResult = this.getOrCreateJsonSchema(schema).validate(jsonStructuredOutput);
            if (!validationResult.isEmpty()) {
                return JsonSchemaValidator.ValidationResponse.asInvalid("Validation failed: structuredContent does not match tool outputSchema. Validation errors: " + String.valueOf(validationResult));
            }
            return JsonSchemaValidator.ValidationResponse.asValid(jsonStructuredOutput.toString());
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to validate CallToolResult: Error parsing schema: {}", e);
            return JsonSchemaValidator.ValidationResponse.asInvalid("Error parsing tool JSON Schema: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("Failed to validate CallToolResult: Unexpected error: {}", e);
            return JsonSchemaValidator.ValidationResponse.asInvalid("Unexpected validation error: " + e.getMessage());
        }
    }

    private Schema getOrCreateJsonSchema(Map<String, Object> schema) throws JsonProcessingException {
        String cacheKey = this.generateCacheKey(schema);
        Schema cachedSchema = this.schemaCache.get(cacheKey);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        Schema newSchema = this.createJsonSchema(schema);
        Schema existingSchema = this.schemaCache.putIfAbsent(cacheKey, newSchema);
        return existingSchema != null ? existingSchema : newSchema;
    }

    private Schema createJsonSchema(Map<String, Object> schema) throws JsonProcessingException {
        Object schemaNode = this.objectMapper.valueToTree(schema);
        if (schemaNode == null) {
            throw new JsonProcessingException("Failed to convert schema to JsonNode"){};
        }
        return this.schemaFactory.getSchema((JsonNode)schemaNode);
    }

    protected String generateCacheKey(Map<String, Object> schema) {
        if (schema.containsKey("$id")) {
            return String.valueOf(schema.get("$id"));
        }
        return String.valueOf(schema.hashCode());
    }

    public void clearCache() {
        this.schemaCache.clear();
    }

    public int getCacheSize() {
        return this.schemaCache.size();
    }
}

