/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.conformance.client;

import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientStreamableHttpTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class ConformanceJdkClientMcpClient {
    public static void main(String[] args) {
        String scenario;
        if (args.length == 0) {
            System.err.println("Usage: ConformanceJdkClientMcpClient <server-url>");
            System.err.println("The server URL must be provided as the last command-line argument.");
            System.err.println("The MCP_CONFORMANCE_SCENARIO environment variable must be set.");
            System.exit(1);
        }
        if ((scenario = System.getenv("MCP_CONFORMANCE_SCENARIO")) == null || scenario.isEmpty()) {
            System.err.println("Error: MCP_CONFORMANCE_SCENARIO environment variable is not set");
            System.exit(1);
        }
        String serverUrl = args[args.length - 1];
        try {
            switch (scenario) {
                case "initialize": {
                    ConformanceJdkClientMcpClient.runInitializeScenario(serverUrl);
                    break;
                }
                case "tools_call": {
                    ConformanceJdkClientMcpClient.runToolsCallScenario(serverUrl);
                    break;
                }
                case "elicitation-sep1034-client-defaults": {
                    ConformanceJdkClientMcpClient.runElicitationDefaultsScenario(serverUrl);
                    break;
                }
                case "sse-retry": {
                    ConformanceJdkClientMcpClient.runSSERetryScenario(serverUrl);
                    break;
                }
                default: {
                    System.err.println("Unknown scenario: " + scenario);
                    System.err.println("Available scenarios:");
                    System.err.println("  - initialize");
                    System.err.println("  - tools_call");
                    System.err.println("  - elicitation-sep1034-client-defaults");
                    System.err.println("  - sse-retry");
                    System.exit(1);
                }
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static McpSyncClient createClient(String serverUrl) {
        HttpClientStreamableHttpTransport transport = HttpClientStreamableHttpTransport.builder(serverUrl).build();
        return McpClient.sync(transport).clientInfo(new McpSchema.Implementation("test-client", "1.0.0")).requestTimeout(Duration.ofSeconds(30L)).build();
    }

    private static McpSyncClient createClientWithElicitation(String serverUrl) {
        HttpClientStreamableHttpTransport transport = HttpClientStreamableHttpTransport.builder(serverUrl).build();
        McpSchema.ClientCapabilities capabilities = McpSchema.ClientCapabilities.builder().elicitation().build();
        return McpClient.sync(transport).clientInfo(new McpSchema.Implementation("test-client", "1.0.0")).requestTimeout(Duration.ofSeconds(30L)).capabilities(capabilities).elicitation(request -> {
            HashMap<String, Object> content = new HashMap<String, Object>();
            Map<String, Object> schema = request.requestedSchema();
            if (schema != null && schema.containsKey("properties")) {
                Map properties = (Map)schema.get("properties");
                properties.forEach((key, propDef) -> {
                    Map propMap = (Map)propDef;
                    if (propMap.containsKey("default")) {
                        content.put((String)key, propMap.get("default"));
                    }
                });
            }
            return new McpSchema.ElicitResult(McpSchema.ElicitResult.Action.ACCEPT, content, null);
        }).build();
    }

    private static void runInitializeScenario(String serverUrl) throws Exception {
        McpSyncClient client = ConformanceJdkClientMcpClient.createClient(serverUrl);
        try {
            client.initialize();
            System.out.println("Successfully connected to MCP server");
        }
        finally {
            client.close();
            System.out.println("Connection closed successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runToolsCallScenario(String serverUrl) throws Exception {
        block5: {
            McpSyncClient client = ConformanceJdkClientMcpClient.createClient(serverUrl);
            try {
                client.initialize();
                System.out.println("Successfully connected to MCP server");
                McpSchema.ListToolsResult toolsResult = client.listTools();
                System.out.println("Successfully listed tools");
                if (toolsResult == null || toolsResult.tools() == null) break block5;
                for (McpSchema.Tool tool : toolsResult.tools()) {
                    if (!"add_numbers".equals(tool.name())) continue;
                    HashMap<String, Object> arguments = new HashMap<String, Object>();
                    arguments.put("a", 5);
                    arguments.put("b", 3);
                    McpSchema.CallToolResult result = client.callTool(new McpSchema.CallToolRequest("add_numbers", arguments));
                    System.out.println("Successfully called add_numbers tool");
                    if (result != null && result.content() != null) {
                        System.out.println("Tool result: " + String.valueOf(result.content()));
                    }
                    break;
                }
            }
            finally {
                client.close();
                System.out.println("Connection closed successfully");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runElicitationDefaultsScenario(String serverUrl) throws Exception {
        block5: {
            McpSyncClient client = ConformanceJdkClientMcpClient.createClientWithElicitation(serverUrl);
            try {
                client.initialize();
                System.out.println("Successfully connected to MCP server");
                McpSchema.ListToolsResult toolsResult = client.listTools();
                System.out.println("Successfully listed tools");
                if (toolsResult == null || toolsResult.tools() == null) break block5;
                for (McpSchema.Tool tool : toolsResult.tools()) {
                    if (!"test_client_elicitation_defaults".equals(tool.name())) continue;
                    HashMap<String, Object> arguments = new HashMap<String, Object>();
                    McpSchema.CallToolResult result = client.callTool(new McpSchema.CallToolRequest("test_client_elicitation_defaults", arguments));
                    System.out.println("Successfully called test_client_elicitation_defaults tool");
                    if (result != null && result.content() != null) {
                        System.out.println("Tool result: " + String.valueOf(result.content()));
                    }
                    break;
                }
            }
            finally {
                client.close();
                System.out.println("Connection closed successfully");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runSSERetryScenario(String serverUrl) throws Exception {
        block5: {
            McpSyncClient client = ConformanceJdkClientMcpClient.createClient(serverUrl);
            try {
                client.initialize();
                System.out.println("Successfully connected to MCP server");
                McpSchema.ListToolsResult toolsResult = client.listTools();
                System.out.println("Successfully listed tools");
                if (toolsResult == null || toolsResult.tools() == null) break block5;
                for (McpSchema.Tool tool : toolsResult.tools()) {
                    if (!"test_reconnection".equals(tool.name())) continue;
                    HashMap<String, Object> arguments = new HashMap<String, Object>();
                    McpSchema.CallToolResult result = client.callTool(new McpSchema.CallToolRequest("test_reconnection", arguments));
                    System.out.println("Successfully called test_reconnection tool");
                    if (result != null && result.content() != null) {
                        System.out.println("Tool result: " + String.valueOf(result.content()));
                    }
                    break;
                }
            }
            finally {
                client.close();
                System.out.println("Connection closed successfully");
            }
        }
    }
}

