/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client.transport.customizer;

import io.modelcontextprotocol.client.transport.customizer.McpAsyncHttpClientRequestCustomizer;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.util.Assert;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DelegatingMcpAsyncHttpClientRequestCustomizer
implements McpAsyncHttpClientRequestCustomizer {
    private final List<McpAsyncHttpClientRequestCustomizer> customizers;

    public DelegatingMcpAsyncHttpClientRequestCustomizer(List<McpAsyncHttpClientRequestCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        this.customizers = customizers;
    }

    @Override
    public Publisher<HttpRequest.Builder> customize(HttpRequest.Builder builder, String method, URI endpoint, String body, McpTransportContext context) {
        Mono<HttpRequest.Builder> result = Mono.just(builder);
        for (McpAsyncHttpClientRequestCustomizer customizer : this.customizers) {
            result = result.flatMap(b -> Mono.from(customizer.customize((HttpRequest.Builder)b, method, endpoint, body, context)));
        }
        return result;
    }
}

