/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.reflect.TypeToken;
import io.milvus.common.utils.JsonUtils;
import io.milvus.exception.ParamException;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.FunctionSchema;
import io.milvus.grpc.FunctionType;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.StructArrayFieldSchema;
import io.milvus.grpc.ValueField;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.DataType;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.collection.request.AddFieldReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.utils.ConvertUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SchemaUtils.class);

    public static void checkNullEmptyString(String target, String title) {
        if (target == null || StringUtils.isBlank((CharSequence)target)) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, title + " cannot be null or empty");
        }
    }

    public static FieldSchema convertToGrpcFieldSchema(CreateCollectionReq.FieldSchema fieldSchema) {
        List<KeyValuePair> typeParamsList;
        String params;
        Map<Object, Object> typeParams;
        SchemaUtils.checkNullEmptyString(fieldSchema.getName(), "Field name");
        io.milvus.grpc.DataType dType = io.milvus.grpc.DataType.valueOf(fieldSchema.getDataType().name());
        FieldSchema.Builder builder = FieldSchema.newBuilder().setName(fieldSchema.getName()).setDescription(fieldSchema.getDescription()).setDataType(dType).setIsPrimaryKey(fieldSchema.getIsPrimaryKey()).setIsPartitionKey(fieldSchema.getIsPartitionKey()).setIsClusteringKey(fieldSchema.getIsClusteringKey()).setAutoID(fieldSchema.getAutoID()).setNullable(fieldSchema.getIsNullable());
        if (!ParamUtils.isVectorDataType(dType) && !fieldSchema.getIsPrimaryKey().booleanValue()) {
            ValueField value = ParamUtils.objectToValueField(fieldSchema.getDefaultValue(), dType);
            if (value != null) {
                builder.setDefaultValue(value);
            } else if (fieldSchema.getDefaultValue() != null) {
                String msg = String.format("Illegal default value for %s type field. Please use Short for Int8/Int16 fields, Short/Integer for Int32 fields, Short/Integer/Long for Int64 fields, Boolean for Bool fields, String for Varchar fields, JsonObject for JSON fields.", dType.name());
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
            }
        }
        Map<Object, Object> map = typeParams = fieldSchema.getTypeParams() == null ? new HashMap() : fieldSchema.getTypeParams();
        if (fieldSchema.getDimension() != null) {
            typeParams.put("dim", String.valueOf(fieldSchema.getDimension()));
        }
        if (fieldSchema.getDataType() == DataType.VarChar && fieldSchema.getMaxLength() != null) {
            typeParams.put("max_length", String.valueOf(fieldSchema.getMaxLength()));
        }
        if (fieldSchema.getDataType() == DataType.Array) {
            builder.setElementType(io.milvus.grpc.DataType.valueOf(fieldSchema.getElementType().name())).build();
            if (fieldSchema.getMaxCapacity() != null) {
                typeParams.put("max_capacity", String.valueOf(fieldSchema.getMaxCapacity()));
            }
            if (fieldSchema.getElementType() == DataType.VarChar && fieldSchema.getMaxLength() != null) {
                typeParams.put("max_length", String.valueOf(fieldSchema.getMaxLength()));
            }
        }
        if (fieldSchema.getEnableAnalyzer() != null) {
            typeParams.put("enable_analyzer", String.valueOf(fieldSchema.getEnableAnalyzer()));
        }
        if (fieldSchema.getEnableMatch() != null) {
            typeParams.put("enable_match", String.valueOf(fieldSchema.getEnableMatch()));
        }
        if (fieldSchema.getAnalyzerParams() != null) {
            params = JsonUtils.toJson(fieldSchema.getAnalyzerParams());
            typeParams.put("analyzer_params", params);
        }
        if (fieldSchema.getMultiAnalyzerParams() != null) {
            params = JsonUtils.toJson(fieldSchema.getMultiAnalyzerParams());
            typeParams.put("multi_analyzer_params", params);
        }
        if (CollectionUtils.isNotEmpty(typeParamsList = ParamUtils.AssembleKvPair(typeParams))) {
            typeParamsList.forEach(builder::addTypeParams);
        }
        return builder.build();
    }

    public static FunctionSchema convertToGrpcFunction(CreateCollectionReq.Function function) {
        SchemaUtils.checkNullEmptyString(function.getName(), "Function name");
        FunctionSchema.Builder builder = FunctionSchema.newBuilder().setName(function.getName()).setDescription(function.getDescription()).setType(FunctionType.forNumber(function.getFunctionType().getCode()));
        for (String name : function.getInputFieldNames()) {
            builder.addInputFieldNames(name);
        }
        for (String name : function.getOutputFieldNames()) {
            builder.addOutputFieldNames(name);
        }
        List<KeyValuePair> params = ParamUtils.AssembleKvPair(function.getParams());
        if (CollectionUtils.isNotEmpty(params)) {
            params.forEach(builder::addParams);
        }
        return builder.build();
    }

    public static StructArrayFieldSchema convertToGrpcStructFieldSchema(CreateCollectionReq.StructFieldSchema structSchema) {
        SchemaUtils.checkNullEmptyString(structSchema.getName(), "Field name");
        StructArrayFieldSchema.Builder builder = StructArrayFieldSchema.newBuilder().setName(structSchema.getName()).setDescription(structSchema.getDescription());
        for (CreateCollectionReq.FieldSchema field : structSchema.getFields()) {
            io.milvus.grpc.DataType actualType = io.milvus.grpc.DataType.Array;
            io.milvus.grpc.DataType elementType = io.milvus.grpc.DataType.valueOf(field.getDataType().name());
            if (ParamUtils.isVectorDataType(elementType)) {
                actualType = io.milvus.grpc.DataType.ArrayOfVector;
            }
            FieldSchema fieldSchema = SchemaUtils.convertToGrpcFieldSchema(field);
            fieldSchema = fieldSchema.toBuilder().setDataType(actualType).setElementType(elementType).addTypeParams(KeyValuePair.newBuilder().setKey("max_capacity").setValue(String.valueOf(structSchema.getMaxCapacity())).build()).build();
            builder.addFields(fieldSchema);
        }
        return builder.build();
    }

    public static CreateCollectionReq.CollectionSchema convertFromGrpcCollectionSchema(CollectionSchema schema) {
        Object collectionSchema = ((CreateCollectionReq.CollectionSchema.CollectionSchemaBuilder)CreateCollectionReq.CollectionSchema.builder().enableDynamicField(schema.getEnableDynamicField())).build();
        ArrayList<CreateCollectionReq.FieldSchema> fieldSchemas = new ArrayList<CreateCollectionReq.FieldSchema>();
        for (FieldSchema fieldSchema : schema.getFieldsList()) {
            fieldSchemas.add(SchemaUtils.convertFromGrpcFieldSchema(fieldSchema));
        }
        ((CreateCollectionReq.CollectionSchema)collectionSchema).setFieldSchemaList(fieldSchemas);
        ArrayList<CreateCollectionReq.StructFieldSchema> structSchemas = new ArrayList<CreateCollectionReq.StructFieldSchema>();
        for (StructArrayFieldSchema fieldSchema : schema.getStructArrayFieldsList()) {
            structSchemas.add(SchemaUtils.convertFromGrpcStructFieldSchema(fieldSchema));
        }
        ((CreateCollectionReq.CollectionSchema)collectionSchema).setStructFields(structSchemas);
        ArrayList<CreateCollectionReq.Function> arrayList = new ArrayList<CreateCollectionReq.Function>();
        for (FunctionSchema functionSchema : schema.getFunctionsList()) {
            arrayList.add(SchemaUtils.convertFromGrpcFunction(functionSchema));
        }
        ((CreateCollectionReq.CollectionSchema)collectionSchema).setFunctionList(arrayList);
        return collectionSchema;
    }

    public static CreateCollectionReq.FieldSchema convertFromGrpcFieldSchema(FieldSchema fieldSchema) {
        DataType actualType;
        io.milvus.grpc.DataType dataType = fieldSchema.getDataType();
        io.milvus.grpc.DataType elementType = fieldSchema.getElementType();
        DataType actualElementType = DataType.None;
        if (dataType == io.milvus.grpc.DataType.ArrayOfVector || dataType == io.milvus.grpc.DataType.ArrayOfStruct) {
            actualType = DataType.valueOf(elementType.name());
        } else {
            actualType = DataType.valueOf(dataType.name());
            actualElementType = DataType.valueOf(elementType.name());
        }
        Object schema = ((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)CreateCollectionReq.FieldSchema.builder().name(fieldSchema.getName())).description(fieldSchema.getDescription())).dataType(actualType)).isPrimaryKey(fieldSchema.getIsPrimaryKey())).isPartitionKey(fieldSchema.getIsPartitionKey())).isClusteringKey(fieldSchema.getIsClusteringKey())).autoID(fieldSchema.getAutoID())).elementType(actualElementType)).isNullable(fieldSchema.getNullable())).defaultValue(ParamUtils.valueFieldToObject(fieldSchema.getDefaultValue(), fieldSchema.getDataType()))).build();
        HashMap<String, String> typeParams = new HashMap<String, String>();
        for (KeyValuePair keyValuePair : fieldSchema.getTypeParamsList()) {
            try {
                Map params;
                if (keyValuePair.getKey().equals("dim")) {
                    ((CreateCollectionReq.FieldSchema)schema).setDimension(Integer.parseInt(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("max_length")) {
                    ((CreateCollectionReq.FieldSchema)schema).setMaxLength(Integer.parseInt(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("max_capacity")) {
                    ((CreateCollectionReq.FieldSchema)schema).setMaxCapacity(Integer.parseInt(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("enable_analyzer")) {
                    ((CreateCollectionReq.FieldSchema)schema).setEnableAnalyzer(Boolean.parseBoolean(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("enable_match")) {
                    ((CreateCollectionReq.FieldSchema)schema).setEnableMatch(Boolean.parseBoolean(keyValuePair.getValue()));
                } else if (keyValuePair.getKey().equals("analyzer_params")) {
                    params = (Map)JsonUtils.fromJson(keyValuePair.getValue(), new TypeToken<Map<String, Object>>(){}.getType());
                    ((CreateCollectionReq.FieldSchema)schema).setAnalyzerParams(params);
                } else if (keyValuePair.getKey().equals("multi_analyzer_params")) {
                    params = (Map)JsonUtils.fromJson(keyValuePair.getValue(), new TypeToken<Map<String, Object>>(){}.getType());
                    ((CreateCollectionReq.FieldSchema)schema).setMultiAnalyzerParams(params);
                }
            }
            catch (Exception e) {
                logger.error("Failed to convert the typeParams value of {} , key:{}, value:{}", new Object[]{fieldSchema.getName(), keyValuePair.getKey(), keyValuePair.getValue()});
            }
            typeParams.put(keyValuePair.getKey(), keyValuePair.getValue());
        }
        ((CreateCollectionReq.FieldSchema)schema).setTypeParams(typeParams);
        return schema;
    }

    public static CreateCollectionReq.StructFieldSchema convertFromGrpcStructFieldSchema(StructArrayFieldSchema structSchema) {
        Object builder = ((CreateCollectionReq.StructFieldSchema.StructFieldSchemaBuilder)CreateCollectionReq.StructFieldSchema.builder().name(structSchema.getName())).description(structSchema.getDescription());
        ArrayList<CreateCollectionReq.FieldSchema> fields = new ArrayList<CreateCollectionReq.FieldSchema>();
        for (FieldSchema fieldSchema : structSchema.getFieldsList()) {
            CreateCollectionReq.FieldSchema field = SchemaUtils.convertFromGrpcFieldSchema(fieldSchema);
            ((CreateCollectionReq.StructFieldSchema.StructFieldSchemaBuilder)builder).maxCapacity(field.getMaxCapacity());
            field.setDataType(ConvertUtils.toSdkDataType(fieldSchema.getElementType()));
            field.setElementType(DataType.None);
            Map<String, String> params = field.getTypeParams();
            params.remove("max_capacity");
            field.setTypeParams(params);
            field.setMaxCapacity(0);
            fields.add(field);
        }
        ((CreateCollectionReq.StructFieldSchema.StructFieldSchemaBuilder)builder).fields(fields);
        return ((CreateCollectionReq.StructFieldSchema.StructFieldSchemaBuilder)builder).build();
    }

    public static CreateCollectionReq.Function convertFromGrpcFunction(FunctionSchema functionSchema) {
        Object builder = ((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)((CreateCollectionReq.Function.FunctionBuilder)CreateCollectionReq.Function.builder().name(functionSchema.getName())).description(functionSchema.getDescription())).functionType(io.milvus.common.clientenum.FunctionType.fromName(functionSchema.getType().name()))).inputFieldNames(functionSchema.getInputFieldNamesList().stream().collect(Collectors.toList()))).outputFieldNames(functionSchema.getOutputFieldNamesList().stream().collect(Collectors.toList()));
        List<KeyValuePair> pairs = functionSchema.getParamsList();
        pairs.forEach(kv -> builder.param(kv.getKey(), kv.getValue()));
        return ((CreateCollectionReq.Function.FunctionBuilder)builder).build();
    }

    public static CreateCollectionReq.FieldSchema convertFieldReqToFieldSchema(AddFieldReq addFieldReq) {
        if (addFieldReq.isEnableDefaultValue() && addFieldReq.getDefaultValue() == null && addFieldReq.getIsNullable() == Boolean.FALSE) {
            String msg = String.format("Default value cannot be null for field '%s' that is defined as nullable == false.", addFieldReq.getFieldName());
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, msg);
        }
        Object fieldSchema = ((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)((CreateCollectionReq.FieldSchema.FieldSchemaBuilder)CreateCollectionReq.FieldSchema.builder().name(addFieldReq.getFieldName())).dataType(addFieldReq.getDataType())).description(addFieldReq.getDescription())).isPrimaryKey(addFieldReq.getIsPrimaryKey())).isPartitionKey(addFieldReq.getIsPartitionKey())).isClusteringKey(addFieldReq.getIsClusteringKey())).autoID(addFieldReq.getAutoID())).isNullable(addFieldReq.getIsNullable())).defaultValue(addFieldReq.getDefaultValue())).enableAnalyzer(addFieldReq.getEnableAnalyzer())).enableMatch(addFieldReq.getEnableMatch())).analyzerParams(addFieldReq.getAnalyzerParams())).typeParams(addFieldReq.getTypeParams())).multiAnalyzerParams(addFieldReq.getMultiAnalyzerParams())).build();
        if (addFieldReq.getDataType().equals((Object)DataType.Array)) {
            if (addFieldReq.getElementType() == null) {
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Element type, maxCapacity are required for array field");
            }
            ((CreateCollectionReq.FieldSchema)fieldSchema).setElementType(addFieldReq.getElementType());
            ((CreateCollectionReq.FieldSchema)fieldSchema).setMaxCapacity(addFieldReq.getMaxCapacity());
        } else if (addFieldReq.getDataType().equals((Object)DataType.VarChar)) {
            ((CreateCollectionReq.FieldSchema)fieldSchema).setMaxLength(addFieldReq.getMaxLength());
        } else if (ParamUtils.isDenseVectorDataType(io.milvus.grpc.DataType.valueOf(addFieldReq.getDataType().name()))) {
            if (addFieldReq.getDimension() == null) {
                throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Dimension is required for vector field");
            }
            ((CreateCollectionReq.FieldSchema)fieldSchema).setDimension(addFieldReq.getDimension());
        }
        return fieldSchema;
    }

    public static CreateCollectionReq.StructFieldSchema convertFieldReqToStructFieldSchema(AddFieldReq addFieldReq) {
        List<CreateCollectionReq.FieldSchema> fields = addFieldReq.getStructFields();
        if (fields.isEmpty()) {
            throw new ParamException("Struct field must have at least one field");
        }
        String structName = addFieldReq.getFieldName();
        if (addFieldReq.getMaxCapacity() == null) {
            String msg = String.format("maxCapacity not set for struct field: '%s'", structName);
            throw new ParamException(msg);
        }
        HashSet<String> uniqueNames = new HashSet<String>();
        for (CreateCollectionReq.FieldSchema field : fields) {
            String fieldName = field.getName();
            uniqueNames.add(fieldName);
            if (field.getIsPrimaryKey().booleanValue()) {
                String msg = String.format("Field '%s' in struct '%s' cannot be primary key", fieldName, structName);
                throw new ParamException(msg);
            }
            if (field.getIsPartitionKey().booleanValue()) {
                String msg = String.format("Field '%s' in struct '%s' cannot be partition key", fieldName, structName);
                throw new ParamException(msg);
            }
            if (field.getIsClusteringKey().booleanValue()) {
                String msg = String.format("Field '%s' in struct '%s' cannot be clustering key", fieldName, structName);
                throw new ParamException(msg);
            }
            if (field.getAutoID().booleanValue()) {
                String msg = String.format("Field '%s' in struct '%s' cannot be auto-id", fieldName, structName);
                throw new ParamException(msg);
            }
            if (field.getIsNullable().booleanValue()) {
                String msg = String.format("Field '%s' in struct '%s' cannot be nullable", fieldName, structName);
                throw new ParamException(msg);
            }
            if (field.getDefaultValue() == null) continue;
            String msg = String.format("Field '%s' in struct '%s' cannot have default value", fieldName, structName);
            throw new ParamException(msg);
        }
        if (uniqueNames.size() != fields.size()) {
            String msg = String.format("Duplicate field names in struct '%s'", structName);
            throw new ParamException(msg);
        }
        return ((CreateCollectionReq.StructFieldSchema.StructFieldSchemaBuilder)((CreateCollectionReq.StructFieldSchema.StructFieldSchemaBuilder)((CreateCollectionReq.StructFieldSchema.StructFieldSchemaBuilder)((CreateCollectionReq.StructFieldSchema.StructFieldSchemaBuilder)CreateCollectionReq.StructFieldSchema.builder().name(addFieldReq.getFieldName())).description(addFieldReq.getDescription())).fields(fields)).maxCapacity(addFieldReq.getMaxCapacity())).build();
    }
}

