/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.orm.iterator;

import io.milvus.grpc.DataType;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.QueryRequest;
import io.milvus.grpc.QueryResults;
import io.milvus.orm.iterator.IteratorAdapterV2;
import io.milvus.orm.iterator.IteratorCache;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.FieldType;
import io.milvus.param.dml.QueryIteratorParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.vector.request.QueryIteratorReq;
import io.milvus.v2.utils.RpcUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIterator {
    protected static final Logger logger = LoggerFactory.getLogger(RpcUtils.class);
    private final IteratorCache iteratorCache = new IteratorCache();
    private final MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub;
    private final FieldType primaryField;
    private final QueryIteratorParam queryIteratorParam;
    private final int batchSize;
    private final long limit;
    private final String expr;
    private long offset;
    private Object nextId;
    private int cacheIdInUse;
    private long returnedCount;
    private final RpcUtils rpcUtils;
    private long sessionTs = 0L;

    public QueryIterator(QueryIteratorParam queryIteratorParam, MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, FieldType primaryField) {
        this.blockingStub = blockingStub;
        this.primaryField = primaryField;
        this.queryIteratorParam = queryIteratorParam;
        this.batchSize = (int)queryIteratorParam.getBatchSize();
        this.expr = queryIteratorParam.getExpr();
        this.limit = queryIteratorParam.getLimit();
        this.offset = queryIteratorParam.getOffset();
        this.rpcUtils = new RpcUtils();
        this.setupTsByRequest();
        this.seek();
    }

    public QueryIterator(QueryIteratorReq queryIteratorReq, MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateCollectionReq.FieldSchema primaryField) {
        this.blockingStub = blockingStub;
        IteratorAdapterV2 adapter = new IteratorAdapterV2();
        this.queryIteratorParam = IteratorAdapterV2.convertV2Req(queryIteratorReq);
        this.primaryField = IteratorAdapterV2.convertV2Field(primaryField);
        this.batchSize = (int)this.queryIteratorParam.getBatchSize();
        this.expr = this.queryIteratorParam.getExpr();
        this.limit = this.queryIteratorParam.getLimit();
        this.offset = this.queryIteratorParam.getOffset();
        this.rpcUtils = new RpcUtils();
        this.setupTsByRequest();
        this.seek();
    }

    private void setupTsByRequest() {
        QueryResults response = this.executeQuery(this.expr, 0L, 1L, 0L, true);
        if (response.getSessionTs() <= 0L) {
            logger.warn("Failed to get mvccTs from milvus server, use client-side ts instead");
            long ts = System.currentTimeMillis() + 1000L;
            this.sessionTs = ts << 18;
        } else {
            this.sessionTs = response.getSessionTs();
        }
    }

    private void seek() {
        List<QueryResultsWrapper.RowRecord> res;
        this.cacheIdInUse = -1;
        if (this.offset == 0L) {
            this.nextId = null;
            return;
        }
        for (long currentOffset = this.offset; currentOffset > 0L; currentOffset -= (long)res.size()) {
            long limit = Math.min(16384L, currentOffset);
            String currentExpr = this.setupNextExpr();
            QueryResults response = this.executeQuery(currentExpr, 0L, limit, this.sessionTs, true);
            QueryResultsWrapper queryWrapper = new QueryResultsWrapper(response);
            res = queryWrapper.getRowRecords();
            if (res.isEmpty()) break;
            this.updateCursor(res);
        }
        this.offset = 0L;
    }

    public List<QueryResultsWrapper.RowRecord> next() {
        List<QueryResultsWrapper.RowRecord> ret;
        List<QueryResultsWrapper.RowRecord> cachedRes = this.iteratorCache.fetchCache(this.cacheIdInUse);
        if (this.isResSufficient(cachedRes)) {
            ret = cachedRes.subList(0, this.batchSize);
            List<QueryResultsWrapper.RowRecord> retToCache = cachedRes.subList(this.batchSize, cachedRes.size());
            this.iteratorCache.cache(this.cacheIdInUse, retToCache);
        } else {
            this.iteratorCache.releaseCache(this.cacheIdInUse);
            String currentExpr = this.setupNextExpr();
            logger.debug("Query iterator next expression: " + currentExpr);
            QueryResults response = this.executeQuery(currentExpr, this.offset, this.batchSize, this.sessionTs, false);
            QueryResultsWrapper queryWrapper = new QueryResultsWrapper(response);
            List<QueryResultsWrapper.RowRecord> res = queryWrapper.getRowRecords();
            this.maybeCache(res);
            ret = res.subList(0, Math.min(this.batchSize, res.size()));
        }
        ret = this.checkReachedLimit(ret);
        this.updateCursor(ret);
        this.returnedCount += (long)ret.size();
        return ret;
    }

    public void close() {
        this.iteratorCache.releaseCache(this.cacheIdInUse);
    }

    private void updateCursor(List<QueryResultsWrapper.RowRecord> res) {
        if (res.isEmpty()) {
            return;
        }
        this.nextId = res.get(res.size() - 1).get(this.primaryField.getName());
    }

    private List<QueryResultsWrapper.RowRecord> checkReachedLimit(List<QueryResultsWrapper.RowRecord> ret) {
        if (this.limit == -1L) {
            return ret;
        }
        long leftCount = this.limit - this.returnedCount;
        if (leftCount >= (long)ret.size()) {
            return ret;
        }
        return ret.subList(0, (int)leftCount);
    }

    private void maybeCache(List<QueryResultsWrapper.RowRecord> ret) {
        if (ret.size() < 2 * this.batchSize) {
            return;
        }
        List<QueryResultsWrapper.RowRecord> cacheResult = ret.subList(this.batchSize, ret.size());
        this.cacheIdInUse = this.iteratorCache.cache(-1, cacheResult);
    }

    private String setupNextExpr() {
        String currentExpr = this.expr;
        if (this.nextId == null) {
            return currentExpr;
        }
        String filteredPKStr = this.primaryField.getDataType() == DataType.VarChar ? this.primaryField.getName() + " > \"" + this.nextId + "\"" : this.primaryField.getName() + " > " + this.nextId;
        if (StringUtils.isEmpty((CharSequence)currentExpr)) {
            return filteredPKStr;
        }
        return " ( " + currentExpr + " )  and " + filteredPKStr;
    }

    private boolean isResSufficient(List<QueryResultsWrapper.RowRecord> ret) {
        return ret != null && ret.size() >= this.batchSize;
    }

    private QueryResults executeQuery(String expr, long offset, long limit, long ts, boolean isSeek) {
        ArrayList<String> outputFields = new ArrayList();
        boolean reduceStopForBest = this.queryIteratorParam.isReduceStopForBest();
        if (!isSeek) {
            outputFields = this.queryIteratorParam.getOutFields();
            reduceStopForBest = false;
        }
        QueryParam queryParam = QueryParam.newBuilder().withDatabaseName(this.queryIteratorParam.getDatabaseName()).withCollectionName(this.queryIteratorParam.getCollectionName()).withConsistencyLevel(this.queryIteratorParam.getConsistencyLevel()).withPartitionNames(this.queryIteratorParam.getPartitionNames()).withOutFields(outputFields).withExpr(expr).withOffset(offset).withLimit(limit).withIgnoreGrowing(this.queryIteratorParam.isIgnoreGrowing()).build();
        QueryRequest queryRequest = ParamUtils.convertQueryParam(queryParam);
        QueryRequest.Builder builder = queryRequest.toBuilder();
        builder.addQueryParams(KeyValuePair.newBuilder().setKey("reduce_stop_for_best").setValue(String.valueOf(reduceStopForBest)).build());
        builder.addQueryParams(KeyValuePair.newBuilder().setKey("iterator").setValue(String.valueOf(Boolean.TRUE)).build());
        builder.setGuaranteeTimestamp(ts).build();
        builder.setUseDefaultConsistency(true);
        QueryResults response = this.rpcUtils.retry(() -> this.blockingStub.query(builder.build()));
        String title = String.format("QueryRequest collectionName:%s", this.queryIteratorParam.getCollectionName());
        this.rpcUtils.handleResponse(title, response.getStatus());
        return response;
    }
}

