/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.common.utils;

import io.milvus.exception.ParamException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class GTsDict {
    private static final GTsDict TS_DICT = new GTsDict();
    private ConcurrentMap<String, Long> tsDict = new ConcurrentHashMap<String, Long>();

    private GTsDict() {
    }

    public static GTsDict getInstance() {
        return TS_DICT;
    }

    public static String CombineCollectionName(String databaseName, String collectionName) {
        if (collectionName == null || StringUtils.isBlank((CharSequence)collectionName)) {
            throw new ParamException("Collection name is empty, not able to get collection info.");
        }
        if (StringUtils.isEmpty((CharSequence)databaseName)) {
            databaseName = "default";
        }
        return String.format("%s_%s", databaseName, collectionName);
    }

    public void updateCollectionTs(String name, long ts) {
        this.tsDict.compute(name, (key, value) -> value == null ? ts : (ts > value ? ts : value));
    }

    public Long getCollectionTs(String name) {
        return (Long)this.tsDict.get(name);
    }

    public void removeCollectionTs(String name) {
        this.tsDict.remove(name);
    }

    public void cleanAllCollectionTs() {
        this.tsDict.clear();
    }
}

