/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.alias;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class DropAliasParam {
    private final String alias;
    private final String databaseName;

    private DropAliasParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.alias = builder.alias;
        this.databaseName = builder.databaseName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        return "DropAliasParam(alias=" + this.getAlias() + ", databaseName=" + this.getDatabaseName() + ")";
    }

    public static final class Builder {
        private String alias;
        private String databaseName;

        private Builder() {
        }

        public Builder withAlias(@NonNull String alias) {
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            this.alias = alias;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public DropAliasParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.alias, "Alias");
            return new DropAliasParam(this);
        }
    }
}

