/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.stub.MetadataUtils;
import io.milvus.client.AbstractMilvusGrpcClient;
import io.milvus.client.MilvusClient;
import io.milvus.exception.MilvusException;
import io.milvus.exception.ServerException;
import io.milvus.grpc.CheckHealthResponse;
import io.milvus.grpc.ClientInfo;
import io.milvus.grpc.ConnectRequest;
import io.milvus.grpc.ConnectResponse;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.DescribeResourceGroupResponse;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.FlushAllResponse;
import io.milvus.grpc.FlushResponse;
import io.milvus.grpc.GetCollectionStatisticsResponse;
import io.milvus.grpc.GetCompactionPlansResponse;
import io.milvus.grpc.GetCompactionStateResponse;
import io.milvus.grpc.GetFlushAllStateResponse;
import io.milvus.grpc.GetFlushStateResponse;
import io.milvus.grpc.GetImportStateResponse;
import io.milvus.grpc.GetIndexBuildProgressResponse;
import io.milvus.grpc.GetIndexStateResponse;
import io.milvus.grpc.GetLoadStateResponse;
import io.milvus.grpc.GetLoadingProgressResponse;
import io.milvus.grpc.GetMetricsResponse;
import io.milvus.grpc.GetPartitionStatisticsResponse;
import io.milvus.grpc.GetPersistentSegmentInfoResponse;
import io.milvus.grpc.GetQuerySegmentInfoResponse;
import io.milvus.grpc.GetReplicasResponse;
import io.milvus.grpc.GetVersionResponse;
import io.milvus.grpc.ImportResponse;
import io.milvus.grpc.ListAliasesResponse;
import io.milvus.grpc.ListCredUsersResponse;
import io.milvus.grpc.ListDatabasesResponse;
import io.milvus.grpc.ListImportTasksResponse;
import io.milvus.grpc.ListResourceGroupsResponse;
import io.milvus.grpc.ManualCompactionResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.SelectGrantResponse;
import io.milvus.grpc.SelectRoleResponse;
import io.milvus.grpc.SelectUserResponse;
import io.milvus.grpc.ShowCollectionsResponse;
import io.milvus.grpc.ShowPartitionsResponse;
import io.milvus.orm.iterator.QueryIterator;
import io.milvus.orm.iterator.SearchIterator;
import io.milvus.param.ConnectParam;
import io.milvus.param.LogLevel;
import io.milvus.param.R;
import io.milvus.param.RetryParam;
import io.milvus.param.RpcStatus;
import io.milvus.param.alias.AlterAliasParam;
import io.milvus.param.alias.CreateAliasParam;
import io.milvus.param.alias.DropAliasParam;
import io.milvus.param.alias.ListAliasesParam;
import io.milvus.param.bulkinsert.BulkInsertParam;
import io.milvus.param.bulkinsert.GetBulkInsertStateParam;
import io.milvus.param.bulkinsert.ListBulkInsertTasksParam;
import io.milvus.param.collection.AlterCollectionParam;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.CreateDatabaseParam;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.DropDatabaseParam;
import io.milvus.param.collection.FlushParam;
import io.milvus.param.collection.GetCollectionStatisticsParam;
import io.milvus.param.collection.GetLoadStateParam;
import io.milvus.param.collection.GetLoadingProgressParam;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.collection.RenameCollectionParam;
import io.milvus.param.collection.ShowCollectionsParam;
import io.milvus.param.control.GetCompactionPlansParam;
import io.milvus.param.control.GetCompactionStateParam;
import io.milvus.param.control.GetFlushAllStateParam;
import io.milvus.param.control.GetFlushStateParam;
import io.milvus.param.control.GetMetricsParam;
import io.milvus.param.control.GetPersistentSegmentInfoParam;
import io.milvus.param.control.GetQuerySegmentInfoParam;
import io.milvus.param.control.GetReplicasParam;
import io.milvus.param.control.LoadBalanceParam;
import io.milvus.param.control.ManualCompactParam;
import io.milvus.param.credential.CreateCredentialParam;
import io.milvus.param.credential.DeleteCredentialParam;
import io.milvus.param.credential.ListCredUsersParam;
import io.milvus.param.credential.UpdateCredentialParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryIteratorParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchIteratorParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.dml.UpsertParam;
import io.milvus.param.highlevel.collection.CreateSimpleCollectionParam;
import io.milvus.param.highlevel.collection.ListCollectionsParam;
import io.milvus.param.highlevel.collection.response.ListCollectionsResponse;
import io.milvus.param.highlevel.dml.DeleteIdsParam;
import io.milvus.param.highlevel.dml.GetIdsParam;
import io.milvus.param.highlevel.dml.InsertRowsParam;
import io.milvus.param.highlevel.dml.QuerySimpleParam;
import io.milvus.param.highlevel.dml.SearchSimpleParam;
import io.milvus.param.highlevel.dml.response.DeleteResponse;
import io.milvus.param.highlevel.dml.response.GetResponse;
import io.milvus.param.highlevel.dml.response.InsertResponse;
import io.milvus.param.highlevel.dml.response.QueryResponse;
import io.milvus.param.highlevel.dml.response.SearchResponse;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DescribeIndexParam;
import io.milvus.param.index.DropIndexParam;
import io.milvus.param.index.GetIndexBuildProgressParam;
import io.milvus.param.index.GetIndexStateParam;
import io.milvus.param.partition.CreatePartitionParam;
import io.milvus.param.partition.DropPartitionParam;
import io.milvus.param.partition.GetPartitionStatisticsParam;
import io.milvus.param.partition.HasPartitionParam;
import io.milvus.param.partition.LoadPartitionsParam;
import io.milvus.param.partition.ReleasePartitionsParam;
import io.milvus.param.partition.ShowPartitionsParam;
import io.milvus.param.resourcegroup.CreateResourceGroupParam;
import io.milvus.param.resourcegroup.DescribeResourceGroupParam;
import io.milvus.param.resourcegroup.DropResourceGroupParam;
import io.milvus.param.resourcegroup.ListResourceGroupsParam;
import io.milvus.param.resourcegroup.TransferNodeParam;
import io.milvus.param.resourcegroup.TransferReplicaParam;
import io.milvus.param.role.AddUserToRoleParam;
import io.milvus.param.role.CreateRoleParam;
import io.milvus.param.role.DropRoleParam;
import io.milvus.param.role.GrantRolePrivilegeParam;
import io.milvus.param.role.RemoveUserFromRoleParam;
import io.milvus.param.role.RevokeRolePrivilegeParam;
import io.milvus.param.role.SelectGrantForRoleAndObjectParam;
import io.milvus.param.role.SelectGrantForRoleParam;
import io.milvus.param.role.SelectRoleParam;
import io.milvus.param.role.SelectUserParam;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class MilvusServiceClient
extends AbstractMilvusGrpcClient {
    private ManagedChannel channel;
    private final MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub;
    private final MilvusServiceGrpc.MilvusServiceFutureStub futureStub;
    private final long rpcDeadlineMs;
    private long timeoutMs = 0L;
    private RetryParam retryParam = RetryParam.newBuilder().build();

    public MilvusServiceClient(@NonNull ConnectParam connectParam) {
        if (connectParam == null) {
            throw new NullPointerException("connectParam is marked non-null but is null");
        }
        this.rpcDeadlineMs = connectParam.getRpcDeadlineMs();
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)connectParam.getAuthorization());
        if (StringUtils.isNotEmpty((CharSequence)connectParam.getDatabaseName())) {
            metadata.put(Metadata.Key.of((String)"dbname", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)connectParam.getDatabaseName());
        }
        try {
            NettyChannelBuilder builder;
            SslContext sslContext;
            if (StringUtils.isNotEmpty((CharSequence)connectParam.getServerPemPath())) {
                sslContext = GrpcSslContexts.forClient().trustManager(new File(connectParam.getServerPemPath())).build();
                builder = (NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)connectParam.getHost(), (int)connectParam.getPort()).overrideAuthority(connectParam.getServerName())).sslContext(sslContext).maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectParam.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectParam.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectParam.isKeepAliveWithoutCalls()).idleTimeout(connectParam.getIdleTimeoutMs(), TimeUnit.MILLISECONDS)).intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
                if (connectParam.isSecure()) {
                    builder.useTransportSecurity();
                }
                this.channel = builder.build();
            } else if (StringUtils.isNotEmpty((CharSequence)connectParam.getClientPemPath()) && StringUtils.isNotEmpty((CharSequence)connectParam.getClientKeyPath()) && StringUtils.isNotEmpty((CharSequence)connectParam.getCaPemPath())) {
                sslContext = GrpcSslContexts.forClient().trustManager(new File(connectParam.getCaPemPath())).keyManager(new File(connectParam.getClientPemPath()), new File(connectParam.getClientKeyPath())).build();
                builder = (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)connectParam.getHost(), (int)connectParam.getPort()).sslContext(sslContext).maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectParam.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectParam.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectParam.isKeepAliveWithoutCalls()).idleTimeout(connectParam.getIdleTimeoutMs(), TimeUnit.MILLISECONDS)).intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
                if (connectParam.isSecure()) {
                    builder.useTransportSecurity();
                }
                if (StringUtils.isNotEmpty((CharSequence)connectParam.getServerName())) {
                    builder.overrideAuthority(connectParam.getServerName());
                }
                this.channel = builder.build();
            } else {
                ManagedChannelBuilder builder2 = ManagedChannelBuilder.forAddress((String)connectParam.getHost(), (int)connectParam.getPort()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectParam.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectParam.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectParam.isKeepAliveWithoutCalls()).idleTimeout(connectParam.getIdleTimeoutMs(), TimeUnit.MILLISECONDS).intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
                if (connectParam.isSecure()) {
                    builder2.useTransportSecurity();
                }
                this.channel = builder2.build();
            }
        }
        catch (IOException e) {
            String msg = "Failed to open credentials file. Error: " + e.getMessage();
            this.logError(msg, new Object[0]);
            throw new RuntimeException(msg);
        }
        assert (this.channel != null);
        this.blockingStub = MilvusServiceGrpc.newBlockingStub((Channel)this.channel);
        this.futureStub = MilvusServiceGrpc.newFutureStub((Channel)this.channel);
        this.timeoutMs = connectParam.getConnectTimeoutMs();
        R resp = this.retry(() -> this.connect(connectParam));
        if (resp.getStatus().intValue() != R.Status.Success.getCode()) {
            String msg = "Failed to initialize connection. Error: " + resp.getMessage();
            this.logError(msg, new Object[0]);
            throw new RuntimeException(msg);
        }
        this.timeoutMs = 0L;
    }

    protected MilvusServiceClient(MilvusServiceClient src) {
        this.channel = src.channel;
        this.blockingStub = src.blockingStub;
        this.futureStub = src.futureStub;
        this.rpcDeadlineMs = src.rpcDeadlineMs;
        this.timeoutMs = src.timeoutMs;
        this.logLevel = src.logLevel;
        this.retryParam = src.retryParam;
    }

    @Override
    protected MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub() {
        if (this.rpcDeadlineMs > 0L) {
            return (MilvusServiceGrpc.MilvusServiceBlockingStub)((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withWaitForReady()).withDeadlineAfter(this.rpcDeadlineMs, TimeUnit.MILLISECONDS);
        }
        return this.blockingStub;
    }

    @Override
    protected MilvusServiceGrpc.MilvusServiceFutureStub futureStub() {
        return this.futureStub;
    }

    @Override
    protected boolean clientIsReady() {
        ConnectivityState state = this.channel.getState(false);
        return state != ConnectivityState.SHUTDOWN;
    }

    @Override
    public void close(long maxWaitSeconds) throws InterruptedException {
        this.channel.shutdownNow();
        this.channel.awaitTermination(maxWaitSeconds, TimeUnit.SECONDS);
    }

    @Override
    public MilvusClient withTimeout(long timeout, TimeUnit timeoutUnit) {
        long timeoutMillis = timeoutUnit.toMillis(timeout);
        TimeoutInterceptor timeoutInterceptor = new TimeoutInterceptor(timeoutMillis);
        final MilvusServiceGrpc.MilvusServiceBlockingStub blockingStubTimeout = (MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withInterceptors(new ClientInterceptor[]{timeoutInterceptor});
        final MilvusServiceGrpc.MilvusServiceFutureStub futureStubTimeout = (MilvusServiceGrpc.MilvusServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{timeoutInterceptor});
        MilvusServiceClient newClient = new MilvusServiceClient(this){

            @Override
            protected MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub() {
                return blockingStubTimeout;
            }

            @Override
            protected MilvusServiceGrpc.MilvusServiceFutureStub futureStub() {
                return futureStubTimeout;
            }
        };
        newClient.timeoutMs = timeoutMillis;
        return newClient;
    }

    @Override
    public MilvusClient withRetry(RetryParam retryParam) {
        MilvusServiceClient newClient = new MilvusServiceClient(this);
        newClient.retryParam = retryParam;
        return newClient;
    }

    @Override
    public MilvusClient withRetry(int retryTimes) {
        if (retryTimes <= 0) {
            return this;
        }
        MilvusServiceClient newClient = new MilvusServiceClient(this);
        newClient.retryParam.setMaxRetryTimes(retryTimes);
        return newClient;
    }

    @Override
    public MilvusClient withRetryInterval(long interval, TimeUnit timeUnit) {
        if (interval <= 0L) {
            return this;
        }
        MilvusServiceClient newClient = new MilvusServiceClient(this);
        newClient.retryParam.setInitialBackOffMs(timeUnit.toMillis(interval));
        newClient.retryParam.setMaxBackOffMs(timeUnit.toMillis(interval));
        return newClient;
    }

    private <T> R<T> retry(Callable<R<T>> callable) {
        int maxRetryTimes = this.retryParam.getMaxRetryTimes();
        if (maxRetryTimes <= 1) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                return R.failed(e);
            }
        }
        long begin = System.currentTimeMillis();
        Callable<Boolean> timeoutChecker = () -> {
            long current = System.currentTimeMillis();
            long cost = current - begin;
            if (this.timeoutMs > 0L && cost >= this.timeoutMs) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        };
        long retryIntervalMs = this.retryParam.getInitialBackOffMs();
        for (int k = 1; k <= maxRetryTimes; ++k) {
            try {
                R<T> resp = callable.call();
                if (resp.getStatus().intValue() == R.Status.Success.getCode()) {
                    return resp;
                }
                Exception e = resp.getException();
                if (e instanceof StatusRuntimeException) {
                    StatusRuntimeException rpcException = (StatusRuntimeException)e;
                    Status.Code code = rpcException.getStatus().getCode();
                    if (code == Status.DEADLINE_EXCEEDED.getCode() || code == Status.PERMISSION_DENIED.getCode() || code == Status.UNAUTHENTICATED.getCode() || code == Status.INVALID_ARGUMENT.getCode() || code == Status.ALREADY_EXISTS.getCode() || code == Status.RESOURCE_EXHAUSTED.getCode()) {
                        return resp;
                    }
                    if (timeoutChecker.call() == Boolean.TRUE) {
                        String msg = String.format("Retry timeout: %dms, maxRetry:%d, retries: %d, reason: %s", this.timeoutMs, maxRetryTimes, k, e.getMessage());
                        throw new MilvusException(msg, code.value());
                    }
                } else if (e instanceof ServerException) {
                    ServerException serverException = (ServerException)e;
                    if (timeoutChecker.call() == Boolean.TRUE) {
                        String msg = String.format("Retry timeout: %dms, maxRetry:%d, retries: %d, reason: %s", this.timeoutMs, maxRetryTimes, k, e.getMessage());
                        throw new MilvusException(msg, serverException.getStatus());
                    }
                    if (!this.retryParam.isRetryOnRateLimie() || serverException.getCompatibleCode() != ErrorCode.RateLimit && serverException.getStatus() != 8) {
                        return resp;
                    }
                } else {
                    return resp;
                }
                if (k >= maxRetryTimes) {
                    String msg = String.format("Finish %d retry times, stop retry", maxRetryTimes);
                    this.logError(msg, new Object[0]);
                    return resp;
                }
                if (k > 3) {
                    this.logWarning(String.format("Retry(%d) with interval %dms. Reason: %s", k, retryIntervalMs, e.getMessage()), new Object[0]);
                }
                TimeUnit.MILLISECONDS.sleep(retryIntervalMs);
                if ((retryIntervalMs *= (long)this.retryParam.getBackOffMultiplier()) <= this.retryParam.getMaxBackOffMs()) continue;
                retryIntervalMs = this.retryParam.getMaxBackOffMs();
                continue;
            }
            catch (Exception e) {
                this.logError(e.getMessage(), new Object[0]);
                return R.failed(e);
            }
        }
        String msg = String.format("Finish %d retry times, stop retry", maxRetryTimes);
        this.logError(msg, new Object[0]);
        return R.failed(new RuntimeException(msg));
    }

    private R<ConnectResponse> connect(@NonNull ConnectParam connectParam) {
        if (connectParam == null) {
            throw new NullPointerException("connectParam is marked non-null but is null");
        }
        ClientInfo info = ClientInfo.newBuilder().setSdkType("Java").setSdkVersion(this.getSDKVersion()).setUser(connectParam.getUserName()).setHost(this.getHostName()).setLocalTime(this.getLocalTimeStr()).build();
        ConnectRequest req = ConnectRequest.newBuilder().setClientInfo(info).build();
        ConnectResponse resp = ((MilvusServiceGrpc.MilvusServiceBlockingStub)((MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withWaitForReady()).withDeadlineAfter(connectParam.getConnectTimeoutMs(), TimeUnit.MILLISECONDS)).connect(req);
        if (resp.getStatus().getCode() != 0 || !resp.getStatus().getErrorCode().equals((Object)ErrorCode.Success)) {
            throw new RuntimeException("Failed to initialize connection. Error: " + resp.getStatus().getReason());
        }
        return R.success(resp);
    }

    private String getHostName() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostName();
        }
        catch (UnknownHostException e) {
            this.logWarning("Failed to get host name! Exception:{}", e);
            return "Unknown";
        }
    }

    private String getLocalTimeStr() {
        LocalDateTime now = LocalDateTime.now();
        return now.toString();
    }

    private String getSDKVersion() {
        Package pkg = MilvusServiceClient.class.getPackage();
        String ver = pkg.getImplementationVersion();
        if (ver == null) {
            return "";
        }
        return ver;
    }

    @Override
    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    @Override
    public R<Boolean> hasCollection(HasCollectionParam requestParam) {
        return this.retry(() -> super.hasCollection(requestParam));
    }

    @Override
    public R<RpcStatus> createDatabase(CreateDatabaseParam requestParam) {
        return this.retry(() -> super.createDatabase(requestParam));
    }

    @Override
    public R<RpcStatus> dropDatabase(DropDatabaseParam requestParam) {
        return this.retry(() -> super.dropDatabase(requestParam));
    }

    @Override
    public R<ListDatabasesResponse> listDatabases() {
        return this.retry(() -> super.listDatabases());
    }

    @Override
    public R<RpcStatus> createCollection(CreateCollectionParam requestParam) {
        return this.retry(() -> super.createCollection(requestParam));
    }

    @Override
    public R<RpcStatus> dropCollection(DropCollectionParam requestParam) {
        return this.retry(() -> super.dropCollection(requestParam));
    }

    @Override
    public R<RpcStatus> loadCollection(LoadCollectionParam requestParam) {
        return this.retry(() -> super.loadCollection(requestParam));
    }

    @Override
    public R<RpcStatus> releaseCollection(ReleaseCollectionParam requestParam) {
        return this.retry(() -> super.releaseCollection(requestParam));
    }

    @Override
    public R<DescribeCollectionResponse> describeCollection(DescribeCollectionParam requestParam) {
        return this.retry(() -> super.describeCollection(requestParam));
    }

    @Override
    public R<GetCollectionStatisticsResponse> getCollectionStatistics(GetCollectionStatisticsParam requestParam) {
        return this.retry(() -> super.getCollectionStatistics(requestParam));
    }

    @Override
    public R<RpcStatus> renameCollection(RenameCollectionParam requestParam) {
        return this.retry(() -> super.renameCollection(requestParam));
    }

    @Override
    public R<ShowCollectionsResponse> showCollections(ShowCollectionsParam requestParam) {
        return this.retry(() -> super.showCollections(requestParam));
    }

    @Override
    public R<RpcStatus> alterCollection(AlterCollectionParam requestParam) {
        return this.retry(() -> super.alterCollection(requestParam));
    }

    @Override
    public R<FlushResponse> flush(FlushParam requestParam) {
        return this.retry(() -> super.flush(requestParam));
    }

    @Override
    public R<FlushAllResponse> flushAll(boolean syncFlushAll, long syncFlushAllWaitingInterval, long syncFlushAllTimeout) {
        return this.retry(() -> super.flushAll(syncFlushAll, syncFlushAllWaitingInterval, syncFlushAllTimeout));
    }

    @Override
    public R<RpcStatus> createPartition(CreatePartitionParam requestParam) {
        return this.retry(() -> super.createPartition(requestParam));
    }

    @Override
    public R<RpcStatus> dropPartition(DropPartitionParam requestParam) {
        return this.retry(() -> super.dropPartition(requestParam));
    }

    @Override
    public R<Boolean> hasPartition(HasPartitionParam requestParam) {
        return this.retry(() -> super.hasPartition(requestParam));
    }

    @Override
    public R<RpcStatus> loadPartitions(LoadPartitionsParam requestParam) {
        return this.retry(() -> super.loadPartitions(requestParam));
    }

    @Override
    public R<RpcStatus> releasePartitions(ReleasePartitionsParam requestParam) {
        return this.retry(() -> super.releasePartitions(requestParam));
    }

    @Override
    public R<GetPartitionStatisticsResponse> getPartitionStatistics(GetPartitionStatisticsParam requestParam) {
        return this.retry(() -> super.getPartitionStatistics(requestParam));
    }

    @Override
    public R<ShowPartitionsResponse> showPartitions(ShowPartitionsParam requestParam) {
        return this.retry(() -> super.showPartitions(requestParam));
    }

    @Override
    public R<RpcStatus> createAlias(CreateAliasParam requestParam) {
        return this.retry(() -> super.createAlias(requestParam));
    }

    @Override
    public R<RpcStatus> dropAlias(DropAliasParam requestParam) {
        return this.retry(() -> super.dropAlias(requestParam));
    }

    @Override
    public R<RpcStatus> alterAlias(AlterAliasParam requestParam) {
        return this.retry(() -> super.alterAlias(requestParam));
    }

    @Override
    public R<ListAliasesResponse> listAliases(ListAliasesParam requestParam) {
        return this.retry(() -> super.listAliases(requestParam));
    }

    @Override
    public R<RpcStatus> createIndex(CreateIndexParam requestParam) {
        return this.retry(() -> super.createIndex(requestParam));
    }

    @Override
    public R<RpcStatus> dropIndex(DropIndexParam requestParam) {
        return this.retry(() -> super.dropIndex(requestParam));
    }

    @Override
    public R<DescribeIndexResponse> describeIndex(DescribeIndexParam requestParam) {
        return this.retry(() -> super.describeIndex(requestParam));
    }

    @Override
    public R<GetIndexStateResponse> getIndexState(@NonNull GetIndexStateParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        return this.retry(() -> super.getIndexState(requestParam));
    }

    @Override
    public R<GetIndexBuildProgressResponse> getIndexBuildProgress(@NonNull GetIndexBuildProgressParam requestParam) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        return this.retry(() -> super.getIndexBuildProgress(requestParam));
    }

    @Override
    public R<MutationResult> insert(InsertParam requestParam) {
        return this.retry(() -> super.insert(requestParam));
    }

    @Override
    public R<MutationResult> upsert(UpsertParam requestParam) {
        return this.retry(() -> super.upsert(requestParam));
    }

    @Override
    public R<MutationResult> delete(DeleteParam requestParam) {
        return this.retry(() -> super.delete(requestParam));
    }

    @Override
    public R<SearchResults> search(SearchParam requestParam) {
        return this.retry(() -> super.search(requestParam));
    }

    @Override
    public R<QueryResults> query(QueryParam requestParam) {
        return this.retry(() -> super.query(requestParam));
    }

    @Override
    public R<GetMetricsResponse> getMetrics(GetMetricsParam requestParam) {
        return this.retry(() -> super.getMetrics(requestParam));
    }

    @Override
    public R<GetFlushStateResponse> getFlushState(GetFlushStateParam requestParam) {
        return this.retry(() -> super.getFlushState(requestParam));
    }

    @Override
    public R<GetFlushAllStateResponse> getFlushAllState(GetFlushAllStateParam requestParam) {
        return this.retry(() -> super.getFlushAllState(requestParam));
    }

    @Override
    public R<GetPersistentSegmentInfoResponse> getPersistentSegmentInfo(GetPersistentSegmentInfoParam requestParam) {
        return this.retry(() -> super.getPersistentSegmentInfo(requestParam));
    }

    @Override
    public R<GetQuerySegmentInfoResponse> getQuerySegmentInfo(GetQuerySegmentInfoParam requestParam) {
        return this.retry(() -> super.getQuerySegmentInfo(requestParam));
    }

    @Override
    public R<GetReplicasResponse> getReplicas(GetReplicasParam requestParam) {
        return this.retry(() -> super.getReplicas(requestParam));
    }

    @Override
    public R<RpcStatus> loadBalance(LoadBalanceParam requestParam) {
        return this.retry(() -> super.loadBalance(requestParam));
    }

    @Override
    public R<GetCompactionStateResponse> getCompactionState(GetCompactionStateParam requestParam) {
        return this.retry(() -> super.getCompactionState(requestParam));
    }

    @Override
    public R<ManualCompactionResponse> manualCompact(ManualCompactParam requestParam) {
        return this.retry(() -> super.manualCompact(requestParam));
    }

    @Override
    public R<GetCompactionPlansResponse> getCompactionStateWithPlans(GetCompactionPlansParam requestParam) {
        return this.retry(() -> super.getCompactionStateWithPlans(requestParam));
    }

    @Override
    public R<RpcStatus> createCredential(CreateCredentialParam requestParam) {
        return this.retry(() -> super.createCredential(requestParam));
    }

    @Override
    public R<RpcStatus> updateCredential(UpdateCredentialParam requestParam) {
        return this.retry(() -> super.updateCredential(requestParam));
    }

    @Override
    public R<RpcStatus> deleteCredential(DeleteCredentialParam requestParam) {
        return this.retry(() -> super.deleteCredential(requestParam));
    }

    @Override
    public R<ListCredUsersResponse> listCredUsers(ListCredUsersParam requestParam) {
        return this.retry(() -> super.listCredUsers(requestParam));
    }

    @Override
    public R<RpcStatus> createRole(CreateRoleParam requestParam) {
        return this.retry(() -> super.createRole(requestParam));
    }

    @Override
    public R<RpcStatus> dropRole(DropRoleParam requestParam) {
        return this.retry(() -> super.dropRole(requestParam));
    }

    @Override
    public R<RpcStatus> addUserToRole(AddUserToRoleParam requestParam) {
        return this.retry(() -> super.addUserToRole(requestParam));
    }

    @Override
    public R<RpcStatus> removeUserFromRole(RemoveUserFromRoleParam requestParam) {
        return this.retry(() -> super.removeUserFromRole(requestParam));
    }

    @Override
    public R<SelectRoleResponse> selectRole(SelectRoleParam requestParam) {
        return this.retry(() -> super.selectRole(requestParam));
    }

    @Override
    public R<SelectUserResponse> selectUser(SelectUserParam requestParam) {
        return this.retry(() -> super.selectUser(requestParam));
    }

    @Override
    public R<RpcStatus> grantRolePrivilege(GrantRolePrivilegeParam requestParam) {
        return this.retry(() -> super.grantRolePrivilege(requestParam));
    }

    @Override
    public R<RpcStatus> revokeRolePrivilege(RevokeRolePrivilegeParam requestParam) {
        return this.retry(() -> super.revokeRolePrivilege(requestParam));
    }

    @Override
    public R<SelectGrantResponse> selectGrantForRole(SelectGrantForRoleParam requestParam) {
        return this.retry(() -> super.selectGrantForRole(requestParam));
    }

    @Override
    public R<SelectGrantResponse> selectGrantForRoleAndObject(SelectGrantForRoleAndObjectParam requestParam) {
        return this.retry(() -> super.selectGrantForRoleAndObject(requestParam));
    }

    @Override
    public R<ImportResponse> bulkInsert(BulkInsertParam requestParam) {
        return this.retry(() -> super.bulkInsert(requestParam));
    }

    @Override
    public R<GetImportStateResponse> getBulkInsertState(GetBulkInsertStateParam requestParam) {
        return this.retry(() -> super.getBulkInsertState(requestParam));
    }

    @Override
    public R<ListImportTasksResponse> listBulkInsertTasks(ListBulkInsertTasksParam requestParam) {
        return this.retry(() -> super.listBulkInsertTasks(requestParam));
    }

    @Override
    public R<CheckHealthResponse> checkHealth() {
        return this.retry(() -> super.checkHealth());
    }

    @Override
    public R<GetVersionResponse> getVersion() {
        return this.retry(() -> super.getVersion());
    }

    @Override
    public R<GetLoadingProgressResponse> getLoadingProgress(GetLoadingProgressParam requestParam) {
        return this.retry(() -> super.getLoadingProgress(requestParam));
    }

    @Override
    public R<GetLoadStateResponse> getLoadState(GetLoadStateParam requestParam) {
        return this.retry(() -> super.getLoadState(requestParam));
    }

    @Override
    public R<RpcStatus> createResourceGroup(CreateResourceGroupParam requestParam) {
        return this.retry(() -> super.createResourceGroup(requestParam));
    }

    @Override
    public R<RpcStatus> dropResourceGroup(DropResourceGroupParam requestParam) {
        return this.retry(() -> super.dropResourceGroup(requestParam));
    }

    @Override
    public R<ListResourceGroupsResponse> listResourceGroups(ListResourceGroupsParam requestParam) {
        return this.retry(() -> super.listResourceGroups(requestParam));
    }

    @Override
    public R<DescribeResourceGroupResponse> describeResourceGroup(DescribeResourceGroupParam requestParam) {
        return this.retry(() -> super.describeResourceGroup(requestParam));
    }

    @Override
    public R<RpcStatus> transferNode(TransferNodeParam requestParam) {
        return this.retry(() -> super.transferNode(requestParam));
    }

    @Override
    public R<RpcStatus> transferReplica(TransferReplicaParam requestParam) {
        return this.retry(() -> super.transferReplica(requestParam));
    }

    @Override
    public R<RpcStatus> createCollection(CreateSimpleCollectionParam requestParam) {
        return this.retry(() -> super.createCollection(requestParam));
    }

    @Override
    public R<ListCollectionsResponse> listCollections(ListCollectionsParam requestParam) {
        return this.retry(() -> super.listCollections(requestParam));
    }

    @Override
    public R<InsertResponse> insert(InsertRowsParam requestParam) {
        return this.retry(() -> super.insert(requestParam));
    }

    @Override
    public R<DeleteResponse> delete(DeleteIdsParam requestParam) {
        return this.retry(() -> super.delete(requestParam));
    }

    @Override
    public R<GetResponse> get(GetIdsParam requestParam) {
        return this.retry(() -> super.get(requestParam));
    }

    @Override
    public R<QueryResponse> query(QuerySimpleParam requestParam) {
        return this.retry(() -> super.query(requestParam));
    }

    @Override
    public R<SearchResponse> search(SearchSimpleParam requestParam) {
        return this.retry(() -> super.search(requestParam));
    }

    @Override
    public R<QueryIterator> queryIterator(QueryIteratorParam requestParam) {
        return this.retry(() -> super.queryIterator(requestParam));
    }

    @Override
    public R<SearchIterator> searchIterator(SearchIteratorParam requestParam) {
        return this.retry(() -> super.searchIterator(requestParam));
    }

    private static class TimeoutInterceptor
    implements ClientInterceptor {
        private final long timeoutMillis;

        TimeoutInterceptor(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return next.newCall(method, callOptions.withDeadlineAfter(this.timeoutMillis, TimeUnit.MILLISECONDS));
        }
    }
}

