/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.highlevel.dml;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;

public class DeleteIdsParam {
    private final String collectionName;
    private final String partitionName;
    private final List<?> primaryIds;

    private DeleteIdsParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.primaryIds = builder.primaryIds;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public List<?> getPrimaryIds() {
        return this.primaryIds;
    }

    public String toString() {
        return "DeleteIdsParam(collectionName=" + this.getCollectionName() + ", partitionName=" + this.getPartitionName() + ", primaryIds=" + this.getPrimaryIds() + ")";
    }

    public static class Builder<T> {
        private String collectionName;
        private String partitionName = "";
        private List<T> primaryIds = new ArrayList<T>();

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public Builder withPrimaryIds(@NonNull List<T> primaryIds) {
            if (primaryIds == null) {
                throw new NullPointerException("primaryIds is marked non-null but is null");
            }
            this.primaryIds.addAll(primaryIds);
            return this;
        }

        public Builder addPrimaryId(@NonNull T primaryId) {
            if (primaryId == null) {
                throw new NullPointerException("primaryId is marked non-null but is null");
            }
            this.primaryIds.add(primaryId);
            return this;
        }

        public DeleteIdsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (CollectionUtils.isEmpty(this.primaryIds)) {
                throw new ParamException("PrimaryIds cannot be empty");
            }
            return new DeleteIdsParam(this);
        }
    }
}

