/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.connection;

import io.milvus.client.MilvusClient;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import io.milvus.param.ServerAddress;
import lombok.NonNull;

public class ServerSetting {
    private final ServerAddress serverAddress;
    private final MilvusClient client;

    public ServerSetting(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.serverAddress = builder.serverAddress;
        this.client = builder.milvusClient;
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public MilvusClient getClient() {
        return this.client;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ServerAddress serverAddress;
        private MilvusClient milvusClient;

        private Builder() {
        }

        public Builder withHost(@NonNull ServerAddress serverAddress) {
            if (serverAddress == null) {
                throw new NullPointerException("serverAddress is marked non-null but is null");
            }
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder withMilvusClient(MilvusClient milvusClient) {
            this.milvusClient = milvusClient;
            return this;
        }

        public ServerSetting build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.serverAddress.getHost(), "Host name");
            if (this.serverAddress.getPort() < 0 || this.serverAddress.getPort() > 65535) {
                throw new ParamException("Port is out of range!");
            }
            if (this.milvusClient == null) {
                throw new ParamException("Milvus client can not be empty");
            }
            return new ServerSetting(this);
        }
    }
}

