/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.control;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class GetReplicasParam {
    private final String collectionName;
    private boolean withShardNodes;

    private GetReplicasParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.withShardNodes = true;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "GetReplicasParam{collectionName='" + this.collectionName + '\'' + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isWithShardNodes() {
        return this.withShardNodes;
    }

    public static final class Builder {
        private String collectionName;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public GetReplicasParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new GetReplicasParam(this);
        }
    }
}

