/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.writer;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.milvus.bulkwriter.writer.FormatFileWriter;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileWriter
implements FormatFileWriter {
    private static final Logger logger = LoggerFactory.getLogger(CSVFileWriter.class);
    private BufferedWriter writer;
    private CreateCollectionReq.CollectionSchema collectionSchema;
    private String filePath;
    private Map<String, Object> config;

    public CSVFileWriter(CreateCollectionReq.CollectionSchema collectionSchema, String filePathPrefix, Map<String, Object> config) throws IOException {
        this.collectionSchema = collectionSchema;
        this.config = config;
        this.initFilePath(filePathPrefix);
        this.initWriter();
    }

    private void initFilePath(String filePathPrefix) {
        this.filePath = filePathPrefix + ".csv";
    }

    private void initWriter() throws IOException {
        this.writer = new BufferedWriter(new FileWriter(this.filePath));
    }

    @Override
    public void appendRow(Map<String, Object> rowValues, boolean firstWrite) throws IOException {
        rowValues.keySet().removeIf(key -> key.equals("$meta") && !this.collectionSchema.isEnableDynamicField());
        Gson gson = new GsonBuilder().serializeNulls().create();
        ArrayList fieldNameList = Lists.newArrayList(rowValues.keySet());
        try {
            String separator = (String)this.config.getOrDefault("sep", ",");
            String nullKey = (String)this.config.getOrDefault("nullkey", "");
            if (firstWrite) {
                this.writer.write(String.join((CharSequence)separator, fieldNameList));
                this.writer.newLine();
            }
            ArrayList<String> values = new ArrayList<String>();
            for (String fieldName : fieldNameList) {
                Object val = rowValues.get(fieldName);
                String strVal = "";
                strVal = val == null ? nullKey : (val instanceof ByteBuffer ? Arrays.toString(((ByteBuffer)val).array()) : (val instanceof List || val instanceof Map ? gson.toJson(val) : val.toString()));
                if (strVal.startsWith("\"") && strVal.endsWith("\"")) {
                    strVal = strVal.substring(1, strVal.length() - 1);
                }
                strVal = strVal.replace("\\\"", "\"");
                if (!(strVal = strVal.replace("\"", "\"\"")).isEmpty()) {
                    strVal = "\"" + strVal + "\"";
                }
                values.add(strVal);
            }
            this.writer.write(String.join((CharSequence)separator, values));
            this.writer.newLine();
        }
        catch (IOException e) {
            logger.error("{} appendRow error when writing to file {}", new Object[]{this.getClass().getSimpleName(), this.filePath, e});
            throw e;
        }
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

