/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import com.google.gson.Gson;
import io.milvus.bulkwriter.StageManagerParam;
import io.milvus.bulkwriter.request.stage.CreateStageRequest;
import io.milvus.bulkwriter.request.stage.DeleteStageRequest;
import io.milvus.bulkwriter.request.stage.ListStagesRequest;
import io.milvus.bulkwriter.response.stage.ListStagesResponse;
import io.milvus.bulkwriter.restful.DataStageUtils;

public class StageManager {
    private final String cloudEndpoint;
    private final String apiKey;

    public StageManager(StageManagerParam stageWriterParam) {
        this.cloudEndpoint = stageWriterParam.getCloudEndpoint();
        this.apiKey = stageWriterParam.getApiKey();
    }

    public void createStage(CreateStageRequest request) {
        DataStageUtils.createStage(this.cloudEndpoint, this.apiKey, request);
    }

    public void deleteStage(DeleteStageRequest request) {
        DataStageUtils.deleteStage(this.cloudEndpoint, this.apiKey, request);
    }

    public ListStagesResponse listStages(ListStagesRequest request) {
        String result = DataStageUtils.listStages(this.cloudEndpoint, this.apiKey, request);
        return (ListStagesResponse)new Gson().fromJson(result, ListStagesResponse.class);
    }
}

