/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.statement;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.statement.StatementWriter;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.ArrayList;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public final class TryCatchStatementWriter
implements StatementWriter {
    public static final String EXCEPTION_NAME = "$exception";
    private final StatementDef.Try aTry;

    public TryCatchStatementWriter(StatementDef.Try aTry) {
        this.aTry = aTry;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context, Runnable finallyBlock) {
        Label end = new Label();
        Label tryStart = new Label();
        Label tryEnd = new Label();
        ArrayList<CatchBlock> exceptionHandlers = new ArrayList<CatchBlock>();
        for (Object aCatch : this.aTry.catches()) {
            Label label = new Label();
            exceptionHandlers.add(new CatchBlock((StatementDef.Try.Catch)aCatch, label));
            generatorAdapter.visitTryCatchBlock(tryStart, tryEnd, label, TypeUtils.getType((TypeDef)aCatch.exception(), context.objectDef()).getInternalName());
        }
        Label finallyExceptionHandler = null;
        if (this.aTry.finallyStatement() != null) {
            finallyExceptionHandler = new Label();
            generatorAdapter.visitTryCatchBlock(tryStart, tryEnd, finallyExceptionHandler, null);
            for (CatchBlock catchBlock : exceptionHandlers) {
                catchBlock.to = new Label();
                generatorAdapter.visitTryCatchBlock(catchBlock.from, catchBlock.to, finallyExceptionHandler, null);
            }
        }
        generatorAdapter.visitLabel(tryStart);
        Runnable thisFinallyBlock = this.aTry.finallyStatement() == null ? null : () -> StatementWriter.of(this.aTry.finallyStatement()).writeScoped(generatorAdapter, context, finallyBlock);
        StatementWriter.of(this.aTry.statement()).writeScoped(generatorAdapter, context, thisFinallyBlock);
        generatorAdapter.visitLabel(tryEnd);
        generatorAdapter.goTo(end);
        for (CatchBlock catchBlock : exceptionHandlers) {
            StatementDef.Try.Catch aCatch = catchBlock.aCatch;
            generatorAdapter.visitLabel(catchBlock.from);
            Type exceptionType = TypeUtils.getType((TypeDef)aCatch.exception(), context.objectDef());
            int local = generatorAdapter.newLocal(exceptionType);
            generatorAdapter.storeLocal(local);
            String varName = EXCEPTION_NAME;
            context.locals().put(varName, new MethodContext.LocalData(varName, exceptionType, catchBlock.from, local));
            StatementWriter.of(aCatch.statement()).writeScoped(generatorAdapter, context, thisFinallyBlock);
            context.locals().remove(varName);
            if (catchBlock.to != null) {
                generatorAdapter.visitLabel(catchBlock.to);
            }
            if (this.aTry.finallyStatement() != null) {
                StatementWriter.of(this.aTry.finallyStatement()).writeScoped(generatorAdapter, context, thisFinallyBlock);
            }
            generatorAdapter.goTo(end);
        }
        if (finallyExceptionHandler != null) {
            generatorAdapter.visitLabel(finallyExceptionHandler);
            Type type = TypeUtils.getType(TypeDef.of(Throwable.class), context.objectDef());
            int local = generatorAdapter.newLocal(type);
            generatorAdapter.storeLocal(local);
            StatementWriter.of(this.aTry.finallyStatement()).writeScoped(generatorAdapter, context, finallyBlock);
            generatorAdapter.loadLocal(local);
            generatorAdapter.throwException();
            generatorAdapter.goTo(end);
        }
        generatorAdapter.visitLabel(end);
    }

    private static final class CatchBlock {
        private final StatementDef.Try.Catch aCatch;
        private final Label from;
        private Label to;

        private CatchBlock(StatementDef.Try.Catch aCatch, Label from) {
            this.aCatch = aCatch;
            this.from = from;
        }
    }
}

