/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.statement;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.bytecode.statement.StatementWriter;
import io.micronaut.sourcegen.model.StatementDef;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class SynchronizedStatementWriter
implements StatementWriter {
    private final StatementDef.Synchronized aSynchronized;

    public SynchronizedStatementWriter(StatementDef.Synchronized aSynchronized) {
        this.aSynchronized = aSynchronized;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context, Runnable finallyBlock) {
        Label end = new Label();
        Label synchronizedStart = new Label();
        Label synchronizedEnd = new Label();
        Label synchronizedException = new Label();
        Label synchronizedExceptionEnd = new Label();
        generatorAdapter.visitTryCatchBlock(synchronizedStart, synchronizedEnd, synchronizedException, null);
        generatorAdapter.visitTryCatchBlock(synchronizedException, synchronizedExceptionEnd, synchronizedException, null);
        ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, this.aSynchronized.monitor(), this.aSynchronized.monitor().type());
        generatorAdapter.dup();
        Type monitorType = TypeUtils.getType(this.aSynchronized.monitor().type(), context.objectDef());
        int monitorLocal = generatorAdapter.newLocal(monitorType);
        generatorAdapter.storeLocal(monitorLocal);
        generatorAdapter.monitorEnter();
        generatorAdapter.visitLabel(synchronizedStart);
        StatementWriter.of(this.aSynchronized.statement()).writeScoped(generatorAdapter, context, () -> {
            generatorAdapter.loadLocal(monitorLocal);
            generatorAdapter.monitorExit();
            if (finallyBlock != null) {
                finallyBlock.run();
            }
        });
        generatorAdapter.loadLocal(monitorLocal);
        generatorAdapter.monitorExit();
        generatorAdapter.visitLabel(synchronizedEnd);
        generatorAdapter.goTo(end);
        generatorAdapter.visitLabel(synchronizedException);
        Type throwableType = Type.getType(Throwable.class);
        int exceptionLocal = generatorAdapter.newLocal(throwableType);
        generatorAdapter.storeLocal(exceptionLocal);
        generatorAdapter.loadLocal(monitorLocal);
        generatorAdapter.monitorExit();
        generatorAdapter.visitLabel(synchronizedExceptionEnd);
        generatorAdapter.loadLocal(exceptionLocal, throwableType);
        generatorAdapter.throwException();
        generatorAdapter.visitLabel(end);
    }
}

