/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import org.objectweb.asm.commons.GeneratorAdapter;

final class VariableExpressionWriter
implements ExpressionWriter {
    private final VariableDef variableDef;

    public VariableExpressionWriter(VariableDef variableDef) {
        this.variableDef = variableDef;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        if (context.isLambda()) {
            this.writeLambdaVariable(generatorAdapter, context);
            return;
        }
        if (this.variableDef instanceof VariableDef.ExceptionVar) {
            MethodContext.LocalData localData = context.locals().get("$exception");
            generatorAdapter.loadLocal(localData.index(), localData.type());
            return;
        }
        VariableDef variableDef = this.variableDef;
        if (variableDef instanceof VariableDef.Local) {
            VariableDef.Local localVariableDef = (VariableDef.Local)variableDef;
            MethodContext.LocalData localData = context.locals().get(localVariableDef.name());
            generatorAdapter.loadLocal(localData.index(), localData.type());
            return;
        }
        variableDef = this.variableDef;
        if (variableDef instanceof VariableDef.MethodParameter) {
            VariableDef.MethodParameter parameterVariableDef = (VariableDef.MethodParameter)variableDef;
            this.writeParameterVariable(generatorAdapter, context, parameterVariableDef.name());
            return;
        }
        variableDef = this.variableDef;
        if (variableDef instanceof VariableDef.StaticField) {
            VariableDef.StaticField field = (VariableDef.StaticField)variableDef;
            this.writeStaticField(generatorAdapter, context, field);
            return;
        }
        variableDef = this.variableDef;
        if (variableDef instanceof VariableDef.Field) {
            VariableDef.Field field = (VariableDef.Field)variableDef;
            this.writeField(generatorAdapter, context, field);
            return;
        }
        if (this.variableDef instanceof VariableDef.This) {
            if (context.objectDef() == null) {
                throw new IllegalStateException("Accessing 'this' is not available");
            }
            generatorAdapter.loadThis();
            return;
        }
        if (this.variableDef instanceof VariableDef.Super) {
            if (context.objectDef() == null) {
                throw new IllegalStateException("Accessing 'super' is not available");
            }
            generatorAdapter.loadThis();
            return;
        }
        throw new UnsupportedOperationException("Unrecognized variable: " + this.variableDef);
    }

    private void writeField(GeneratorAdapter generatorAdapter, MethodContext context, VariableDef.Field field) {
        ExpressionWriter.writeExpression(generatorAdapter, context, field.instance());
        TypeDef fieldType = field.type();
        TypeDef owner = field.instance().type();
        generatorAdapter.getField(TypeUtils.getType(owner, context.objectDef()), field.name(), TypeUtils.getType(fieldType, context.objectDef()));
    }

    private void writeParameterVariable(GeneratorAdapter generatorAdapter, MethodContext context, String name) {
        if (context.methodDef() == null) {
            throw new IllegalStateException("Accessing method parameters is not available");
        }
        ParameterDef parameterDef = context.methodDef().getParameters().stream().filter(p -> p.getName().equals(name)).findFirst().orElseThrow();
        int parameterIndex = context.methodDef().getParameters().indexOf(parameterDef);
        generatorAdapter.loadArg(parameterIndex);
    }

    private void writeStaticField(GeneratorAdapter generatorAdapter, MethodContext context, VariableDef.StaticField field) {
        ClassTypeDef owner = field.ownerType();
        TypeDef fieldType = field.type();
        generatorAdapter.getStatic(TypeUtils.getType((TypeDef)owner, context.objectDef()), field.name(), TypeUtils.getType(fieldType, context.objectDef()));
    }

    public void writeLambdaVariable(GeneratorAdapter generatorAdapter, MethodContext context) {
        VariableDef variableDef = this.variableDef;
        if (variableDef instanceof VariableDef.StaticField) {
            VariableDef.StaticField field = (VariableDef.StaticField)variableDef;
            this.writeStaticField(generatorAdapter, context, field);
            return;
        }
        variableDef = this.variableDef;
        if (variableDef instanceof VariableDef.Field) {
            VariableDef.Field field = (VariableDef.Field)variableDef;
            this.writeField(generatorAdapter, context, field);
            return;
        }
        String name = null;
        if (this.variableDef instanceof VariableDef.ExceptionVar) {
            name = "exception";
        } else if (this.variableDef instanceof VariableDef.This) {
            name = "this";
        } else if (this.variableDef instanceof VariableDef.Super) {
            name = "super";
        } else {
            VariableDef variableDef2 = this.variableDef;
            if (variableDef2 instanceof VariableDef.Local) {
                VariableDef.Local local = (VariableDef.Local)variableDef2;
                name = local.name();
            } else {
                variableDef2 = this.variableDef;
                if (variableDef2 instanceof VariableDef.MethodParameter) {
                    VariableDef.MethodParameter methodParameter = (VariableDef.MethodParameter)variableDef2;
                    name = methodParameter.name();
                }
            }
        }
        if (name != null) {
            this.writeParameterVariable(generatorAdapter, context, name);
            return;
        }
        throw new UnsupportedOperationException("Unrecognized lambda variable: " + this.variableDef);
    }
}

