/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.AbstractStatementAwareExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.VariableExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class LambdaExpressionWriter
extends AbstractStatementAwareExpressionWriter {
    public static final String EXCEPTION_VAR_NAME = "exception";
    public static final String THIS_VAR_NAME = "this";
    public static final String SUPER_VAR_NAME = "super";
    private static final String METAFACTORY_OWNER = "java/lang/invoke/LambdaMetafactory";
    private static final String METAFACTORY_METHOD = "metafactory";
    private static final String METAFACTORY_DESCRIPTOR = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
    private final ExpressionDef.Lambda lambda;

    public LambdaExpressionWriter(ExpressionDef.Lambda lambda) {
        this.lambda = lambda;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        List<VariableDef> capturedVariables = this.captureVariables(this.lambda.implementation());
        MethodDef implementationMethodDef = this.createLambdaMethodDef(context, this.lambda, capturedVariables);
        context.lambdaMethods().add(implementationMethodDef);
        for (VariableDef variable : capturedVariables) {
            new VariableExpressionWriter(variable).write(generatorAdapter, context);
        }
        String descriptor = TypeUtils.getType(context.objectDef().getName()).getDescriptor();
        if (descriptor.endsWith(";")) {
            descriptor = descriptor.substring(0, descriptor.length() - 1);
        }
        if (descriptor.startsWith("L")) {
            descriptor = descriptor.substring(1);
        }
        Handle lambdaMethodHandle = new Handle(6, descriptor, implementationMethodDef.getName(), TypeUtils.getMethodDescriptor(context.objectDef(), implementationMethodDef), false);
        Handle bootstrapMethodHandle = new Handle(6, METAFACTORY_OWNER, METAFACTORY_METHOD, METAFACTORY_DESCRIPTOR, false);
        generatorAdapter.visitInvokeDynamicInsn(this.lambda.implementation().getName(), this.createDynamicInvocationDescriptor(capturedVariables, context), bootstrapMethodHandle, new Object[]{Type.getType((String)TypeUtils.getMethodDescriptor(context.objectDef(), this.lambda.target())), lambdaMethodHandle, Type.getType((String)TypeUtils.getMethodDescriptor(context.objectDef(), this.lambda.implementation()))});
        this.popValueIfNeeded(generatorAdapter, (TypeDef)this.lambda.type());
    }

    private String createDynamicInvocationDescriptor(List<VariableDef> capturedVariables, MethodContext context) {
        StringBuilder dynamicDescriptor = new StringBuilder("(");
        for (VariableDef variable : capturedVariables) {
            dynamicDescriptor.append(TypeUtils.getType(variable.type(), context.objectDef()));
        }
        dynamicDescriptor.append(")");
        dynamicDescriptor.append(TypeUtils.getType(this.lambda.type()).getDescriptor());
        return dynamicDescriptor.toString();
    }

    private MethodDef createLambdaMethodDef(MethodContext context, ExpressionDef.Lambda lambda, List<VariableDef> capturedVariables) {
        MethodDef original = lambda.implementation();
        ArrayList<ParameterDef> parameters = new ArrayList<ParameterDef>();
        for (VariableDef variable : capturedVariables) {
            if (variable instanceof VariableDef.Local) {
                VariableDef.Local local = (VariableDef.Local)variable;
                parameters.add(ParameterDef.builder((String)local.name(), (TypeDef)local.type()).build());
                continue;
            }
            if (variable instanceof VariableDef.MethodParameter) {
                VariableDef.MethodParameter parameter = (VariableDef.MethodParameter)variable;
                parameters.add(ParameterDef.builder((String)parameter.name(), (TypeDef)parameter.type()).build());
                continue;
            }
            if (variable instanceof VariableDef.Field) {
                VariableDef.Field field = (VariableDef.Field)variable;
                parameters.add(ParameterDef.builder((String)field.name(), (TypeDef)field.type()).build());
                continue;
            }
            if (variable instanceof VariableDef.This) {
                VariableDef.This thisVar = (VariableDef.This)variable;
                parameters.add(ParameterDef.builder((String)THIS_VAR_NAME, (TypeDef)thisVar.type()).build());
                continue;
            }
            if (variable instanceof VariableDef.Super) {
                VariableDef.Super superVar = (VariableDef.Super)variable;
                parameters.add(ParameterDef.builder((String)SUPER_VAR_NAME, (TypeDef)superVar.type()).build());
                continue;
            }
            if (!(variable instanceof VariableDef.ExceptionVar)) continue;
            VariableDef.ExceptionVar exception = (VariableDef.ExceptionVar)variable;
            parameters.add(ParameterDef.builder((String)EXCEPTION_VAR_NAME, (TypeDef)exception.type()).build());
        }
        parameters.addAll(original.getParameters());
        return ((MethodDef.MethodDefBuilder)MethodDef.builder((String)("lambda$" + context.methodDef().getName() + "$" + context.lambdaMethods().size())).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC})).addParameters(parameters).returns(original.getReturnType()).addStatements((Collection)original.getStatements()).build();
    }

    private List<VariableDef> captureVariables(MethodDef method) {
        LinkedHashSet<String> variables = new LinkedHashSet<String>(method.getParameters().stream().map(v -> v.getName()).toList());
        ArrayList<VariableDef> capturedVariables = new ArrayList<VariableDef>();
        for (StatementDef statement : method.getStatements()) {
            this.captureVariables(statement, variables, capturedVariables);
        }
        return capturedVariables;
    }

    private void captureVariables(StatementDef statement, Set<String> variables, List<VariableDef> capturedVariables) {
        statement.nestedExpressionsStream().forEach(expressionDef -> this.captureVariables((ExpressionDef)expressionDef, variables, capturedVariables));
    }

    private void captureVariables(ExpressionDef expression, Set<String> variables, List<VariableDef> capturedVariables) {
        if (expression instanceof VariableDef) {
            VariableDef variable = (VariableDef)expression;
            if (variable instanceof VariableDef.Local) {
                VariableDef.Local local = (VariableDef.Local)variable;
                if (!variables.contains(local.name())) {
                    capturedVariables.add((VariableDef)local);
                    variables.add(local.name());
                }
            } else if (variable instanceof VariableDef.MethodParameter) {
                VariableDef.MethodParameter parameter = (VariableDef.MethodParameter)variable;
                if (!variables.contains(parameter.name())) {
                    capturedVariables.add((VariableDef)parameter);
                    variables.add(parameter.name());
                }
            } else if (variable instanceof VariableDef.Field) {
                VariableDef.Field field = (VariableDef.Field)variable;
                this.captureVariables(field.instance(), variables, capturedVariables);
            } else if (variable instanceof VariableDef.This) {
                if (!variables.contains(THIS_VAR_NAME)) {
                    capturedVariables.add(variable);
                    variables.add(THIS_VAR_NAME);
                }
            } else if (variable instanceof VariableDef.Super) {
                if (!variables.contains(SUPER_VAR_NAME)) {
                    capturedVariables.add(variable);
                    variables.add(SUPER_VAR_NAME);
                }
            } else if (variable instanceof VariableDef.ExceptionVar && !variables.contains(EXCEPTION_VAR_NAME)) {
                capturedVariables.add(variable);
                variables.add(EXCEPTION_VAR_NAME);
            }
        } else {
            expression.nestedExpressionsStream().forEach(expressionDef -> this.captureVariables((ExpressionDef)expressionDef, variables, capturedVariables));
        }
    }
}

