/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.sourcegen.bytecode.EnumGenUtils;
import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.SignatureWriterUtils;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.statement.StatementWriter;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.EnumDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.RecordDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.util.CheckClassAdapter;

public final class ByteCodeWriter {
    private final boolean checkClass;
    private final boolean visitMaxs;

    public ByteCodeWriter() {
        this(false, true);
    }

    public ByteCodeWriter(boolean checkClass, boolean visitMaxs) {
        this.checkClass = checkClass;
        this.visitMaxs = visitMaxs;
    }

    private ClassWriter createClassWriterAndWriteObject(ObjectDef objectDef, @Nullable ClassTypeDef outerType) {
        ClassWriter classWriter;
        ClassWriter classVisitor = classWriter = new ClassWriter(3);
        if (this.checkClass) {
            classVisitor = new CheckClassAdapter((ClassVisitor)classVisitor);
        }
        this.writeObject((ClassVisitor)classVisitor, objectDef, outerType);
        classVisitor.visitEnd();
        return classWriter;
    }

    public void writeObject(ClassVisitor classVisitor, ObjectDef objectDef) {
        this.writeObject(classVisitor, objectDef, null);
    }

    public void writeObject(ClassVisitor classVisitor, ObjectDef objectDef, @Nullable ClassTypeDef outerType) {
        if (objectDef instanceof ClassDef) {
            ClassDef classDef = (ClassDef)objectDef;
            this.writeClass(classVisitor, classDef, outerType);
        } else if (objectDef instanceof RecordDef) {
            RecordDef recordDef = (RecordDef)objectDef;
            this.writeRecord(classVisitor, recordDef, outerType);
        } else if (objectDef instanceof InterfaceDef) {
            InterfaceDef interfaceDef = (InterfaceDef)objectDef;
            this.writeInterface(classVisitor, interfaceDef, outerType);
        } else if (objectDef instanceof EnumDef) {
            EnumDef enumDef = (EnumDef)objectDef;
            this.writeClass(classVisitor, EnumGenUtils.toClassDef(enumDef), outerType);
        } else {
            throw new UnsupportedOperationException("Unknown object definition: " + objectDef);
        }
    }

    private MethodDef createStaticInitializer(StatementDef statement) {
        return ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"<clinit>").returns((TypeDef)TypeDef.VOID).addModifiers(new Modifier[]{Modifier.STATIC})).addStatement(statement).build();
    }

    public void writeField(ClassVisitor classVisitor, ObjectDef objectDef, FieldDef fieldDef) {
        int modifiersFlag = this.getModifiersFlag(fieldDef.getModifiers());
        if (fieldDef.isSynthetic()) {
            modifiersFlag |= 0x1000;
        }
        if (EnumGenUtils.isEnumField(objectDef, fieldDef)) {
            modifiersFlag |= 0x4000;
        }
        FieldVisitor fieldVisitor = classVisitor.visitField(modifiersFlag, fieldDef.getName(), TypeUtils.getType(fieldDef.getType(), objectDef).getDescriptor(), SignatureWriterUtils.getFieldSignature(objectDef, fieldDef), null);
        for (AnnotationDef annotation : fieldDef.getAnnotations()) {
            AnnotationVisitor annotationVisitor = fieldVisitor.visitAnnotation(TypeUtils.getType((TypeDef)annotation.getType(), null).getDescriptor(), true);
            this.visitAnnotation(annotation, annotationVisitor);
        }
        fieldVisitor.visitEnd();
    }

    public void writeInterface(ClassVisitor classVisitor, InterfaceDef interfaceDef, @Nullable ClassTypeDef outerType) {
        int modifiersFlag = 0x600 | this.getModifiersFlag(interfaceDef.getModifiers());
        if (interfaceDef.isSynthetic()) {
            modifiersFlag |= 0x1000;
        }
        classVisitor.visit(61, modifiersFlag, TypeUtils.getType(interfaceDef.asTypeDef()).getInternalName(), SignatureWriterUtils.getInterfaceSignature(interfaceDef), TypeUtils.OBJECT_TYPE.getInternalName(), (String[])interfaceDef.getSuperinterfaces().stream().map(i -> TypeUtils.getType(i, (ObjectDef)interfaceDef)).map(Type::getInternalName).toArray(String[]::new));
        this.writeOuterInner(classVisitor, interfaceDef.asTypeDef(), (ObjectDef)interfaceDef, outerType);
        for (AnnotationDef annotation : interfaceDef.getAnnotations()) {
            AnnotationVisitor annotationVisitor = classVisitor.visitAnnotation(TypeUtils.getType((TypeDef)annotation.getType(), null).getDescriptor(), true);
            this.visitAnnotation(annotation, annotationVisitor);
        }
        for (MethodDef method : interfaceDef.getMethods()) {
            this.writeMethod(classVisitor, (ObjectDef)interfaceDef, method);
        }
        for (PropertyDef property : interfaceDef.getProperties()) {
            this.writeProperty(classVisitor, (ObjectDef)interfaceDef, property);
        }
    }

    public void writeRecord(ClassVisitor classVisitor, RecordDef recordDef) {
        this.writeRecord(classVisitor, recordDef, null);
    }

    public void writeRecord(ClassVisitor classVisitor, RecordDef recordDef, @Nullable ClassTypeDef outerType) {
        int modifiersFlag = 0x10000 | this.getModifiersFlag(recordDef.getModifiers());
        if (recordDef.isSynthetic()) {
            modifiersFlag |= 0x1000;
        }
        classVisitor.visit(61, modifiersFlag, TypeUtils.getType(recordDef.asTypeDef()).getInternalName(), SignatureWriterUtils.getRecordSignature(recordDef), Type.getType(Record.class).getInternalName(), (String[])recordDef.getSuperinterfaces().stream().map(i -> TypeUtils.getType(i, (ObjectDef)recordDef)).map(Type::getInternalName).toArray(String[]::new));
        this.writeOuterInner(classVisitor, recordDef.asTypeDef(), (ObjectDef)recordDef, outerType);
    }

    public void writeClass(ClassVisitor classVisitor, ClassDef classDef) {
        this.writeClass(classVisitor, classDef, null);
    }

    public void writeClass(ClassVisitor classVisitor, ClassDef classDef, @Nullable ClassTypeDef outerType) {
        ClassTypeDef typeDef = classDef.asTypeDef();
        int modifiersFlag = this.getModifiersFlag(classDef.getModifiers());
        if (classDef.isSynthetic()) {
            modifiersFlag |= 0x1000;
        }
        if (EnumGenUtils.isEnum(classDef)) {
            modifiersFlag |= 0x4000;
        }
        classVisitor.visit(61, modifiersFlag, TypeUtils.getType(classDef.asTypeDef()).getInternalName(), SignatureWriterUtils.getClassSignature(classDef), TypeUtils.getType((TypeDef)Objects.requireNonNullElse(classDef.getSuperclass(), TypeDef.OBJECT), null).getInternalName(), (String[])classDef.getSuperinterfaces().stream().map(i -> TypeUtils.getType(i, (ObjectDef)classDef)).map(Type::getInternalName).toArray(String[]::new));
        this.writeOuterInner(classVisitor, classDef.asTypeDef(), (ObjectDef)classDef, outerType);
        for (Object annotation : classDef.getAnnotations()) {
            AnnotationVisitor annotationVisitor = classVisitor.visitAnnotation(TypeUtils.getType((TypeDef)annotation.getType(), null).getDescriptor(), true);
            this.visitAnnotation((AnnotationDef)annotation, annotationVisitor);
        }
        ArrayList<StatementDef> staticInitStatements = new ArrayList<StatementDef>();
        for (FieldDef field : classDef.getFields()) {
            this.writeField(classVisitor, (ObjectDef)classDef, field);
            field.getInitializer().ifPresent(expressionDef -> {
                if (field.getModifiers().contains((Object)Modifier.STATIC)) {
                    staticInitStatements.add((StatementDef)typeDef.getStaticField(field).put(expressionDef));
                }
            });
        }
        StatementDef staticInitializer = classDef.getStaticInitializer();
        if (staticInitializer != null) {
            staticInitStatements.add(staticInitializer);
        }
        if (!staticInitStatements.isEmpty()) {
            this.writeMethod(classVisitor, (ObjectDef)classDef, this.createStaticInitializer(StatementDef.multi(staticInitStatements)));
        }
        if (classDef.getMethods().stream().noneMatch(MethodDef::isConstructor)) {
            MethodDef.MethodDefBuilder defaultConstructor = MethodDef.constructor();
            if (classDef.getModifiers().contains((Object)Modifier.PUBLIC)) {
                defaultConstructor.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            this.writeMethod(classVisitor, (ObjectDef)classDef, defaultConstructor.build((aThis, methodParameters) -> aThis.superRef().invokeConstructor(methodParameters)));
        }
        for (PropertyDef property : classDef.getProperties()) {
            this.writeProperty(classVisitor, (ObjectDef)classDef, property);
        }
        for (MethodDef method : classDef.getMethods()) {
            this.writeMethod(classVisitor, (ObjectDef)classDef, method);
        }
    }

    private void writeOuterInner(ClassVisitor classVisitor, ClassTypeDef thisType, ObjectDef thisDef, @Nullable ClassTypeDef outerType) {
        if (outerType != null) {
            String outerInternalName = TypeUtils.getType(outerType).getInternalName();
            classVisitor.visitNestHost(outerInternalName);
            classVisitor.visitInnerClass(TypeUtils.getType(thisType).getInternalName(), outerInternalName, thisType.getSimpleName(), this.getModifiersFlag(thisDef));
        }
        this.writeInnerTypes(classVisitor, thisType, thisDef.getInnerTypes());
    }

    private void writeInnerTypes(ClassVisitor outerClassVisitor, ClassTypeDef outerType, List<ObjectDef> innerTypes) {
        for (ObjectDef innerDef : innerTypes) {
            String outerClassInternalName = TypeUtils.getType(outerType).getInternalName();
            ClassTypeDef interType = innerDef.asTypeDef();
            int access = this.getModifiersFlag(innerDef);
            outerClassVisitor.visitInnerClass(TypeUtils.getType(innerDef.asTypeDef()).getInternalName(), outerClassInternalName, interType.getSimpleName(), access |= 9);
            outerClassVisitor.visitNestMember(TypeUtils.getType(innerDef.asTypeDef()).getInternalName());
        }
    }

    private int getModifiersFlag(ObjectDef objectDef) {
        if (objectDef instanceof EnumDef) {
            EnumDef enumDef = (EnumDef)objectDef;
            return 0x4000 | this.getModifiersFlag((ObjectDef)EnumGenUtils.toClassDef(enumDef));
        }
        if (objectDef instanceof InterfaceDef) {
            InterfaceDef interfaceDef = (InterfaceDef)objectDef;
            return 0x600 | this.getModifiersFlag(interfaceDef.getModifiers());
        }
        if (objectDef instanceof RecordDef) {
            RecordDef recordDef = (RecordDef)objectDef;
            return this.getModifiersFlag(recordDef.getModifiers());
        }
        return this.getModifiersFlag(objectDef.getModifiers());
    }

    private void visitAnnotation(AnnotationDef annotation, AnnotationVisitor annotationVisitor) {
        for (Map.Entry entry : annotation.getValues().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.visitAnnotation(annotationVisitor, key, value);
        }
        annotationVisitor.visitEnd();
    }

    private void visitAnnotation(AnnotationVisitor annotationVisitor, String name, Object value) {
        if (value instanceof VariableDef.StaticField) {
            VariableDef.StaticField staticField = (VariableDef.StaticField)value;
            annotationVisitor.visitEnum(name, TypeUtils.getType((TypeDef)staticField.ownerType(), null).getDescriptor(), staticField.name());
        } else if (value instanceof AnnotationDef) {
            AnnotationDef nestedAnnotation = (AnnotationDef)value;
            this.visitAnnotation(nestedAnnotation, annotationVisitor.visitAnnotation(name, TypeUtils.getType((TypeDef)nestedAnnotation.getType(), null).getDescriptor()));
        } else if (value instanceof AnnotationDef[]) {
            AnnotationDef[] annotations = (AnnotationDef[])value;
            AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
            for (AnnotationDef annotationDef : annotations) {
                this.visitAnnotation(annotationDef, annotationVisitor.visitAnnotation(name, TypeUtils.getType((TypeDef)annotationDef.getType(), null).getDescriptor()));
            }
            arrayVisitor.visitEnd();
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
            for (Object object : coll) {
                this.visitAnnotation(arrayVisitor, name, object);
            }
            arrayVisitor.visitEnd();
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
            for (Object object : array) {
                this.visitAnnotation(arrayVisitor, name, object);
            }
            arrayVisitor.visitEnd();
        } else {
            annotationVisitor.visit(name, value);
        }
    }

    private void writeProperty(ClassVisitor classWriter, ObjectDef objectDef, PropertyDef property) {
        FieldDef propertyField = ((FieldDef.FieldDefBuilder)((FieldDef.FieldDefBuilder)FieldDef.builder((String)property.getName(), (TypeDef)property.getType()).addModifiers(new Modifier[]{Modifier.PRIVATE})).addAnnotations(property.getAnnotations())).build();
        this.writeField(classWriter, objectDef, propertyField);
        String capitalizedPropertyName = NameUtils.capitalize((String)property.getName());
        boolean isAbstract = objectDef instanceof InterfaceDef;
        MethodDef.MethodDefBuilder getterBuilder = (MethodDef.MethodDefBuilder)MethodDef.builder((String)("get" + capitalizedPropertyName)).addModifiers(property.getModifiersArray());
        if (!isAbstract) {
            getterBuilder.addStatement((aThis, methodParameters) -> aThis.field(propertyField).returning());
        }
        this.writeMethod(classWriter, objectDef, getterBuilder.build());
        MethodDef.MethodDefBuilder setterBuilder = (MethodDef.MethodDefBuilder)MethodDef.builder((String)("set" + capitalizedPropertyName)).addParameter(ParameterDef.of((String)property.getName(), (TypeDef)property.getType())).addModifiers(property.getModifiersArray());
        if (!isAbstract) {
            setterBuilder.addStatement((aThis, methodParameters) -> aThis.field(propertyField).assign((ExpressionDef)methodParameters.get(0)));
        }
        this.writeMethod(classWriter, objectDef, setterBuilder.build());
    }

    private void writeMethod(ClassVisitor classVisitor, @Nullable ObjectDef objectDef, MethodDef methodDef) {
        this.writeMethod(classVisitor, objectDef, methodDef, false);
    }

    private void writeMethod(ClassVisitor classVisitor, @Nullable ObjectDef objectDef, MethodDef methodDef, boolean isLambda) {
        String name = methodDef.getName();
        String methodDescriptor = TypeUtils.getMethodDescriptor(objectDef, methodDef);
        int modifiersFlag = this.getModifiersFlag(methodDef.getModifiers());
        if (methodDef.isSynthetic()) {
            modifiersFlag |= 0x1000;
        }
        String[] exceptions = null;
        if (!methodDef.getThrowTypes().isEmpty()) {
            exceptions = (String[])methodDef.getThrowTypes().stream().map(t -> TypeUtils.getType(t, objectDef).getClassName().replace(".", "/")).toArray(String[]::new);
        }
        MethodVisitor methodVisitor = classVisitor.visitMethod(modifiersFlag, name, methodDescriptor, SignatureWriterUtils.getMethodSignature(objectDef, methodDef), exceptions);
        GeneratorAdapter generatorAdapter = new GeneratorAdapter(methodVisitor, modifiersFlag, name, methodDescriptor);
        for (AnnotationDef annotation : methodDef.getAnnotations()) {
            generatorAdapter.visitAnnotation(TypeUtils.getType((TypeDef)annotation.getType(), null).getDescriptor(), true);
        }
        if (methodDef.getParameters().stream().anyMatch(p -> !p.getAnnotations().isEmpty())) {
            generatorAdapter.visitAnnotableParameterCount(methodDef.getParameters().size(), true);
        }
        MethodContext context = new MethodContext(objectDef, methodDef, isLambda);
        Label startMethod = null;
        int parameterIndex = 0;
        for (Object parameter : methodDef.getParameters()) {
            if (startMethod == null) {
                startMethod = new Label();
            }
            for (AnnotationDef annotation : parameter.getAnnotations()) {
                AnnotationVisitor annotationVisitor = generatorAdapter.visitParameterAnnotation(parameterIndex, TypeUtils.getType((TypeDef)annotation.getType(), null).getDescriptor(), true);
                this.visitAnnotation(annotation, annotationVisitor);
            }
            MethodContext.LocalData prevParam = context.locals().put(parameter.getName(), new MethodContext.LocalData(parameter.getName(), TypeUtils.getType(parameter.getType(), objectDef), startMethod, parameterIndex + 1));
            if (prevParam != null) {
                throw new IllegalStateException("Duplicate method parameter: " + parameter.getName() + " of method: " + methodDef.getName() + " " + (objectDef == null ? "" : objectDef.getName()));
            }
            ++parameterIndex;
        }
        List<StatementDef> statements = methodDef.getStatements();
        if (methodDef.isConstructor()) {
            statements = this.adjustConstructorStatements(objectDef, statements);
        }
        if (!statements.isEmpty()) {
            generatorAdapter.visitCode();
            if (startMethod != null) {
                generatorAdapter.visitLabel(startMethod);
            }
            for (StatementDef statement : statements) {
                StatementWriter.of(statement).write(generatorAdapter, context, null);
            }
            StatementDef statementDef = statements.get(statements.size() - 1);
            if (!this.hasReturnStatement(statementDef)) {
                if (methodDef.getReturnType().equals(TypeDef.VOID)) {
                    generatorAdapter.returnValue();
                } else {
                    throw new IllegalStateException("The method: " + (objectDef == null ? "" : objectDef.getName()) + " " + methodDef.getName() + " doesn't return the result!");
                }
            }
        }
        Label endMethod = new Label();
        if (!context.locals().isEmpty()) {
            generatorAdapter.visitLabel(endMethod);
        }
        for (MethodContext.LocalData localsDatum : context.locals().values()) {
            methodVisitor.visitLocalVariable(localsDatum.name(), localsDatum.type().getDescriptor(), null, localsDatum.start(), endMethod, localsDatum.index());
        }
        if (this.visitMaxs && !statements.isEmpty()) {
            generatorAdapter.visitMaxs(20, 20);
        }
        generatorAdapter.visitEnd();
        for (MethodDef lambdaDef : context.lambdaMethods()) {
            this.writeMethod(classVisitor, objectDef, lambdaDef, true);
        }
    }

    private List<StatementDef> adjustConstructorStatements(ObjectDef objectDef, List<StatementDef> statements) {
        if (!(objectDef instanceof ClassDef)) {
            return statements;
        }
        ClassDef classDef = (ClassDef)objectDef;
        List fieldInitializers = classDef.getFields().stream().filter(fieldDef -> !fieldDef.getModifiers().contains((Object)Modifier.STATIC)).flatMap(fieldDef -> fieldDef.getInitializer().map(initializer -> new VariableDef.This().field(fieldDef).assign(initializer)).stream()).toList();
        Optional<StatementDef> constructorInvocation = statements.stream().filter(this::isConstructorInvocation).findFirst();
        if (constructorInvocation.isEmpty() || !fieldInitializers.isEmpty()) {
            ArrayList<StatementDef> newStatements = new ArrayList<StatementDef>();
            newStatements.add(constructorInvocation.orElseGet(this::superConstructorInvocation));
            newStatements.addAll(fieldInitializers);
            if (constructorInvocation.isPresent()) {
                ArrayList<StatementDef> statementsWithoutConstructor = new ArrayList<StatementDef>(statements);
                statementsWithoutConstructor.remove(constructorInvocation.get());
                newStatements.addAll(statementsWithoutConstructor);
            } else {
                newStatements.addAll(statements);
            }
            statements = newStatements;
        }
        return statements;
    }

    private boolean hasReturnStatement(StatementDef statement) {
        List statements = statement.flatten();
        if (statements.isEmpty()) {
            return false;
        }
        StatementDef statementDef = (StatementDef)statements.get(statements.size() - 1);
        if (statementDef instanceof StatementDef.IfElse) {
            StatementDef.IfElse ifElse = (StatementDef.IfElse)statementDef;
            return this.hasReturnStatement(ifElse.statement()) && this.hasReturnStatement(ifElse.elseStatement());
        }
        if (statementDef instanceof StatementDef.Try) {
            StatementDef.Try aTry = (StatementDef.Try)statementDef;
            return this.hasReturnStatement(aTry.statement());
        }
        if (statementDef instanceof StatementDef.Synchronized) {
            StatementDef.Synchronized aSynchronized = (StatementDef.Synchronized)statementDef;
            return this.hasReturnStatement(aSynchronized.statement());
        }
        if (statementDef instanceof StatementDef.Switch) {
            StatementDef.Switch switchStatement = (StatementDef.Switch)statementDef;
            if (switchStatement.defaultCase() == null) {
                return false;
            }
            return switchStatement.cases().values().stream().allMatch(this::hasReturnStatement);
        }
        return statementDef instanceof StatementDef.Return || statementDef instanceof StatementDef.Throw;
    }

    private StatementDef superConstructorInvocation() {
        return new VariableDef.This().superRef().invokeConstructor(new ExpressionDef[0]);
    }

    private boolean isConstructorInvocation(StatementDef statement) {
        ExpressionDef.InvokeInstanceMethod call;
        return statement instanceof ExpressionDef.InvokeInstanceMethod && (call = (ExpressionDef.InvokeInstanceMethod)statement).method().isConstructor();
    }

    private int getModifiersFlag(Set<Modifier> modifiers) {
        int access = 0;
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            access |= 1;
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            access |= 2;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            access |= 4;
        }
        if (modifiers.contains((Object)Modifier.FINAL)) {
            access |= 0x10;
        }
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            access |= 0x400;
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            access |= 8;
        }
        return access;
    }

    public byte[] write(ObjectDef objectDef) {
        return this.write(objectDef, null);
    }

    public byte[] write(ObjectDef objectDef, @Nullable ClassTypeDef outerType) {
        return this.createClassWriterAndWriteObject(objectDef, outerType).toByteArray();
    }
}

