/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.processor.jackson.ValidatingAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JsonTypeInfoMapper
extends ValidatingAnnotationMapper {
    public String getName() {
        return "com.fasterxml.jackson.annotation.JsonTypeInfo";
    }

    @Override
    protected Set<String> getSupportedMemberNames() {
        return CollectionUtils.setOf((Object[])new String[]{"defaultImpl", "property", "include", "use"});
    }

    @Override
    protected List<AnnotationValue<?>> mapValid(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        String use = annotation.stringValue("use").orElse(null);
        String include = annotation.stringValue("include").orElse("PROPERTY");
        AnnotationClassValue defaultImpl = annotation.annotationClassValue("defaultImpl").orElse(null);
        ArrayList values = new ArrayList(2);
        if (use == null) {
            return this.mapError("You must specify 'use' member when using @JsonTypeInfo");
        }
        if (defaultImpl != null) {
            values.add(AnnotationValue.builder(DefaultImplementation.class).member("value", new AnnotationClassValue[]{defaultImpl}).build());
        }
        String property = annotation.stringValue("property").orElse(null);
        AnnotationValueBuilder builder = AnnotationValue.builder(SerdeConfig.SerSubtyped.class);
        if (!"PROPERTY".equals(include) && !"WRAPPER_OBJECT".equals(include)) {
            return this.mapError("Only 'include' of type PROPERTY or WRAPPER_OBJECT are supported");
        }
        builder.member("dt", include);
        if (!"CLASS".equals(use) && !"NAME".equals(use)) {
            return this.mapError("Unsupported JsonTypeInfo use: " + use);
        }
        builder.member("dv", use);
        property = property != null ? property : (use.equals("CLASS") ? "@class" : "@type");
        builder.member("dp", property);
        values.add(builder.build());
        return values;
    }

    private List<AnnotationValue<?>> mapError(String message) {
        return Collections.singletonList(AnnotationValue.builder(SerdeConfig.SerError.class).value(message).build());
    }
}

