/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.annotation.AnnotationMapper;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.annotation.TypedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JacksonAnnotationMapper
implements NamedAnnotationMapper {
    static final Map<String, List<AnnotationMapper<?>>> JACKSON_ANNOTATION_MAPPERS = new HashMap(10);

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        return Collections.singletonList(AnnotationValue.builder(SerdeConfig.class).build());
    }

    public String getName() {
        return "com.fasterxml.jackson.annotation.JacksonAnnotation";
    }

    static {
        SoftServiceLoader serviceLoader = SoftServiceLoader.load(AnnotationMapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader());
        for (ServiceDefinition definition : serviceLoader) {
            if (!definition.isPresent() || !definition.getName().startsWith("io.micronaut.serde.processor.jackson.")) continue;
            AnnotationMapper mapper = (AnnotationMapper)definition.load();
            try {
                String name = null;
                if (mapper instanceof TypedAnnotationMapper) {
                    name = ((TypedAnnotationMapper)mapper).annotationType().getName();
                } else if (mapper instanceof NamedAnnotationMapper) {
                    name = ((NamedAnnotationMapper)mapper).getName();
                }
                if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
                JACKSON_ANNOTATION_MAPPERS.computeIfAbsent(name, s -> new ArrayList(2)).add(mapper);
            }
            catch (Throwable throwable) {}
        }
    }
}

