/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.session;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.handlers.LogoutHandler;
import io.micronaut.security.session.SecuritySessionConfiguration;
import io.micronaut.security.session.SessionAuthenticationModeCondition;
import io.micronaut.session.Session;
import io.micronaut.session.http.HttpSessionFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Requires(condition=SessionAuthenticationModeCondition.class)
@Singleton
public class SessionLogoutHandler
implements LogoutHandler {
    protected final String logout;

    @Deprecated
    public SessionLogoutHandler(SecuritySessionConfiguration securitySessionConfiguration) {
        this.logout = securitySessionConfiguration.getLogoutTargetUrl();
    }

    @Inject
    public SessionLogoutHandler(RedirectConfiguration redirectConfiguration) {
        this.logout = redirectConfiguration.getLogout();
    }

    public MutableHttpResponse<?> logout(HttpRequest<?> request) {
        MutableConvertibleValues attrs = request.getAttributes();
        Optional existing = attrs.get(HttpSessionFilter.SESSION_ATTRIBUTE, Session.class);
        if (existing.isPresent()) {
            Session session = (Session)existing.get();
            session.remove(SecurityFilter.AUTHENTICATION);
        }
        try {
            URI location = new URI(this.logout);
            return HttpResponse.seeOther((URI)location);
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }
}

