/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.io.watch.event;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.event.ApplicationEvent;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.scheduling.io.watch.event.WatchEventType;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileChangedEvent
extends ApplicationEvent {
    private final Path path;
    private final WatchEventType eventType;

    public FileChangedEvent(@NonNull Path path, @NonNull WatchEventType eventType) {
        super((Object)path);
        ArgumentUtils.requireNonNull((String)"path", (Object)path);
        ArgumentUtils.requireNonNull((String)"eventType", (Object)((Object)eventType));
        this.path = path;
        this.eventType = eventType;
    }

    public FileChangedEvent(@NonNull Path path, @NonNull WatchEvent.Kind eventType) {
        this(path, WatchEventType.of(eventType));
    }

    @NonNull
    public Path getSource() {
        return (Path)super.getSource();
    }

    @NonNull
    public Path getPath() {
        return this.path;
    }

    @NonNull
    public WatchEventType getEventType() {
        return this.eventType;
    }
}

