/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.env.Environment;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceIdGenerator;
import io.micronaut.runtime.server.EmbeddedServerInstance;
import java.util.Optional;
import java.util.StringJoiner;
import javax.inject.Singleton;

@Singleton
public class DefaultServiceInstanceIdGenerator
implements ServiceInstanceIdGenerator {
    protected DefaultServiceInstanceIdGenerator() {
    }

    @Override
    @NonNull
    public String generateId(Environment environment, ServiceInstance serviceInstance) {
        Optional cloudFoundryId = environment.getProperty("vcap.application.instance_id", String.class);
        if (cloudFoundryId.isPresent()) {
            return (String)cloudFoundryId.get();
        }
        StringJoiner joiner = new StringJoiner(":");
        String applicationName = serviceInstance.getId();
        joiner.add(applicationName);
        if (serviceInstance instanceof EmbeddedServerInstance) {
            EmbeddedServerInstance esi = (EmbeddedServerInstance)serviceInstance;
            Optional<String> id = esi.getEmbeddedServer().getApplicationConfiguration().getInstance().getId();
            if (id.isPresent()) {
                joiner.add(id.get());
            } else {
                joiner.add(String.valueOf(esi.getPort()));
            }
        } else {
            joiner.add(String.valueOf(serviceInstance.getPort()));
        }
        return joiner.toString();
    }
}

