/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class MultipleInvocationInstrumenter
implements InvocationInstrumenter {
    private static final Logger LOG = LoggerFactory.getLogger(InvocationInstrumenter.class);
    private final Collection<InvocationInstrumenter> invocationInstrumenters;

    MultipleInvocationInstrumenter(Collection<InvocationInstrumenter> invocationInstrumenters) {
        this.invocationInstrumenters = invocationInstrumenters;
    }

    @Override
    @NonNull
    public Instrumentation newInstrumentation() {
        ArrayList<Instrumentation> instrumentationList = new ArrayList<Instrumentation>(this.invocationInstrumenters.size());
        for (InvocationInstrumenter instrumenter : this.invocationInstrumenters) {
            try {
                instrumentationList.add(instrumenter.newInstrumentation());
            }
            catch (Exception e) {
                LOG.warn("InvocationInstrumenter.newInstrumentation invocation error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return cleanup -> {
            ListIterator iterator = instrumentationList.listIterator(instrumentationList.size());
            while (iterator.hasPrevious()) {
                try {
                    ((Instrumentation)iterator.previous()).close(cleanup);
                }
                catch (Exception e) {
                    LOG.warn("Instrumentation.close invocation error: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        };
    }
}

