/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.PostponeToNextRoundException;
import io.micronaut.annotation.processing.visitor.JavaAnnotationElement;
import io.micronaut.annotation.processing.visitor.JavaBeanDefinitionBuilder;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaConstructorElement;
import io.micronaut.annotation.processing.visitor.JavaEnumConstantElement;
import io.micronaut.annotation.processing.visitor.JavaEnumElement;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementFactory;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@Internal
public class JavaElementFactory
implements ElementFactory<javax.lang.model.element.Element, TypeElement, ExecutableElement, VariableElement> {
    private final JavaVisitorContext visitorContext;

    public JavaElementFactory(JavaVisitorContext visitorContext) {
        this.visitorContext = Objects.requireNonNull(visitorContext, "Visitor context cannot be null");
    }

    @NonNull
    public JavaClassElement newClassElement(@NonNull TypeElement type, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        ElementKind kind = type.getKind();
        return switch (kind) {
            case ElementKind.ENUM -> new JavaEnumElement(new JavaNativeElement.Class(type), annotationMetadataFactory, this.visitorContext);
            case ElementKind.ANNOTATION_TYPE -> new JavaAnnotationElement(new JavaNativeElement.Class(type), annotationMetadataFactory, this.visitorContext);
            default -> new JavaClassElement(new JavaNativeElement.Class(type), annotationMetadataFactory, this.visitorContext);
        };
    }

    @NonNull
    public ClassElement newClassElement(@NonNull TypeElement type, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory, @NonNull Map<String, ClassElement> resolvedGenerics) {
        if (resolvedGenerics.isEmpty()) {
            return this.newClassElement(type, annotationMetadataFactory);
        }
        return this.newClassElement(type, annotationMetadataFactory).withTypeArguments(resolvedGenerics);
    }

    @NonNull
    public JavaClassElement newSourceClassElement(@NonNull TypeElement type, final @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        ElementKind kind = type.getKind();
        if (kind == ElementKind.ENUM) {
            return new JavaEnumElement(new JavaNativeElement.Class(type), annotationMetadataFactory, this.visitorContext){

                @NonNull
                public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                    return new JavaBeanDefinitionBuilder((Element)this, type, ConfigurationMetadataBuilder.INSTANCE, annotationMetadataFactory, this.visitorContext);
                }
            };
        }
        return new JavaClassElement(new JavaNativeElement.Class(type), annotationMetadataFactory, this.visitorContext){

            @NonNull
            public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                return new JavaBeanDefinitionBuilder((Element)this, type, ConfigurationMetadataBuilder.INSTANCE, annotationMetadataFactory, this.visitorContext);
            }
        };
    }

    @NonNull
    public JavaMethodElement newSourceMethodElement(@NonNull ClassElement declaringClass, @NonNull ExecutableElement method, final @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        JavaElementFactory.validateOwningClass(declaringClass);
        this.failIfPostponeIsNeeded((TypedElement)declaringClass, method);
        return new JavaMethodElement((JavaClassElement)declaringClass, new JavaNativeElement.Method(method), annotationMetadataFactory, this.visitorContext){

            @NonNull
            public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                return new JavaBeanDefinitionBuilder((Element)this, type, ConfigurationMetadataBuilder.INSTANCE, annotationMetadataFactory, this.visitorContext);
            }
        };
    }

    @NonNull
    public JavaMethodElement newMethodElement(@NonNull ClassElement owningType, @NonNull ExecutableElement method, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        JavaElementFactory.validateOwningClass(owningType);
        this.failIfPostponeIsNeeded((TypedElement)owningType, method);
        return new JavaMethodElement((JavaClassElement)owningType, new JavaNativeElement.Method(method), annotationMetadataFactory, this.visitorContext);
    }

    @NonNull
    public JavaConstructorElement newConstructorElement(@NonNull ClassElement owningType, @NonNull ExecutableElement constructor, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        JavaElementFactory.validateOwningClass(owningType);
        this.failIfPostponeIsNeeded((TypedElement)owningType, constructor);
        return new JavaConstructorElement((JavaClassElement)owningType, new JavaNativeElement.Method(constructor), annotationMetadataFactory, this.visitorContext);
    }

    @NonNull
    public JavaEnumConstantElement newEnumConstantElement(@NonNull ClassElement owningType, @NonNull VariableElement enumConstant, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        if (!(owningType instanceof JavaEnumElement)) {
            throw new IllegalArgumentException("Declaring class must be a JavaEnumElement");
        }
        this.failIfPostponeIsNeeded((TypedElement)owningType, enumConstant);
        return new JavaEnumConstantElement((JavaEnumElement)owningType, new JavaNativeElement.Variable(enumConstant), annotationMetadataFactory, this.visitorContext);
    }

    @NonNull
    public JavaFieldElement newFieldElement(@NonNull ClassElement owningType, @NonNull VariableElement field, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory) {
        this.failIfPostponeIsNeeded((TypedElement)owningType, field);
        return new JavaFieldElement((JavaClassElement)owningType, new JavaNativeElement.Variable(field), annotationMetadataFactory, this.visitorContext);
    }

    private void failIfPostponeIsNeeded(TypedElement member, ExecutableElement executableElement) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        for (VariableElement variableElement : parameters) {
            this.failIfPostponeIsNeeded(member, variableElement);
        }
        TypeMirror returnType = executableElement.getReturnType();
        TypeKind typeKind = returnType.getKind();
        if (typeKind == TypeKind.ERROR) {
            throw new PostponeToNextRoundException(member, member.getName() + " " + String.valueOf(executableElement));
        }
    }

    private void failIfPostponeIsNeeded(TypedElement member, VariableElement variableElement) {
        TypeMirror type = variableElement.asType();
        if (type.getKind() == TypeKind.ERROR) {
            throw new PostponeToNextRoundException(member, member.getName() + " " + String.valueOf(variableElement));
        }
    }

    private static void validateOwningClass(ClassElement owningClass) {
        if (!(owningClass instanceof JavaClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a JavaClassElement");
        }
    }
}

