/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.AbstractJavaMemberElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.PropertyElementAnnotationMetadata;
import java.util.Optional;

@Internal
final class JavaPropertyElement
extends AbstractJavaMemberElement
implements PropertyElement {
    private final ClassElement type;
    private final String name;
    private final PropertyElement.AccessKind readAccessKind;
    private final PropertyElement.AccessKind writeAccessKind;
    private final ClassElement owningElement;
    @Nullable
    private final MethodElement getter;
    @Nullable
    private final MethodElement setter;
    @Nullable
    private final FieldElement field;
    private final boolean excluded;
    private final PropertyElementAnnotationMetadata annotationMetadata;
    @Nullable
    private final String doc;

    JavaPropertyElement(ClassElement owningElement, ClassElement type, @Nullable MethodElement getter, @Nullable MethodElement setter, @Nullable FieldElement field, ElementAnnotationMetadataFactory annotationMetadataFactory, String name, PropertyElement.AccessKind readAccessKind, PropertyElement.AccessKind writeAccessKind, boolean excluded, JavaVisitorContext visitorContext, @Nullable String doc) {
        super(JavaPropertyElement.selectNativeType(getter, setter, field), annotationMetadataFactory, visitorContext);
        this.type = type;
        this.getter = getter;
        this.setter = setter;
        this.field = field;
        this.name = name;
        this.readAccessKind = readAccessKind;
        this.writeAccessKind = writeAccessKind;
        this.owningElement = owningElement;
        this.excluded = excluded;
        this.annotationMetadata = new PropertyElementAnnotationMetadata((Element)this, getter, setter, field, null, false);
        this.doc = doc;
    }

    @Override
    protected AnnotationMetadata getTypeAnnotationMetadata() {
        return this.type.getTypeAnnotationMetadata();
    }

    public Optional<AnnotationMetadata> getReadTypeAnnotationMetadata() {
        return Optional.of(this.annotationMetadata.getReadAnnotationMetadata());
    }

    public Optional<AnnotationMetadata> getWriteTypeAnnotationMetadata() {
        return Optional.of(this.annotationMetadata.getWriteAnnotationMetadata());
    }

    @Override
    protected AbstractJavaElement copyThis() {
        return new JavaPropertyElement(this.owningElement, this.type, this.getter, this.setter, this.field, this.elementAnnotationMetadataFactory, this.name, this.readAccessKind, this.writeAccessKind, this.excluded, this.visitorContext, this.doc);
    }

    public PropertyElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (PropertyElement)super.withAnnotationMetadata(annotationMetadata);
    }

    private static JavaNativeElement selectNativeType(MethodElement getter, MethodElement setter, FieldElement field) {
        if (getter != null) {
            return (JavaNativeElement)getter.getNativeType();
        }
        if (setter != null) {
            return (JavaNativeElement)setter.getNativeType();
        }
        if (field != null) {
            return (JavaNativeElement)field.getNativeType();
        }
        throw new IllegalStateException();
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public ElementAnnotationMetadata getElementAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @NonNull
    public ClassElement getType() {
        return this.type;
    }

    @NonNull
    public ClassElement getGenericType() {
        return this.type;
    }

    public Optional<FieldElement> getField() {
        return Optional.ofNullable(this.field);
    }

    public Optional<MethodElement> getWriteMethod() {
        return Optional.ofNullable(this.setter);
    }

    public Optional<MethodElement> getReadMethod() {
        return Optional.ofNullable(this.getter);
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public PropertyElement.AccessKind getReadAccessKind() {
        return this.readAccessKind;
    }

    public PropertyElement.AccessKind getWriteAccessKind() {
        return this.writeAccessKind;
    }

    public boolean isReadOnly() {
        return switch (this.writeAccessKind) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyElement.AccessKind.METHOD -> {
                if (this.setter == null) {
                    yield true;
                }
                yield false;
            }
            case PropertyElement.AccessKind.FIELD -> this.field == null || this.field.isFinal();
        };
    }

    public boolean isWriteOnly() {
        return switch (this.readAccessKind) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyElement.AccessKind.METHOD -> {
                if (this.getter == null) {
                    yield true;
                }
                yield false;
            }
            case PropertyElement.AccessKind.FIELD -> this.field == null;
        };
    }

    public ClassElement getDeclaringType() {
        if (this.field != null) {
            return this.field.getDeclaringType();
        }
        if (this.getter != null) {
            return this.getter.getDeclaringType();
        }
        if (this.setter != null) {
            return this.setter.getDeclaringType();
        }
        throw new IllegalStateException();
    }

    public ClassElement getOwningType() {
        return this.owningElement;
    }

    @Override
    public Optional<String> getDocumentation(boolean parse) {
        return !parse || this.doc == null ? super.getDocumentation(parse) : Optional.of(this.doc);
    }
}

