/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class GenericUtils {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final ModelUtils modelUtils;

    protected GenericUtils(Elements elementUtils, Types typeUtils, ModelUtils modelUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.modelUtils = modelUtils;
    }

    Map<String, Map<String, TypeMirror>> buildGenericTypeArgumentInfo(DeclaredType dt) {
        Element element = dt.asElement();
        return this.buildGenericTypeArgumentInfo(element, dt, Collections.emptyMap());
    }

    private Map<String, Map<String, TypeMirror>> buildGenericTypeArgumentInfo(@NonNull Element element, @Nullable DeclaredType dt, Map<String, TypeMirror> boundTypes) {
        List<? extends TypeMirror> typeArguments;
        LinkedHashMap<String, Map<String, TypeMirror>> beanTypeArguments = new LinkedHashMap<String, Map<String, TypeMirror>>();
        if (dt != null && CollectionUtils.isNotEmpty(typeArguments = dt.getTypeArguments())) {
            TypeElement typeElement = (TypeElement)element;
            Map<String, TypeMirror> directTypeArguments = this.resolveBoundTypes(dt);
            if (CollectionUtils.isNotEmpty(directTypeArguments)) {
                beanTypeArguments.put(typeElement.getQualifiedName().toString(), directTypeArguments);
            }
        }
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            if (CollectionUtils.isNotEmpty(boundTypes)) {
                beanTypeArguments.put(JavaModelUtils.getClassName((TypeElement)typeElement), boundTypes);
            }
            this.populateTypeArguments(typeElement, beanTypeArguments);
        }
        return beanTypeArguments;
    }

    public List<? extends TypeMirror> interfaceGenericTypesFor(TypeElement element, String interfaceName) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement te;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            Element declaredElement = declaredType.asElement();
            if (!(declaredElement instanceof TypeElement) || !interfaceName.equals((te = (TypeElement)declaredElement).getQualifiedName().toString())) continue;
            return declaredType.getTypeArguments();
        }
        return Collections.emptyList();
    }

    private Map<String, TypeMirror> resolveGenericTypes(DeclaredType type, TypeElement typeElement, Map<String, TypeMirror> boundTypes) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        LinkedHashMap<String, TypeMirror> resolvedParameters = new LinkedHashMap<String, TypeMirror>();
        List<? extends TypeParameterElement> typeParameters = typeElement.getTypeParameters();
        if (typeArguments.size() == typeParameters.size()) {
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                String parameterName = typeParameterElement.toString();
                TypeMirror mirror = i.next();
                TypeKind kind = mirror.getKind();
                switch (kind) {
                    case DECLARED: {
                        resolvedParameters.put(parameterName, mirror);
                        break;
                    }
                    case TYPEVAR: {
                        TypeVariable tv = (TypeVariable)mirror;
                        if (boundTypes.containsKey(tv.toString())) {
                            resolvedParameters.put(parameterName, boundTypes.get(tv.toString()));
                            break;
                        }
                        TypeMirror upperBound = tv.getUpperBound();
                        TypeMirror lowerBound = tv.getLowerBound();
                        if (upperBound.getKind() != TypeKind.NULL) {
                            resolvedParameters.put(parameterName, this.resolveTypeReference(upperBound, boundTypes));
                            break;
                        }
                        if (lowerBound.getKind() == TypeKind.NULL) break;
                        resolvedParameters.put(parameterName, this.resolveTypeReference(lowerBound, boundTypes));
                        break;
                    }
                    case ARRAY: 
                    case BOOLEAN: 
                    case BYTE: 
                    case CHAR: 
                    case DOUBLE: 
                    case FLOAT: 
                    case INT: 
                    case LONG: 
                    case SHORT: {
                        this.resolveGenericTypeParameter(resolvedParameters, parameterName, mirror, boundTypes);
                        break;
                    }
                    case WILDCARD: {
                        WildcardType wcType = (WildcardType)mirror;
                        TypeMirror extendsBound = wcType.getExtendsBound();
                        TypeMirror superBound = wcType.getSuperBound();
                        if (extendsBound != null) {
                            this.resolveGenericTypeParameter(resolvedParameters, parameterName, extendsBound, boundTypes);
                            break;
                        }
                        if (superBound != null) {
                            if (superBound instanceof TypeVariable) {
                                TypeVariable superTypeVar = (TypeVariable)superBound;
                                TypeMirror upperBound = superTypeVar.getUpperBound();
                                if (upperBound == null || type.equals(upperBound)) break;
                                this.resolveGenericTypeParameter(resolvedParameters, parameterName, superBound, boundTypes);
                                break;
                            }
                            this.resolveGenericTypeParameter(resolvedParameters, parameterName, superBound, boundTypes);
                            break;
                        }
                        resolvedParameters.put(parameterName, this.elementUtils.getTypeElement(Object.class.getName()).asType());
                        break;
                    }
                }
            }
        }
        return resolvedParameters;
    }

    protected TypeMirror resolveTypeReference(TypeMirror mirror, Map<String, TypeMirror> boundTypes) {
        TypeKind kind = mirror.getKind();
        switch (kind) {
            case TYPEVAR: {
                TypeVariable tv = (TypeVariable)mirror;
                String name = tv.toString();
                if (boundTypes.containsKey(name)) {
                    return boundTypes.get(name);
                }
                return this.resolveTypeReference(tv.getUpperBound(), boundTypes);
            }
            case WILDCARD: {
                WildcardType wcType = (WildcardType)mirror;
                TypeMirror extendsBound = wcType.getExtendsBound();
                TypeMirror superBound = wcType.getSuperBound();
                if (extendsBound == null && superBound == null) {
                    return this.elementUtils.getTypeElement(Object.class.getName()).asType();
                }
                if (extendsBound != null) {
                    return this.resolveTypeReference(this.typeUtils.erasure(extendsBound), boundTypes);
                }
                return this.resolveTypeReference(superBound, boundTypes);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)mirror;
                TypeMirror reference = this.resolveTypeReference(arrayType.getComponentType(), boundTypes);
                return this.typeUtils.getArrayType(reference);
            }
        }
        return this.modelUtils.resolveTypeReference(mirror);
    }

    protected Map<String, TypeMirror> resolveBoundTypes(DeclaredType type) {
        LinkedHashMap<String, TypeMirror> boundTypes = new LinkedHashMap<String, TypeMirror>(2);
        TypeElement element = (TypeElement)type.asElement();
        List<? extends TypeParameterElement> typeParameters = element.getTypeParameters();
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.size() == typeParameters.size()) {
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                boundTypes.put(typeParameterElement.toString(), this.resolveTypeReference(i.next(), boundTypes));
            }
        }
        return boundTypes;
    }

    private void resolveGenericTypeParameter(Map<String, TypeMirror> resolvedParameters, String parameterName, TypeMirror mirror, Map<String, TypeMirror> boundTypes) {
        if (mirror instanceof DeclaredType) {
            resolvedParameters.put(parameterName, mirror);
        } else if (mirror instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)mirror;
            String variableName = tv.toString();
            if (boundTypes.containsKey(variableName)) {
                resolvedParameters.put(parameterName, boundTypes.get(variableName));
            } else {
                TypeMirror upperBound = tv.getUpperBound();
                if (upperBound instanceof DeclaredType) {
                    this.resolveGenericTypeParameter(resolvedParameters, parameterName, upperBound, boundTypes);
                }
            }
        }
    }

    private void populateTypeArguments(TypeElement typeElement, Map<String, Map<String, TypeMirror>> typeArguments) {
        TypeElement current = typeElement;
        while (current != null) {
            this.populateTypeArgumentsForInterfaces(typeArguments, current);
            TypeMirror superclass = current.getSuperclass();
            if (superclass.getKind() == TypeKind.NONE) {
                current = null;
                continue;
            }
            if (!(superclass instanceof DeclaredType)) break;
            DeclaredType dt = (DeclaredType)superclass;
            List<? extends TypeMirror> superArguments = dt.getTypeArguments();
            Element te = dt.asElement();
            if (!(te instanceof TypeElement)) break;
            TypeElement element = (TypeElement)te;
            TypeElement child = current;
            current = element;
            if (!CollectionUtils.isNotEmpty(superArguments)) continue;
            Map<String, TypeMirror> boundTypes = typeArguments.get(JavaModelUtils.getClassName((TypeElement)child));
            if (boundTypes != null) {
                Map<String, TypeMirror> types = this.resolveGenericTypes(dt, current, boundTypes);
                String name = JavaModelUtils.getClassName((TypeElement)current);
                typeArguments.put(name, types);
                continue;
            }
            List<? extends TypeParameterElement> typeParameters = current.getTypeParameters();
            LinkedHashMap<String, TypeMirror> types = new LinkedHashMap<String, TypeMirror>(typeParameters.size());
            if (typeParameters.size() == superArguments.size()) {
                Iterator<? extends TypeMirror> i = superArguments.iterator();
                for (TypeParameterElement typeParameterElement : typeParameters) {
                    String n = typeParameterElement.getSimpleName().toString();
                    types.put(n, i.next());
                }
            }
            typeArguments.put(JavaModelUtils.getClassName((TypeElement)current), types);
        }
    }

    private void populateTypeArgumentsForInterfaces(Map<String, Map<String, TypeMirror>> typeArguments, TypeElement child) {
        for (TypeMirror typeMirror : child.getInterfaces()) {
            DeclaredType declaredType;
            Element element;
            if (!(typeMirror instanceof DeclaredType) || !((element = (declaredType = (DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
            TypeElement te = (TypeElement)element;
            String name = JavaModelUtils.getClassName((TypeElement)te);
            if (!typeArguments.containsKey(name)) {
                Map<String, TypeMirror> types;
                Map<String, TypeMirror> boundTypes = typeArguments.get(JavaModelUtils.getClassName((TypeElement)child));
                if (boundTypes == null) {
                    boundTypes = Collections.emptyMap();
                }
                if (!(types = this.resolveGenericTypes(declaredType, te, boundTypes)).isEmpty()) {
                    typeArguments.put(name, types);
                }
            }
            this.populateTypeArgumentsForInterfaces(typeArguments, te);
        }
    }
}

