/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PropertyElement;
import java.util.Collections;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Internal
class JavaPropertyElement
extends AbstractJavaElement
implements PropertyElement {
    private final String name;
    private final ClassElement type;
    private final boolean readOnly;
    private final ClassElement declaringElement;
    private final JavaVisitorContext visitorContext;

    JavaPropertyElement(ClassElement declaringElement, Element rootElement, AnnotationMetadata annotationMetadata, String name, ClassElement type, boolean readOnly, JavaVisitorContext visitorContext) {
        super(rootElement, annotationMetadata, visitorContext);
        this.name = name;
        this.type = type;
        this.readOnly = readOnly;
        this.declaringElement = declaringElement;
        this.visitorContext = visitorContext;
    }

    @Deprecated
    JavaPropertyElement(ClassElement declaringElement, ExecutableElement rootElement, AnnotationMetadata annotationMetadata, String name, ClassElement type, boolean readOnly, JavaVisitorContext visitorContext) {
        this(declaringElement, (Element)rootElement, annotationMetadata, name, type, readOnly, visitorContext);
    }

    public ClassElement getGenericType() {
        Map<String, Map<String, TypeMirror>> declaredGenericInfo = this.declaringElement instanceof JavaClassElement ? ((JavaClassElement)this.declaringElement).getGenericTypeInfo() : Collections.emptyMap();
        return this.parameterizedClassElement(((TypeElement)this.type.getNativeType()).asType(), this.visitorContext, declaredGenericInfo);
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public int getArrayDimensions() {
        return this.type.getArrayDimensions();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @NonNull
    public ClassElement getType() {
        return this.type;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ClassElement getDeclaringType() {
        return this.declaringElement;
    }
}

