/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class GenericUtils {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final ModelUtils modelUtils;

    protected GenericUtils(Elements elementUtils, Types typeUtils, ModelUtils modelUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.modelUtils = modelUtils;
    }

    Map<String, Map<String, TypeMirror>> buildGenericTypeArgumentInfo(DeclaredType dt) {
        Element element = dt.asElement();
        return this.buildGenericTypeArgumentInfo(element, dt);
    }

    public Map<String, Map<String, TypeMirror>> buildGenericTypeArgumentElementInfo(@NonNull Element element) {
        return this.buildGenericTypeArgumentElementInfo(element, null);
    }

    public Map<String, Map<String, TypeMirror>> buildGenericTypeArgumentElementInfo(@NonNull Element element, @Nullable DeclaredType declaredType) {
        return this.buildGenericTypeArgumentInfo(element, declaredType);
    }

    private Map<String, Map<String, TypeMirror>> buildGenericTypeArgumentInfo(@NonNull Element element, @Nullable DeclaredType dt) {
        List<? extends TypeMirror> typeArguments;
        LinkedHashMap<String, Map<String, TypeMirror>> beanTypeArguments = new LinkedHashMap<String, Map<String, TypeMirror>>();
        if (dt != null && CollectionUtils.isNotEmpty(typeArguments = dt.getTypeArguments())) {
            TypeElement typeElement = (TypeElement)element;
            Map<String, TypeMirror> directTypeArguments = this.resolveBoundTypes(dt);
            if (CollectionUtils.isNotEmpty(directTypeArguments)) {
                beanTypeArguments.put(typeElement.getQualifiedName().toString(), directTypeArguments);
            }
        }
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            this.populateTypeArguments(typeElement, beanTypeArguments);
        }
        return beanTypeArguments;
    }

    public List<? extends TypeMirror> interfaceGenericTypesFor(TypeElement element, String interfaceName) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement te;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            Element declaredElement = declaredType.asElement();
            if (!(declaredElement instanceof TypeElement) || !interfaceName.equals((te = (TypeElement)declaredElement).getQualifiedName().toString())) continue;
            return declaredType.getTypeArguments();
        }
        return Collections.emptyList();
    }

    protected Optional<TypeMirror> getFirstTypeArgument(TypeMirror type) {
        DeclaredType declaredType;
        List<? extends TypeMirror> typeArguments;
        TypeMirror typeMirror = null;
        if (type instanceof DeclaredType && CollectionUtils.isNotEmpty(typeArguments = (declaredType = (DeclaredType)type).getTypeArguments())) {
            typeMirror = typeArguments.get(0);
        }
        return Optional.ofNullable(typeMirror);
    }

    private Map<String, TypeMirror> resolveGenericTypes(DeclaredType type, TypeElement typeElement, Map<String, TypeMirror> boundTypes) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        LinkedHashMap<String, TypeMirror> resolvedParameters = new LinkedHashMap<String, TypeMirror>();
        List<? extends TypeParameterElement> typeParameters = typeElement.getTypeParameters();
        if (typeArguments.size() == typeParameters.size()) {
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                String parameterName = typeParameterElement.toString();
                TypeMirror mirror = i.next();
                TypeKind kind = mirror.getKind();
                switch (kind) {
                    case DECLARED: {
                        resolvedParameters.put(parameterName, mirror);
                        break;
                    }
                    case TYPEVAR: {
                        TypeVariable tv = (TypeVariable)mirror;
                        if (boundTypes.containsKey(tv.toString())) {
                            resolvedParameters.put(parameterName, boundTypes.get(tv.toString()));
                            break;
                        }
                        TypeMirror upperBound = tv.getUpperBound();
                        TypeMirror lowerBound = tv.getLowerBound();
                        if (upperBound.getKind() != TypeKind.NULL) {
                            resolvedParameters.put(parameterName, this.resolveTypeReference(upperBound, boundTypes));
                            break;
                        }
                        if (lowerBound.getKind() == TypeKind.NULL) break;
                        resolvedParameters.put(parameterName, this.resolveTypeReference(lowerBound, boundTypes));
                        break;
                    }
                    case ARRAY: 
                    case BOOLEAN: 
                    case BYTE: 
                    case CHAR: 
                    case DOUBLE: 
                    case FLOAT: 
                    case INT: 
                    case LONG: 
                    case SHORT: {
                        this.resolveGenericTypeParameter(resolvedParameters, parameterName, mirror, boundTypes);
                        break;
                    }
                    case WILDCARD: {
                        WildcardType wcType = (WildcardType)mirror;
                        TypeMirror extendsBound = wcType.getExtendsBound();
                        TypeMirror superBound = wcType.getSuperBound();
                        if (extendsBound != null) {
                            this.resolveGenericTypeParameter(resolvedParameters, parameterName, extendsBound, boundTypes);
                            break;
                        }
                        if (superBound != null) {
                            if (superBound instanceof TypeVariable) {
                                TypeVariable superTypeVar = (TypeVariable)superBound;
                                TypeMirror upperBound = superTypeVar.getUpperBound();
                                if (upperBound == null || type.equals(upperBound)) break;
                                this.resolveGenericTypeParameter(resolvedParameters, parameterName, superBound, boundTypes);
                                break;
                            }
                            this.resolveGenericTypeParameter(resolvedParameters, parameterName, superBound, boundTypes);
                            break;
                        }
                        resolvedParameters.put(parameterName, this.elementUtils.getTypeElement(Object.class.getName()).asType());
                    }
                }
            }
        }
        return resolvedParameters;
    }

    protected TypeMirror resolveTypeReference(TypeMirror mirror) {
        return this.resolveTypeReference(mirror, Collections.emptyMap());
    }

    protected TypeMirror resolveTypeReference(TypeMirror mirror, Map<String, TypeMirror> boundTypes) {
        TypeKind kind = mirror.getKind();
        switch (kind) {
            case TYPEVAR: {
                TypeVariable tv = (TypeVariable)mirror;
                String name = tv.toString();
                if (boundTypes.containsKey(name)) {
                    return boundTypes.get(name);
                }
                return this.resolveTypeReference(tv.getUpperBound(), boundTypes);
            }
            case WILDCARD: {
                WildcardType wcType = (WildcardType)mirror;
                TypeMirror extendsBound = wcType.getExtendsBound();
                TypeMirror superBound = wcType.getSuperBound();
                if (extendsBound == null && superBound == null) {
                    return this.elementUtils.getTypeElement(Object.class.getName()).asType();
                }
                if (extendsBound != null) {
                    return this.resolveTypeReference(this.typeUtils.erasure(extendsBound), boundTypes);
                }
                return this.resolveTypeReference(superBound, boundTypes);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)mirror;
                TypeMirror reference = this.resolveTypeReference(arrayType.getComponentType(), boundTypes);
                return this.typeUtils.getArrayType(reference);
            }
        }
        return this.modelUtils.resolveTypeReference(mirror);
    }

    protected Map<String, TypeMirror> resolveBoundTypes(DeclaredType type) {
        LinkedHashMap<String, TypeMirror> boundTypes = new LinkedHashMap<String, TypeMirror>(2);
        TypeElement element = (TypeElement)type.asElement();
        List<? extends TypeParameterElement> typeParameters = element.getTypeParameters();
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.size() == typeParameters.size()) {
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                boundTypes.put(typeParameterElement.toString(), this.resolveTypeReference(i.next(), boundTypes));
            }
        }
        return boundTypes;
    }

    public Map<String, Map<String, TypeMirror>> alignNewGenericsInfo(TypeElement typeElement, List<? extends TypeMirror> typeArguments, Map<String, TypeMirror> genericsInfo) {
        String typeName = typeElement.getQualifiedName().toString();
        List<? extends TypeParameterElement> typeParameters = typeElement.getTypeParameters();
        Map<String, TypeMirror> resolved = this.alignNewGenericsInfo(typeParameters, typeArguments, genericsInfo);
        if (!resolved.isEmpty()) {
            return Collections.singletonMap(typeName, resolved);
        }
        return Collections.emptyMap();
    }

    public Map<String, TypeMirror> alignNewGenericsInfo(List<? extends TypeParameterElement> typeParameters, List<? extends TypeMirror> typeArguments, Map<String, TypeMirror> genericsInfo) {
        if (typeArguments.size() == typeParameters.size()) {
            HashMap<String, TypeMirror> resolved = new HashMap<String, TypeMirror>(typeArguments.size());
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                TypeMirror typeParameterMirror = i.next();
                String variableName = typeParameterElement.getSimpleName().toString();
                this.resolveVariableForMirror(genericsInfo, resolved, variableName, typeParameterMirror);
            }
            return resolved;
        }
        return Collections.emptyMap();
    }

    private void resolveVariableForMirror(Map<String, TypeMirror> genericsInfo, Map<String, TypeMirror> resolved, String variableName, TypeMirror mirror) {
        if (mirror instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)mirror;
            this.resolveTypeVariable(genericsInfo, resolved, variableName, tv);
        } else if (mirror instanceof WildcardType) {
            WildcardType wt = (WildcardType)mirror;
            TypeMirror extendsBound = wt.getExtendsBound();
            if (extendsBound != null) {
                this.resolveVariableForMirror(genericsInfo, resolved, variableName, extendsBound);
            } else {
                TypeMirror superBound = wt.getSuperBound();
                this.resolveVariableForMirror(genericsInfo, resolved, variableName, superBound);
            }
        } else if (mirror instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)mirror;
            List<? extends TypeMirror> typeArguments = dt.getTypeArguments();
            if (CollectionUtils.isNotEmpty(typeArguments) && CollectionUtils.isNotEmpty(genericsInfo)) {
                ArrayList<TypeMirror> resolvedArguments = new ArrayList<TypeMirror>(typeArguments.size());
                for (TypeMirror typeMirror : typeArguments) {
                    if (typeMirror instanceof TypeVariable) {
                        TypeVariable tv = (TypeVariable)typeMirror;
                        String name = tv.toString();
                        TypeMirror bound = genericsInfo.get(name);
                        if (bound != null) {
                            resolvedArguments.add(bound);
                            continue;
                        }
                        resolvedArguments.add(typeMirror);
                        continue;
                    }
                    resolvedArguments.add(typeMirror);
                }
                TypeMirror[] typeMirrors = resolvedArguments.toArray(new TypeMirror[0]);
                resolved.put(variableName, this.typeUtils.getDeclaredType((TypeElement)dt.asElement(), typeMirrors));
            } else {
                resolved.put(variableName, mirror);
            }
        } else if (mirror instanceof ArrayType) {
            resolved.put(variableName, mirror);
        }
    }

    private void resolveTypeVariable(Map<String, TypeMirror> genericsInfo, Map<String, TypeMirror> resolved, String variableName, TypeVariable variable) {
        String name = variable.toString();
        TypeMirror element = genericsInfo.get(name);
        if (element != null) {
            if (element instanceof DeclaredType) {
                DeclaredType dt = (DeclaredType)element;
                List<? extends TypeMirror> typeArguments = dt.getTypeArguments();
                for (TypeMirror typeMirror : typeArguments) {
                    if (!(typeMirror instanceof TypeVariable)) continue;
                    TypeVariable tv = (TypeVariable)typeMirror;
                    TypeMirror upperBound = tv.getUpperBound();
                    if (upperBound instanceof DeclaredType) {
                        resolved.put(variableName, upperBound);
                        break;
                    }
                    TypeMirror lowerBound = tv.getLowerBound();
                    if (!(lowerBound instanceof DeclaredType)) continue;
                    resolved.put(variableName, lowerBound);
                    break;
                }
                if (!resolved.containsKey(variableName)) {
                    resolved.put(variableName, element);
                }
            } else {
                resolved.put(variableName, element);
            }
        } else {
            TypeMirror upperBound = variable.getUpperBound();
            if (upperBound instanceof TypeVariable) {
                this.resolveTypeVariable(genericsInfo, resolved, variableName, (TypeVariable)upperBound);
            } else if (upperBound instanceof DeclaredType) {
                resolved.put(variableName, upperBound);
            } else {
                TypeMirror lowerBound = variable.getLowerBound();
                if (lowerBound instanceof TypeVariable) {
                    this.resolveTypeVariable(genericsInfo, resolved, variableName, (TypeVariable)lowerBound);
                } else if (lowerBound instanceof DeclaredType) {
                    resolved.put(variableName, lowerBound);
                }
            }
        }
    }

    private void resolveGenericTypeParameter(Map<String, TypeMirror> resolvedParameters, String parameterName, TypeMirror mirror, Map<String, TypeMirror> boundTypes) {
        if (mirror instanceof DeclaredType) {
            resolvedParameters.put(parameterName, mirror);
        } else if (mirror instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)mirror;
            String variableName = tv.toString();
            if (boundTypes.containsKey(variableName)) {
                resolvedParameters.put(parameterName, boundTypes.get(variableName));
            } else {
                TypeMirror upperBound = tv.getUpperBound();
                if (upperBound instanceof DeclaredType) {
                    this.resolveGenericTypeParameter(resolvedParameters, parameterName, upperBound, boundTypes);
                }
            }
        }
    }

    private void populateTypeArguments(TypeElement typeElement, Map<String, Map<String, TypeMirror>> typeArguments) {
        TypeElement current = typeElement;
        while (current != null) {
            this.populateTypeArgumentsForInterfaces(typeArguments, current);
            TypeMirror superclass = current.getSuperclass();
            if (superclass.getKind() == TypeKind.NONE) {
                current = null;
                continue;
            }
            if (!(superclass instanceof DeclaredType)) break;
            DeclaredType dt = (DeclaredType)superclass;
            List<? extends TypeMirror> superArguments = dt.getTypeArguments();
            Element te = dt.asElement();
            if (!(te instanceof TypeElement)) break;
            TypeElement child = current;
            current = (TypeElement)te;
            if (!CollectionUtils.isNotEmpty(superArguments)) continue;
            Map<String, TypeMirror> boundTypes = typeArguments.get(child.getQualifiedName().toString());
            if (boundTypes != null) {
                Map<String, TypeMirror> types = this.resolveGenericTypes(dt, current, boundTypes);
                String name = current.getQualifiedName().toString();
                typeArguments.put(name, types);
                continue;
            }
            List<? extends TypeParameterElement> typeParameters = current.getTypeParameters();
            LinkedHashMap<String, TypeMirror> types = new LinkedHashMap<String, TypeMirror>(typeParameters.size());
            if (typeParameters.size() == superArguments.size()) {
                Iterator<? extends TypeMirror> i = superArguments.iterator();
                for (TypeParameterElement typeParameterElement : typeParameters) {
                    String n = typeParameterElement.getSimpleName().toString();
                    types.put(n, i.next());
                }
            }
            String name = current.getQualifiedName().toString();
            typeArguments.put(name, types);
        }
    }

    private void populateTypeArgumentsForInterfaces(Map<String, Map<String, TypeMirror>> typeArguments, TypeElement child) {
        for (TypeMirror typeMirror : child.getInterfaces()) {
            DeclaredType declaredType;
            Element element;
            if (!(typeMirror instanceof DeclaredType) || !((element = (declaredType = (DeclaredType)typeMirror).asElement()) instanceof TypeElement)) continue;
            TypeElement te = (TypeElement)element;
            String name = te.getQualifiedName().toString();
            if (!typeArguments.containsKey(name)) {
                Map<String, TypeMirror> boundTypes = typeArguments.get(child.getQualifiedName().toString());
                if (boundTypes == null) {
                    boundTypes = Collections.emptyMap();
                }
                Map<String, TypeMirror> types = this.resolveGenericTypes(declaredType, te, boundTypes);
                typeArguments.put(name, types);
            }
            this.populateTypeArgumentsForInterfaces(typeArguments, te);
        }
    }
}

