/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.GenericUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor8;
import javax.lang.model.util.Types;

public abstract class SuperclassAwareTypeVisitor<R, P>
extends AbstractTypeVisitor8<R, P> {
    private final Set<String> processed = new HashSet<String>();
    private final Types types;
    private final GenericUtils genericUtils;
    private final ModelUtils modelUtils;

    protected SuperclassAwareTypeVisitor(JavaVisitorContext visitorContext) {
        this.types = visitorContext.getTypes();
        this.genericUtils = visitorContext.getGenericUtils();
        this.modelUtils = visitorContext.getModelUtils();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public R visitDeclared(DeclaredType type, P p) {
        Element element = type.asElement();
        if ((JavaModelUtils.isClassOrInterface((Element)element) || JavaModelUtils.isEnum((Element)element)) && !element.toString().equals(Object.class.getName()) && !element.toString().equals(Enum.class.getName())) {
            TypeElement typeElement = (TypeElement)element;
            List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
            for (Element element2 : enclosedElements) {
                ExecutableElement executableElement;
                Set<Modifier> modifiers;
                boolean isAcceptable = this.isAcceptable(element2);
                if (isAcceptable) {
                    void var9_14;
                    if (element2 instanceof ExecutableElement) {
                        String string = this.buildQualifiedName(type, typeElement, (ExecutableElement)element2);
                    } else {
                        String string = this.types.erasure(element2.asType()).toString() + "." + element2.getSimpleName().toString();
                    }
                    if (this.processed.contains(var9_14)) continue;
                    this.processed.add((String)var9_14);
                    this.accept(type, element2, p);
                    continue;
                }
                if (!(element2 instanceof ExecutableElement) || (modifiers = (executableElement = (ExecutableElement)element2).getModifiers()).contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) continue;
                String qualifiedName = this.buildQualifiedName(type, typeElement, executableElement);
                this.processed.add(qualifiedName);
            }
            TypeMirror superMirror = typeElement.getSuperclass();
            if (superMirror instanceof DeclaredType) {
                this.visitDeclared((DeclaredType)superMirror, p);
            }
            List<? extends TypeMirror> list = typeElement.getInterfaces();
            for (TypeMirror typeMirror : list) {
                if (!(typeMirror instanceof DeclaredType)) continue;
                DeclaredType interfaceType = (DeclaredType)typeMirror;
                this.visitDeclared(interfaceType, p);
            }
        }
        return null;
    }

    protected abstract boolean isAcceptable(Element var1);

    protected abstract void accept(DeclaredType var1, Element var2, P var3);

    @Override
    public R visitIntersection(IntersectionType t, P p) {
        return null;
    }

    @Override
    public R visitPrimitive(PrimitiveType t, P p) {
        return null;
    }

    @Override
    public R visitNull(NullType t, P p) {
        return null;
    }

    @Override
    public R visitArray(ArrayType t, P p) {
        return null;
    }

    @Override
    public R visitError(ErrorType t, P p) {
        return null;
    }

    @Override
    public R visitTypeVariable(TypeVariable t, P p) {
        return null;
    }

    @Override
    public R visitWildcard(WildcardType t, P p) {
        return null;
    }

    @Override
    public R visitExecutable(ExecutableType t, P p) {
        return null;
    }

    @Override
    public R visitNoType(NoType t, P p) {
        return null;
    }

    @Override
    public R visitUnion(UnionType t, P p) {
        return null;
    }

    private String buildQualifiedName(DeclaredType type, TypeElement typeElement, ExecutableElement enclosedElement) {
        Map<String, Object> generics;
        ExecutableElement ee = enclosedElement;
        String qualifiedName = ee.getSimpleName().toString();
        qualifiedName = qualifiedName + "(" + ee.getParameters().stream().map(variableElement -> this.types.erasure(variableElement.asType()).toString()).collect(Collectors.joining(",")) + ")";
        TypeMirror returnTypeMirror = ee.getReturnType();
        String returnType = null;
        if (returnTypeMirror.getKind() == TypeKind.TYPEVAR && (generics = this.genericUtils.buildGenericTypeArgumentInfo(type).get(typeElement.getQualifiedName().toString())) != null && generics.containsKey(returnTypeMirror.toString())) {
            returnType = generics.get(returnTypeMirror.toString()).toString();
        }
        if (returnType == null) {
            returnType = this.modelUtils.resolveTypeName(returnTypeMirror);
        }
        qualifiedName = returnType + "." + qualifiedName;
        return qualifiedName;
    }
}

