/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@ConfigurationProperties(value="micronaut.function.binary-types")
public class BinaryTypeConfiguration {
    static final String PREFIX = "micronaut.function.binary-types";
    private static final Set<String> DEFAULT_BINARY_TYPES = Set.of("application/octet-stream", "image/jpeg", "image/png", "image/gif", "application/zip");
    private boolean useDefaultBinaryTypes = true;
    @NonNull
    private List<String> additionalTypes = new ArrayList<String>();

    public boolean isUseDefaults() {
        return this.useDefaultBinaryTypes;
    }

    public void setUseDefaults(boolean useDefaults) {
        this.useDefaultBinaryTypes = useDefaults;
    }

    @NonNull
    public List<String> getAdditionalTypes() {
        return this.additionalTypes;
    }

    public void setAdditionalTypes(@NonNull List<String> additionalTypes) {
        ArgumentUtils.requireNonNull((String)"additionalTypes", additionalTypes);
        this.additionalTypes = additionalTypes;
    }

    public boolean isMediaTypeBinary(String mediaType) {
        if (mediaType == null) {
            return false;
        }
        if (this.useDefaultBinaryTypes && DEFAULT_BINARY_TYPES.contains(mediaType)) {
            return true;
        }
        return this.additionalTypes.contains(mediaType);
    }
}

