/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client.local;

import io.micronaut.context.annotation.Requires;
import io.micronaut.function.LocalFunctionRegistry;
import io.micronaut.function.client.FunctionDefinition;
import io.micronaut.function.client.FunctionDefinitionProvider;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Requires(beans={EmbeddedServer.class, LocalFunctionRegistry.class})
@Singleton
public class LocalFunctionDefinitionProvider
implements FunctionDefinitionProvider {
    private final EmbeddedServer embeddedServer;
    private final LocalFunctionRegistry localFunctionRegistry;

    public LocalFunctionDefinitionProvider(EmbeddedServer embeddedServer, LocalFunctionRegistry localFunctionRegistry) {
        this.embeddedServer = embeddedServer;
        this.localFunctionRegistry = localFunctionRegistry;
    }

    @Override
    public Collection<FunctionDefinition> getFunctionDefinitions() {
        if (!this.embeddedServer.isRunning()) {
            return Collections.emptyList();
        }
        Map availableFunctions = this.localFunctionRegistry.getAvailableFunctions();
        return availableFunctions.entrySet().stream().map(stringURIEntry -> new FunctionDefinition(){
            final /* synthetic */ Map.Entry val$stringURIEntry;
            {
                this.val$stringURIEntry = entry;
            }

            @Override
            public String getName() {
                return (String)this.val$stringURIEntry.getKey();
            }

            @Override
            public Optional<URI> getURI() {
                return Optional.of(LocalFunctionDefinitionProvider.this.embeddedServer.getURI().resolve((URI)this.val$stringURIEntry.getValue()));
            }
        }).collect(Collectors.toList());
    }
}

