/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.function.client;

import io.micronaut.context.annotation.Primary;
import io.micronaut.function.client.FunctionDefinition;
import io.micronaut.function.client.FunctionInvoker;
import io.micronaut.function.client.FunctionInvokerChooser;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Primary
class DefaultFunctionInvokerChooser
implements FunctionInvokerChooser {
    private final FunctionInvokerChooser[] choosers;

    DefaultFunctionInvokerChooser(FunctionInvokerChooser[] choosers) {
        this.choosers = choosers;
    }

    @Override
    public <I, O> Optional<FunctionInvoker<I, O>> choose(FunctionDefinition definition) {
        for (FunctionInvokerChooser chooser : this.choosers) {
            Optional chosen = chooser.choose(definition);
            if (!chosen.isPresent()) continue;
            return chosen;
        }
        return Optional.empty();
    }
}

