/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.reactive;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCriteriaCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCriteriaRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveSpecificationInterceptor<T, R>
extends AbstractSpecificationInterceptor<T, R> {
    protected final ReactiveRepositoryOperations reactiveOperations;
    protected final ReactiveCriteriaRepositoryOperations reactiveCriteriaOperations;

    protected AbstractReactiveSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof ReactiveCapableRepository)) {
            throw new DataAccessException("Datastore of type [" + operations.getClass() + "] does not support reactive operations");
        }
        ReactiveCapableRepository reactiveCapableRepository = (ReactiveCapableRepository)operations;
        this.reactiveOperations = reactiveCapableRepository.reactive();
        ReactiveRepositoryOperations reactiveRepositoryOperations = this.reactiveOperations;
        if (reactiveRepositoryOperations instanceof ReactiveCriteriaRepositoryOperations) {
            ReactiveCriteriaRepositoryOperations reactiveCriteriaRepositoryOperations;
            this.reactiveCriteriaOperations = reactiveCriteriaRepositoryOperations = (ReactiveCriteriaRepositoryOperations)reactiveRepositoryOperations;
        } else if (operations instanceof ReactiveCriteriaRepositoryOperations) {
            ReactiveCriteriaRepositoryOperations reactiveCriteriaRepositoryOperations;
            this.reactiveCriteriaOperations = reactiveCriteriaRepositoryOperations = (ReactiveCriteriaRepositoryOperations)operations;
        } else if (operations instanceof ReactiveCriteriaCapableRepository) {
            ReactiveCriteriaCapableRepository repository = (ReactiveCriteriaCapableRepository)operations;
            this.reactiveCriteriaOperations = repository.reactive();
        } else {
            this.reactiveCriteriaOperations = null;
        }
    }

    @NonNull
    protected final Publisher<Object> findAllReactive(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, AbstractSpecificationInterceptor.Type type) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.reactiveCriteriaOperations != null) {
            CriteriaQuery criteriaQuery = this.buildQuery(context, type, methodJoinPaths);
            Pageable pageable = this.getPageable(context);
            if (pageable != null) {
                if (pageable.getMode() != Pageable.Mode.OFFSET) {
                    throw new UnsupportedOperationException("Pageable mode " + pageable.getMode() + " is not supported by hibernate operations");
                }
                return this.reactiveCriteriaOperations.findAll(criteriaQuery, (int)pageable.getOffset(), pageable.getSize());
            }
            return this.reactiveCriteriaOperations.findAll(criteriaQuery);
        }
        PreparedQuery preparedQuery = this.preparedQueryForCriteria(methodKey, context, type, methodJoinPaths);
        context.setAttribute((CharSequence)"PREPARED_QUERY", preparedQuery);
        return this.reactiveOperations.findAll(preparedQuery);
    }

    @NonNull
    protected final Publisher<Object> findOneReactive(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context, AbstractSpecificationInterceptor.Type type) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.reactiveCriteriaOperations != null) {
            return this.reactiveCriteriaOperations.findOne(this.buildQuery(context, type, methodJoinPaths));
        }
        return this.reactiveOperations.findOne(this.preparedQueryForCriteria(methodKey, context, type, methodJoinPaths));
    }

    @NonNull
    protected final Publisher<Long> countReactive(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.reactiveCriteriaOperations != null) {
            return this.reactiveCriteriaOperations.findOne(this.buildCountQuery(context));
        }
        return this.reactiveOperations.findOne(this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.COUNT, methodJoinPaths));
    }

    protected final Publisher<Boolean> existsReactive(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.reactiveCriteriaOperations != null) {
            return this.reactiveCriteriaOperations.findOne(this.buildExistsQuery(context, methodJoinPaths));
        }
        return Mono.from((Publisher)this.reactiveOperations.findOne(this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.EXISTS, methodJoinPaths))).map(one -> {
            Boolean aBoolean;
            return one instanceof Boolean ? (aBoolean = (Boolean)one) : Boolean.valueOf(one != null);
        });
    }

    protected final Publisher<Number> deleteAllReactive(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.reactiveCriteriaOperations != null) {
            return this.reactiveCriteriaOperations.deleteAll(this.buildDeleteQuery(context));
        }
        return this.reactiveOperations.executeDelete(this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.DELETE_ALL, methodJoinPaths));
    }

    protected final Publisher<Number> updateAllReactive(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        Set<JoinPath> methodJoinPaths = this.getMethodJoinPaths(methodKey, context);
        if (this.reactiveCriteriaOperations != null) {
            return this.reactiveCriteriaOperations.updateAll(this.buildUpdateQuery(context));
        }
        return this.reactiveOperations.executeUpdate(this.preparedQueryForCriteria(methodKey, context, AbstractSpecificationInterceptor.Type.UPDATE_ALL, methodJoinPaths));
    }
}

