/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.reactive;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import io.micronaut.data.runtime.intercept.criteria.reactive.AbstractReactiveSpecificationInterceptor;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
public class FindPageReactiveSpecificationInterceptor
extends AbstractReactiveSpecificationInterceptor<Object, Object> {
    protected FindPageReactiveSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Mono result;
        if (context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Pageable pageable = this.getPageable(context);
        if (pageable.isUnpaged()) {
            Flux results = Flux.from(this.findAllReactive(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_PAGE));
            result = results.collectList().map(resultList -> Page.of((List)resultList, (Pageable)pageable, (Long)Long.valueOf(resultList.size())));
        } else {
            result = Flux.from(this.findAllReactive(methodKey, context, AbstractSpecificationInterceptor.Type.FIND_PAGE)).collectList().flatMap(list -> pageable.requestTotal() ? Mono.from(this.countReactive(methodKey, context)).map(count -> Page.of((List)list, (Pageable)this.getPageable(context), (Long)count)) : Mono.just((Object)Page.of((List)list, (Pageable)this.getPageable(context), null)));
        }
        return Publishers.convertPublisher((ConversionService)this.conversionService, (Object)result, (Class)context.getReturnType().getType());
    }
}

