/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.operations.internal.AbstractCascadeOperations;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactiveCascadeOperations<Ctx extends OperationContext>
extends AbstractCascadeOperations {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveCascadeOperations.class);
    private final ReactiveCascadeOperationsHelper<Ctx> helper;

    public ReactiveCascadeOperations(ConversionService conversionService, ReactiveCascadeOperationsHelper<Ctx> helper) {
        super(conversionService);
        this.helper = helper;
    }

    public <T> Mono<T> cascadeEntity(Ctx ctx, T entity, RuntimePersistentEntity<T> persistentEntity, boolean isPost, Relation.Cascade cascadeType) {
        ArrayList<AbstractCascadeOperations.CascadeOp> cascadeOps = new ArrayList<AbstractCascadeOperations.CascadeOp>();
        this.cascade(((OperationContext)ctx).annotationMetadata, ((OperationContext)ctx).repositoryType, isPost, cascadeType, AbstractCascadeOperations.CascadeContext.of(((OperationContext)ctx).associations, entity, persistentEntity), persistentEntity, entity, cascadeOps);
        Mono<Object> monoEntity = Mono.just(entity);
        for (AbstractCascadeOperations.CascadeOp cascadeOp : cascadeOps) {
            if (cascadeOp instanceof AbstractCascadeOperations.CascadeOneOp) {
                AbstractCascadeOperations.CascadeOneOp cascadeOneOp = (AbstractCascadeOperations.CascadeOneOp)cascadeOp;
                Object child = cascadeOneOp.child;
                RuntimePersistentEntity childPersistentEntity = cascadeOneOp.childPersistentEntity;
                RuntimeAssociation association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
                if (((OperationContext)ctx).persisted.contains(child)) continue;
                monoEntity = monoEntity.flatMap(e -> {
                    Mono childMono;
                    Mono thisEntity;
                    boolean hasId;
                    RuntimePersistentProperty identity = childPersistentEntity.getIdentity();
                    boolean bl = hasId = identity.getProperty().get(child) != null;
                    if (cascadeType == Relation.Cascade.PERSIST && ReactiveCascadeOperations.shouldPersistChildOnPersist((RuntimePersistentEntity<Object>)childPersistentEntity, child)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Cascading one PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), cascadeOp.ctx.associations);
                        }
                        Mono persisted = this.helper.persistOne((OperationContext)ctx, child, childPersistentEntity).cache();
                        thisEntity = persisted.map(persistedEntity -> this.afterCascadedOne(e, cascadeOp.ctx.associations, child, persistedEntity));
                        childMono = persisted;
                    } else if (hasId && cascadeType == Relation.Cascade.UPDATE) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Cascading one UPDATE for '{}' ({}) association: '{}'", new Object[]{persistentEntity.getName(), persistentEntity.getIdentity().getProperty().get(entity), cascadeOp.ctx.associations});
                        }
                        Mono updated = this.helper.updateOne((OperationContext)ctx, child, childPersistentEntity).cache();
                        thisEntity = updated.map(updatedEntity -> this.afterCascadedOne(e, cascadeOp.ctx.associations, child, updatedEntity));
                        childMono = updated;
                    } else {
                        childMono = Mono.just((Object)child);
                        thisEntity = Mono.just((Object)e);
                    }
                    if (!hasId && (cascadeType == Relation.Cascade.PERSIST || cascadeType == Relation.Cascade.UPDATE) && SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association)) {
                        return childMono.flatMap(c -> {
                            if (ctx.persisted.contains(c)) {
                                return Mono.just((Object)e);
                            }
                            ctx.persisted.add(c);
                            return thisEntity.flatMap(e2 -> {
                                Mono<Void> op = this.helper.persistManyAssociation((OperationContext)ctx, association, e2, (RuntimePersistentEntity<Object>)persistentEntity, c, (RuntimePersistentEntity<Object>)childPersistentEntity);
                                return op.thenReturn(e2);
                            });
                        });
                    }
                    return childMono.flatMap(c -> {
                        ctx.persisted.add(c);
                        return thisEntity;
                    });
                });
                continue;
            }
            if (!(cascadeOp instanceof AbstractCascadeOperations.CascadeManyOp)) continue;
            AbstractCascadeOperations.CascadeManyOp cascadeManyOp = (AbstractCascadeOperations.CascadeManyOp)cascadeOp;
            RuntimePersistentEntity childPersistentEntity = cascadeManyOp.childPersistentEntity;
            if (cascadeType == Relation.Cascade.UPDATE) {
                monoEntity = this.updateChildren(ctx, monoEntity, cascadeOp, cascadeManyOp, (RuntimePersistentEntity<Object>)childPersistentEntity, e -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading many UPDATE for '{}' association: '{}'", (Object)persistentEntity.getName(), cascadeOp.ctx.associations);
                    }
                    Flux childrenFlux = Flux.empty();
                    for (Object child : cascadeManyOp.children) {
                        if (ctx.persisted.contains(child)) continue;
                        Mono<Object> modifiedEntity = childPersistentEntity.getIdentity().getProperty().get(child) == null ? this.helper.persistOne((OperationContext)ctx, child, childPersistentEntity) : this.helper.updateOne((OperationContext)ctx, child, childPersistentEntity);
                        childrenFlux = childrenFlux.concatWith(modifiedEntity);
                    }
                    return childrenFlux.collectList();
                });
                continue;
            }
            if (cascadeType != Relation.Cascade.PERSIST) continue;
            if (this.helper.isSupportsBatchInsert(ctx, persistentEntity)) {
                monoEntity = this.updateChildren(ctx, monoEntity, cascadeOp, cascadeManyOp, (RuntimePersistentEntity<Object>)childPersistentEntity, e -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading many PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), cascadeOp.ctx.associations);
                    }
                    RuntimeAssociation association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
                    Predicate<Object> veto = ReactiveCascadeOperations.batchPersistVeto((RuntimePersistentEntity<Object>)childPersistentEntity, (RuntimeAssociation<Object>)association, ctx.persisted);
                    Iterable<Object> sourceChildren = SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association) ? ReactiveCascadeOperations.deduplicateSourceForJoinBatch((RuntimePersistentEntity<Object>)childPersistentEntity, cascadeManyOp.children) : cascadeManyOp.children;
                    Flux childrenFlux = this.helper.persistBatch((OperationContext)ctx, sourceChildren, childPersistentEntity, veto);
                    for (Object child : sourceChildren) {
                        if (!veto.test(child)) continue;
                        childrenFlux = childrenFlux.concatWith((Publisher)Flux.just((Object)child));
                    }
                    return childrenFlux.collectList();
                });
                continue;
            }
            monoEntity = this.updateChildren(ctx, monoEntity, cascadeOp, cascadeManyOp, (RuntimePersistentEntity<Object>)childPersistentEntity, e -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cascading many PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), cascadeOp.ctx.associations);
                }
                Flux childrenFlux = Flux.empty();
                for (Object child : cascadeManyOp.children) {
                    if (ctx.persisted.contains(child) || childPersistentEntity.getIdentity().getProperty().get(child) != null) {
                        childrenFlux = childrenFlux.concatWith((Publisher)Mono.just((Object)child));
                        continue;
                    }
                    Mono<Object> persisted = this.helper.persistOne((OperationContext)ctx, child, childPersistentEntity);
                    childrenFlux = childrenFlux.concatWith(persisted);
                }
                return childrenFlux.collectList();
            });
        }
        return monoEntity;
    }

    private <T> Mono<T> updateChildren(Ctx ctx, Mono<T> monoEntity, AbstractCascadeOperations.CascadeOp cascadeOp, AbstractCascadeOperations.CascadeManyOp cascadeManyOp, RuntimePersistentEntity<Object> childPersistentEntity, Function<T, Mono<List<Object>>> fn) {
        monoEntity = monoEntity.flatMap(e -> ((Mono)fn.apply(e)).flatMap(newChildren -> {
            Object entityAfterCascade = this.afterCascadedMany(e, cascadeOp.ctx.associations, cascadeManyOp.children, (List<Object>)newChildren);
            RuntimeAssociation association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
            if (SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association)) {
                if (this.helper.isSupportsBatchInsert((OperationContext)ctx, cascadeOp.ctx.parentPersistentEntity)) {
                    Predicate<Object> veto = ctx.persisted::contains;
                    Mono<Void> op = this.helper.persistManyAssociationBatch((OperationContext)ctx, association, cascadeOp.ctx.parent, cascadeOp.ctx.parentPersistentEntity, (Iterable<Object>)newChildren, childPersistentEntity, veto);
                    return op.thenReturn(entityAfterCascade);
                }
                Mono res = Mono.just((Object)entityAfterCascade);
                for (Object child : newChildren) {
                    if (ctx.persisted.contains(child)) continue;
                    Mono<Void> op = this.helper.persistManyAssociation((OperationContext)ctx, association, cascadeOp.ctx.parent, cascadeOp.ctx.parentPersistentEntity, child, childPersistentEntity);
                    res = res.flatMap(arg_0 -> op.thenReturn(arg_0));
                }
                return res;
            }
            ctx.persisted.addAll((Collection<Object>)newChildren);
            return Mono.just((Object)entityAfterCascade);
        }));
        return monoEntity;
    }

    public static interface ReactiveCascadeOperationsHelper<Ctx extends OperationContext> {
        default public boolean isSupportsBatchInsert(Ctx ctx, RuntimePersistentEntity<?> persistentEntity) {
            return true;
        }

        default public boolean isSupportsBatchUpdate(Ctx ctx, RuntimePersistentEntity<?> persistentEntity) {
            return true;
        }

        default public boolean isSupportsBatchDelete(Ctx ctx, RuntimePersistentEntity<?> persistentEntity) {
            return true;
        }

        public <T> Mono<T> persistOne(Ctx var1, T var2, RuntimePersistentEntity<T> var3);

        public <T> Flux<T> persistBatch(Ctx var1, Iterable<T> var2, RuntimePersistentEntity<T> var3, Predicate<T> var4);

        public <T> Mono<T> updateOne(Ctx var1, T var2, RuntimePersistentEntity<T> var3);

        public Mono<Void> persistManyAssociation(Ctx var1, RuntimeAssociation var2, Object var3, RuntimePersistentEntity<Object> var4, Object var5, RuntimePersistentEntity<Object> var6);

        public Mono<Void> persistManyAssociationBatch(Ctx var1, RuntimeAssociation var2, Object var3, RuntimePersistentEntity<Object> var4, Iterable<Object> var5, RuntimePersistentEntity<Object> var6, Predicate<Object> var7);
    }
}

