/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.async.FindCursoredAsyncPageInterceptor;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.async.AbstractConvertCompletionStageInterceptor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Internal
public final class DefaultFindCursoredPageAsyncInterceptor
extends AbstractConvertCompletionStageInterceptor<CursoredPage<Object>>
implements FindCursoredAsyncPageInterceptor<Object> {
    public DefaultFindCursoredPageAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    @Override
    protected CompletionStage<?> interceptCompletionStage(RepositoryMethodKey methodKey, MethodInvocationContext<Object, CompletionStage<CursoredPage<Object>>> context) {
        Argument returnArgument;
        ReturnType returnType = context.getReturnType();
        Argument argument = returnArgument = returnType.isSuspended() ? returnType.asArgument() : returnType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery preparedQuery = this.prepareQuery(methodKey, context);
            return this.asyncDatastoreOperations.findPage(preparedQuery).thenCompose(page -> {
                if (!page.hasTotalSize() && preparedQuery.getPageable().requestTotal()) {
                    PreparedQuery<?, Number> countQuery = this.prepareCountQuery(methodKey, context);
                    Page page0 = page;
                    return this.asyncDatastoreOperations.findOne(countQuery).thenApply(n -> {
                        Long totalCount = n != null ? n.longValue() : -1L;
                        if (page0 instanceof CursoredPage) {
                            CursoredPage cursoredPage = (CursoredPage)page0;
                            return CursoredPage.of((List)cursoredPage.getContent(), (Pageable)cursoredPage.getPageable(), (List)cursoredPage.getCursors(), (Long)totalCount);
                        }
                        return Page.of((List)page0.getContent(), (Pageable)page0.getPageable(), (Long)totalCount);
                    });
                }
                return CompletableFuture.completedFuture(page);
            }).thenApply(page -> {
                if (returnArgument.isInstance(page)) {
                    return page;
                }
                return this.operations.getConversionService().convert(page, returnArgument).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + String.valueOf(returnArgument)));
            });
        }
        return this.asyncDatastoreOperations.findPage(this.getPagedQuery(context)).thenApply(page -> {
            if (returnArgument.isInstance(page)) {
                return page;
            }
            return this.operations.getConversionService().convert(page, returnArgument).orElseThrow(() -> new IllegalStateException("Unsupported page interface type " + String.valueOf(returnArgument)));
        });
    }
}

